/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.planner.internal.util;

import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0011J\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\rJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\rJ\u0015\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/partiql/planner/internal/util/DateTimeUtils;", "", "()V", "DATE_PATTERN", "Ljava/util/regex/Pattern;", "RFC8889_TIMESTAMP_DATE_TIME_DELIMITER", "Lkotlin/text/Regex;", "SQL_TIMESTAMP_DATE_TIME_DELIMITER", "TIMESTAMP_PATTERN", "TIME_PATTERN", "getTimeZoneComponent", "Ljava/time/ZoneOffset;", "timezone", "", "parseDate", "Ljava/time/LocalDate;", "input", "parseDate$partiql_planner", "parseTime", "Ljava/time/LocalTime;", "parseTime$partiql_planner", "parseTimestamp", "Ljava/time/LocalDateTime;", "parseTimestampz", "Ljava/time/OffsetDateTime;", "parseTimez", "Ljava/time/OffsetTime;", "parseTimez$partiql_planner", "partiql-planner"})
@SourceDebugExtension(value={"SMAP\nDateTimeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateTimeUtils.kt\norg/partiql/planner/internal/util/DateTimeUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
public final class DateTimeUtils {
    @NotNull
    public static final DateTimeUtils INSTANCE = new DateTimeUtils();
    @NotNull
    private static final Pattern DATE_PATTERN;
    @NotNull
    private static final Pattern TIME_PATTERN;
    @NotNull
    private static final Regex SQL_TIMESTAMP_DATE_TIME_DELIMITER;
    @NotNull
    private static final Regex RFC8889_TIMESTAMP_DATE_TIME_DELIMITER;
    @NotNull
    private static final Pattern TIMESTAMP_PATTERN;

    private DateTimeUtils() {
    }

    @NotNull
    public final LocalDate parseDate$partiql_planner(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Matcher matcher = DATE_PATTERN.matcher(input);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
        Matcher matcher2 = matcher;
        if (!matcher2.matches()) {
            throw new DateTimeException("Expected Date Format to be in YYYY-MM-DD, received " + input);
        }
        String string = matcher2.group("year");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
        int year = Integer.parseInt(string);
        String string2 = matcher2.group("month");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
        int month = Integer.parseInt(string2);
        String string3 = matcher2.group("day");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"group(...)");
        int day = Integer.parseInt(string3);
        LocalDate localDate = LocalDate.of(year, month, day);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"of(...)");
        return localDate;
    }

    @NotNull
    public final LocalTime parseTime$partiql_planner(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Matcher matcher = TIME_PATTERN.matcher(input);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
        Matcher matcher2 = matcher;
        if (!matcher2.matches()) {
            throw new DateTimeException("Expect TIME Format to be in HH:mm:ss.ddd+[+|-][hh:mm|z], received " + input);
        }
        try {
            String timeZoneString;
            BigDecimal bigDecimal;
            String string = matcher2.group("hour");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            int hour = Integer.parseInt(string);
            String string2 = matcher2.group("minute");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
            int minute = Integer.parseInt(string2);
            String string3 = matcher2.group("second");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"group(...)");
            int second = Integer.parseInt(string3);
            String string4 = matcher2.group("fraction");
            if (string4 != null) {
                String it = string4;
                boolean bl = false;
                bigDecimal = new BigDecimal('.' + it);
            } else {
                bigDecimal = BigDecimal.ZERO;
            }
            BigDecimal fraction = bigDecimal;
            int nanoOfSecond = fraction.movePointRight(9).intValue();
            String string5 = matcher2.group("timezone");
            if (string5 == null) {
                string5 = null;
            }
            if ((timeZoneString = string5) != null) {
                throw new DateTimeException("Expect TIME Format to be in HH:mm:ss.ddd, received " + input);
            }
            LocalTime localTime = LocalTime.of(hour, minute, second, nanoOfSecond);
            Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"of(...)");
            return localTime;
        }
        catch (IllegalStateException e) {
            throw new DateTimeException(e.getLocalizedMessage());
        }
        catch (IllegalArgumentException e) {
            throw new DateTimeException(e.getLocalizedMessage());
        }
    }

    @NotNull
    public final OffsetTime parseTimez$partiql_planner(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Matcher matcher = TIME_PATTERN.matcher(input);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
        Matcher matcher2 = matcher;
        if (!matcher2.matches()) {
            throw new DateTimeException("Expect TIME Format to be in HH:mm:ss.ddd+[+|-][hh:mm|z], received " + input);
        }
        try {
            String timeZoneString;
            BigDecimal bigDecimal;
            String it;
            String string = matcher2.group("hour");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            int hour = Integer.parseInt(string);
            String string2 = matcher2.group("minute");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
            int minute = Integer.parseInt(string2);
            String string3 = matcher2.group("second");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"group(...)");
            int second = Integer.parseInt(string3);
            String string4 = matcher2.group("fraction");
            if (string4 != null) {
                it = string4;
                boolean bl = false;
                bigDecimal = new BigDecimal('.' + it);
            } else {
                bigDecimal = BigDecimal.ZERO;
            }
            BigDecimal fraction = bigDecimal;
            int nanoOfSecond = fraction.movePointRight(9).intValue();
            String string5 = matcher2.group("utc");
            if (string5 != null) {
                it = string5;
                boolean bl = false;
                OffsetTime offsetTime = OffsetTime.of(hour, minute, second, nanoOfSecond, ZoneOffset.UTC);
                Intrinsics.checkNotNullExpressionValue((Object)offsetTime, (String)"of(...)");
                return offsetTime;
            }
            String string6 = matcher2.group("timezone");
            if (string6 == null) {
                string6 = null;
            }
            if ((timeZoneString = string6) == null) {
                throw new DateTimeException("Expect TIME Format to be in HH:mm:ss.ddd+[+|-][hh:mm|z], received " + input);
            }
            ZoneOffset timeZone = this.getTimeZoneComponent(timeZoneString);
            OffsetTime offsetTime = OffsetTime.of(hour, minute, second, nanoOfSecond, timeZone);
            Intrinsics.checkNotNullExpressionValue((Object)offsetTime, (String)"of(...)");
            return offsetTime;
        }
        catch (IllegalStateException e) {
            throw new DateTimeException(e.getLocalizedMessage());
        }
        catch (IllegalArgumentException e) {
            throw new DateTimeException(e.getLocalizedMessage());
        }
    }

    @NotNull
    public final LocalDateTime parseTimestamp(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Matcher matcher = TIMESTAMP_PATTERN.matcher(input);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
        Matcher matcher2 = matcher;
        if (!matcher2.matches()) {
            throw new DateTimeException("Expected TIMESTAMP Format should be in YYYY-MM-DD[\\s|T]hh:mm:ss.ddd+[hh:mm|z], received " + input);
        }
        String string = matcher2.group("date");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
        LocalDate date = this.parseDate$partiql_planner(string);
        String string2 = matcher2.group("time");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
        LocalTime time = this.parseTime$partiql_planner(string2);
        LocalDateTime localDateTime = LocalDateTime.of(date, time);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"of(...)");
        return localDateTime;
    }

    @NotNull
    public final OffsetDateTime parseTimestampz(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Matcher matcher = TIMESTAMP_PATTERN.matcher(input);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
        Matcher matcher2 = matcher;
        if (!matcher2.matches()) {
            throw new DateTimeException("Expected TIMESTAMP Format should be in YYYY-MM-DD[\\s|T]hh:mm:ss.ddd+[hh:mm|z], received " + input);
        }
        String string = matcher2.group("date");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
        LocalDate date = this.parseDate$partiql_planner(string);
        String string2 = matcher2.group("time");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
        OffsetTime time = this.parseTimez$partiql_planner(string2);
        OffsetDateTime offsetDateTime = OffsetDateTime.of(date, time.toLocalTime(), time.getOffset());
        Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"of(...)");
        return offsetDateTime;
    }

    private final ZoneOffset getTimeZoneComponent(String timezone) {
        ZoneOffset zoneOffset;
        String string = timezone.substring(0, 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        char tzSign = StringsKt.first((CharSequence)string);
        String string2 = timezone.substring(1, 3);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        int tzHour = Integer.parseInt(string2);
        String string3 = timezone.substring(4, 6);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        int tzMinute = Integer.parseInt(string3);
        if (tzSign == '-' && tzHour == 0 && tzMinute == 0) {
            throw new IllegalStateException("unknown zone offset".toString());
        }
        if (tzSign == '-') {
            ZoneOffset zoneOffset2 = ZoneOffset.ofHoursMinutes(-tzHour, -tzMinute);
            zoneOffset = zoneOffset2;
            Intrinsics.checkNotNullExpressionValue((Object)zoneOffset2, (String)"ofHoursMinutes(...)");
        } else {
            ZoneOffset zoneOffset3 = ZoneOffset.ofHoursMinutes(tzHour, tzMinute);
            zoneOffset = zoneOffset3;
            Intrinsics.checkNotNullExpressionValue((Object)zoneOffset3, (String)"ofHoursMinutes(...)");
        }
        return zoneOffset;
    }

    static {
        Pattern pattern = Pattern.compile("(?<year>\\d{4,})-(?<month>\\d{2,})-(?<day>\\d{2,})");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        DATE_PATTERN = pattern;
        Pattern pattern2 = Pattern.compile("(?<hour>\\d{2,}):(?<minute>\\d{2,}):(?<second>\\d{2,})(?:\\.(?<fraction>\\d+))?\\s*(?<timezone>([+-]\\d\\d:\\d\\d)|(?<utc>[Zz]))?");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        TIME_PATTERN = pattern2;
        SQL_TIMESTAMP_DATE_TIME_DELIMITER = new Regex("\\s+");
        RFC8889_TIMESTAMP_DATE_TIME_DELIMITER = new Regex("[Tt]");
        TIMESTAMP_PATTERN = new Regex("(?<date>" + DATE_PATTERN + ")(" + SQL_TIMESTAMP_DATE_TIME_DELIMITER + '|' + RFC8889_TIMESTAMP_DATE_TIME_DELIMITER + ")(?<time>" + TIME_PATTERN + ')').toPattern();
    }
}

