/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.planner.internal.typer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.planner.internal.ir.Rex;
import org.partiql.planner.internal.typer.CompilerType;
import org.partiql.planner.internal.typer.PlanTyper;
import org.partiql.spi.types.PType;
import org.partiql.spi.value.Datum;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u0002J\u001c\u0010\u0012\u001a\u0018\u0012\u0004\u0012\u00020\u0007\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0018\u00010\u00140\u0013J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0005H\u0002J\f\u0010\u0018\u001a\u00020\u0017*\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/partiql/planner/internal/typer/DynamicTyper;", "", "()V", "args", "", "Lorg/partiql/planner/internal/ir/Rex;", "supertype", "Lorg/partiql/planner/internal/typer/CompilerType;", "types", "accumulate", "", "rex", "accumulateConcrete", "accumulateUnknown", "calculate", "type", "computeDecimal", "computeText", "mapping", "Lkotlin/Pair;", "", "Lorg/partiql/planner/internal/typer/DynamicTyper$Mapping;", "isLiteralMissing", "", "isLiteralNull", "Companion", "Mapping", "partiql-planner"})
@SourceDebugExtension(value={"SMAP\nDynamicTyper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamicTyper.kt\norg/partiql/planner/internal/typer/DynamicTyper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,395:1\n1549#2:396\n1620#2,3:397\n1789#2,3:400\n1789#2,3:403\n*S KotlinDebug\n*F\n+ 1 DynamicTyper.kt\norg/partiql/planner/internal/typer/DynamicTyper\n*L\n109#1:396\n109#1:397,3\n122#1:400,3\n136#1:403,3\n*E\n"})
public final class DynamicTyper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private CompilerType supertype;
    @NotNull
    private List<Rex> args = new ArrayList();
    @NotNull
    private final List<CompilerType> types = new ArrayList();
    private static final int N = PType.codes().length;
    @NotNull
    private static final Integer[][] graph;

    public final void accumulate(@NotNull Rex rex2) {
        Intrinsics.checkNotNullParameter((Object)rex2, (String)"rex");
        if (this.isLiteralNull(rex2) || this.isLiteralMissing(rex2)) {
            this.accumulateUnknown(rex2);
        } else {
            this.accumulateConcrete(rex2);
        }
    }

    private final boolean isLiteralNull(Rex $this$isLiteralNull) {
        Rex.Op op = $this$isLiteralNull.op;
        return op instanceof Rex.Op.Lit && ((Rex.Op.Lit)op).value.isNull();
    }

    private final boolean isLiteralMissing(Rex $this$isLiteralMissing) {
        Rex.Op op = $this$isLiteralMissing.op;
        return op instanceof Rex.Op.Lit && ((Rex.Op.Lit)op).value.isMissing();
    }

    private final void accumulateUnknown(Rex rex2) {
        this.args.add(rex2);
    }

    private final void accumulateConcrete(Rex rex2) {
        this.types.add(rex2.type);
        this.args.add(rex2);
        this.calculate(rex2.type);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<CompilerType, List<Mapping>> mapping() {
        void $this$mapTo$iv$iv;
        Object type;
        Object[] s = null;
        if (this.supertype == null) {
            PType pType = PType.dynamic();
            Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"dynamic(...)");
            return TuplesKt.to((Object)((Object)new CompilerType(pType, false, false, 6, null)), null);
        }
        s = this.supertype;
        int superTypeBase = s.code();
        if (superTypeBase == 0) {
            PType pType = PlanTyper.Companion.anyOf((Collection<? extends PType>)this.types);
            Intrinsics.checkNotNull((Object)pType);
            return TuplesKt.to((Object)((Object)PlanTyper.Companion.toCType(pType)), null);
        }
        Object[] objectArray = new Integer[]{22, 23, 21, 20};
        if (SetsKt.setOf((Object[])objectArray).contains(superTypeBase)) {
            PType pType = PlanTyper.Companion.anyOf((Collection<? extends PType>)this.types);
            Intrinsics.checkNotNull((Object)pType);
            return TuplesKt.to((Object)((Object)PlanTyper.Companion.toCType(pType)), null);
        }
        if (superTypeBase == 7 && (type = this.computeDecimal()) != null) {
            s = type;
        }
        type = new Integer[]{10, 11, 12};
        if (SetsKt.setOf((Object[])type).contains(superTypeBase) && (type = this.computeText()) != null) {
            s = type;
        }
        Iterable $this$map$iv = this.args;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Mapping mapping;
            void it;
            Rex rex2 = (Rex)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (this.isLiteralNull((Rex)it)) {
                Datum datum = Datum.nullValue((PType)PType.of((int)s.code()));
                Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"nullValue(...)");
                mapping = new Mapping.Replacement(new Rex((CompilerType)s, new Rex.Op.Lit(datum)));
            } else if (this.isLiteralMissing((Rex)it)) {
                Datum datum = Datum.missing((PType)PType.of((int)s.code()));
                Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"missing(...)");
                mapping = new Mapping.Replacement(new Rex((CompilerType)s, new Rex.Op.Lit(datum)));
            } else {
                mapping = Intrinsics.areEqual((Object)((Object)it.type), (Object)s) ? (Mapping)new Mapping.Coercion((CompilerType)s) : null;
            }
            collection.add(mapping);
        }
        List mapping = (List)destination$iv$iv;
        return TuplesKt.to((Object)s, (Object)mapping);
    }

    /*
     * WARNING - void declaration
     */
    private final CompilerType computeDecimal() {
        void $this$fold$iv;
        Iterable iterable = this.types;
        Pair initial$iv = TuplesKt.to((Object)0, (Object)0);
        boolean $i$f$fold = false;
        Pair accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void type;
            CompilerType compilerType = (CompilerType)((Object)element$iv);
            Pair acc = accumulator$iv;
            boolean bl = false;
            if (type.code() != 7) {
                return null;
            }
            int precision = RangesKt.coerceAtLeast((int)type.getPrecision(), (int)((Number)acc.getFirst()).intValue());
            int scale = RangesKt.coerceAtLeast((int)type.getScale(), (int)((Number)acc.getSecond()).intValue());
            accumulator$iv = TuplesKt.to((Object)precision, (Object)scale);
        }
        Pair pair = accumulator$iv;
        int precision = ((Number)pair.component1()).intValue();
        int scale = ((Number)pair.component2()).intValue();
        PType pType = PType.decimal((int)precision, (int)scale);
        Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"decimal(...)");
        return PlanTyper.Companion.toCType(pType);
    }

    /*
     * WARNING - void declaration
     */
    private final CompilerType computeText() {
        void $this$fold$iv;
        boolean containsString = false;
        boolean containsVarChar = false;
        Iterable iterable = this.types;
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            int n;
            void type;
            CompilerType compilerType = (CompilerType)((Object)element$iv);
            int acc = accumulator$iv;
            boolean bl = false;
            Object[] objectArray = new Integer[]{11, 10, 12};
            if (!SetsKt.setOf((Object[])objectArray).contains(type.code())) {
                return null;
            }
            switch (type.code()) {
                case 12: {
                    containsString = true;
                    n = Integer.MAX_VALUE;
                    break;
                }
                case 11: {
                    containsVarChar = true;
                    n = RangesKt.coerceAtLeast((int)acc, (int)type.getLength());
                    break;
                }
                case 10: {
                    n = RangesKt.coerceAtLeast((int)acc, (int)type.getLength());
                    break;
                }
                default: {
                    throw new IllegalStateException(("Received type: " + type).toString());
                }
            }
            accumulator$iv = n;
        }
        int length = accumulator$iv;
        iterable = containsString ? PType.string() : (containsVarChar ? PType.varchar((int)length) : PType.character((int)length));
        Intrinsics.checkNotNull((Object)iterable);
        return PlanTyper.Companion.toCType((PType)iterable);
    }

    private final void calculate(CompilerType type) {
        Object object;
        CompilerType s = this.supertype;
        if (s == null) {
            this.supertype = type;
            return;
        }
        if (s.code() == 0) {
            return;
        }
        if (type.code() == 0) {
            object = type;
        } else {
            if (Intrinsics.areEqual((Object)((Object)s), (Object)((Object)type))) {
                return;
            }
            object = graph[s.code()][type.code()];
            if (object == null || (object = DynamicTyper.Companion.toPType((Integer)object)) == null) {
                PType pType = PType.dynamic();
                Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"dynamic(...)");
                object = new CompilerType(pType, false, false, 6, null);
            }
        }
        this.supertype = object;
    }

    @JvmStatic
    private static final Integer[] edges(Pair<Integer, Integer> ... edges) {
        return DynamicTyper.Companion.edges(edges);
    }

    @NotNull
    public static final Integer[][] getGraph$partiql_planner() {
        return Companion.getGraph$partiql_planner();
    }

    static {
        Companion $this$graph_u24lambda_u243 = Companion;
        boolean bl = false;
        Integer[][] graph = new Integer[N][];
        int[] nArray = PType.codes();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"codes(...)");
        for (int type : nArray) {
            graph[type] = new Integer[N];
        }
        graph[0] = $this$graph_u24lambda_u243.edges(new Pair[0]);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)1, (Object)1)};
        graph[1] = $this$graph_u24lambda_u243.edges(pairArray);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)2, (Object)2), TuplesKt.to((Object)3, (Object)3), TuplesKt.to((Object)4, (Object)4), TuplesKt.to((Object)5, (Object)5), TuplesKt.to((Object)6, (Object)6), TuplesKt.to((Object)7, (Object)7), TuplesKt.to((Object)8, (Object)8), TuplesKt.to((Object)9, (Object)9)};
        graph[2] = $this$graph_u24lambda_u243.edges(pairArray2);
        Pair[] pairArray3 = new Pair[]{TuplesKt.to((Object)2, (Object)3), TuplesKt.to((Object)3, (Object)3), TuplesKt.to((Object)4, (Object)4), TuplesKt.to((Object)5, (Object)5), TuplesKt.to((Object)6, (Object)6), TuplesKt.to((Object)7, (Object)7), TuplesKt.to((Object)8, (Object)8), TuplesKt.to((Object)9, (Object)9)};
        graph[3] = $this$graph_u24lambda_u243.edges(pairArray3);
        Pair[] pairArray4 = new Pair[]{TuplesKt.to((Object)2, (Object)4), TuplesKt.to((Object)3, (Object)4), TuplesKt.to((Object)4, (Object)4), TuplesKt.to((Object)5, (Object)5), TuplesKt.to((Object)6, (Object)6), TuplesKt.to((Object)7, (Object)7), TuplesKt.to((Object)8, (Object)8), TuplesKt.to((Object)9, (Object)9)};
        graph[4] = $this$graph_u24lambda_u243.edges(pairArray4);
        Pair[] pairArray5 = new Pair[]{TuplesKt.to((Object)2, (Object)5), TuplesKt.to((Object)3, (Object)5), TuplesKt.to((Object)4, (Object)5), TuplesKt.to((Object)5, (Object)5), TuplesKt.to((Object)6, (Object)6), TuplesKt.to((Object)7, (Object)7), TuplesKt.to((Object)8, (Object)8), TuplesKt.to((Object)9, (Object)9)};
        graph[5] = $this$graph_u24lambda_u243.edges(pairArray5);
        Pair[] pairArray6 = new Pair[]{TuplesKt.to((Object)2, (Object)6), TuplesKt.to((Object)3, (Object)6), TuplesKt.to((Object)4, (Object)6), TuplesKt.to((Object)5, (Object)6), TuplesKt.to((Object)6, (Object)6), TuplesKt.to((Object)7, (Object)7), TuplesKt.to((Object)8, (Object)8), TuplesKt.to((Object)9, (Object)9)};
        graph[6] = $this$graph_u24lambda_u243.edges(pairArray6);
        Pair[] pairArray7 = new Pair[]{TuplesKt.to((Object)2, (Object)7), TuplesKt.to((Object)3, (Object)7), TuplesKt.to((Object)4, (Object)7), TuplesKt.to((Object)5, (Object)7), TuplesKt.to((Object)6, (Object)7), TuplesKt.to((Object)7, (Object)7), TuplesKt.to((Object)8, (Object)8), TuplesKt.to((Object)9, (Object)9)};
        graph[7] = $this$graph_u24lambda_u243.edges(pairArray7);
        Pair[] pairArray8 = new Pair[]{TuplesKt.to((Object)2, (Object)8), TuplesKt.to((Object)3, (Object)8), TuplesKt.to((Object)4, (Object)8), TuplesKt.to((Object)5, (Object)8), TuplesKt.to((Object)6, (Object)8), TuplesKt.to((Object)7, (Object)8), TuplesKt.to((Object)8, (Object)8), TuplesKt.to((Object)9, (Object)9)};
        graph[8] = $this$graph_u24lambda_u243.edges(pairArray8);
        Pair[] pairArray9 = new Pair[]{TuplesKt.to((Object)2, (Object)9), TuplesKt.to((Object)3, (Object)9), TuplesKt.to((Object)4, (Object)9), TuplesKt.to((Object)5, (Object)9), TuplesKt.to((Object)6, (Object)9), TuplesKt.to((Object)7, (Object)9), TuplesKt.to((Object)8, (Object)9), TuplesKt.to((Object)9, (Object)9)};
        graph[9] = $this$graph_u24lambda_u243.edges(pairArray9);
        Pair[] pairArray10 = new Pair[]{TuplesKt.to((Object)10, (Object)10), TuplesKt.to((Object)12, (Object)12), TuplesKt.to((Object)11, (Object)12), TuplesKt.to((Object)14, (Object)14)};
        graph[10] = $this$graph_u24lambda_u243.edges(pairArray10);
        Pair[] pairArray11 = new Pair[]{TuplesKt.to((Object)10, (Object)12), TuplesKt.to((Object)12, (Object)12), TuplesKt.to((Object)11, (Object)12), TuplesKt.to((Object)14, (Object)14)};
        graph[12] = $this$graph_u24lambda_u243.edges(pairArray11);
        Pair[] pairArray12 = new Pair[]{TuplesKt.to((Object)10, (Object)11), TuplesKt.to((Object)12, (Object)12), TuplesKt.to((Object)11, (Object)11), TuplesKt.to((Object)14, (Object)14)};
        graph[11] = $this$graph_u24lambda_u243.edges(pairArray12);
        Pair[] pairArray13 = new Pair[]{TuplesKt.to((Object)13, (Object)13)};
        graph[13] = $this$graph_u24lambda_u243.edges(pairArray13);
        Pair[] pairArray14 = new Pair[]{TuplesKt.to((Object)15, (Object)15)};
        graph[15] = $this$graph_u24lambda_u243.edges(pairArray14);
        Pair[] pairArray15 = new Pair[]{TuplesKt.to((Object)10, (Object)14), TuplesKt.to((Object)12, (Object)14), TuplesKt.to((Object)11, (Object)14), TuplesKt.to((Object)14, (Object)14)};
        graph[14] = $this$graph_u24lambda_u243.edges(pairArray15);
        Pair[] pairArray16 = new Pair[]{TuplesKt.to((Object)16, (Object)16)};
        graph[16] = $this$graph_u24lambda_u243.edges(pairArray16);
        Pair[] pairArray17 = new Pair[]{TuplesKt.to((Object)17, (Object)17)};
        graph[17] = $this$graph_u24lambda_u243.edges(pairArray17);
        Pair[] pairArray18 = new Pair[]{TuplesKt.to((Object)18, (Object)18)};
        graph[18] = $this$graph_u24lambda_u243.edges(pairArray18);
        Pair[] pairArray19 = new Pair[]{TuplesKt.to((Object)19, (Object)19)};
        graph[19] = $this$graph_u24lambda_u243.edges(pairArray19);
        Pair[] pairArray20 = new Pair[]{TuplesKt.to((Object)20, (Object)20), TuplesKt.to((Object)21, (Object)21)};
        graph[20] = $this$graph_u24lambda_u243.edges(pairArray20);
        Pair[] pairArray21 = new Pair[]{TuplesKt.to((Object)20, (Object)21), TuplesKt.to((Object)21, (Object)21)};
        graph[21] = $this$graph_u24lambda_u243.edges(pairArray21);
        Pair[] pairArray22 = new Pair[]{TuplesKt.to((Object)23, (Object)23)};
        graph[23] = $this$graph_u24lambda_u243.edges(pairArray22);
        Pair[] pairArray23 = new Pair[]{TuplesKt.to((Object)22, (Object)22)};
        graph[22] = $this$graph_u24lambda_u243.edges(pairArray23);
        DynamicTyper.graph = (Integer[][])ArraysKt.requireNoNulls((Object[])((Object[])graph));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JA\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00072*\u0010\r\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000e0\u0007\"\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000eH\u0003\u00a2\u0006\u0002\u0010\u000fJ\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0004H\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R0\u0010\u0006\u001a\u0014\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00070\u0007j\u0002`\b8\u0000X\u0081\u0004\u00a2\u0006\u0010\n\u0002\u0010\f\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/partiql/planner/internal/typer/DynamicTyper$Companion;", "", "()V", "N", "", "getN$annotations", "graph", "", "Lorg/partiql/planner/internal/typer/SuperGraph;", "getGraph$partiql_planner$annotations", "getGraph$partiql_planner", "()[[Ljava/lang/Integer;", "[[Ljava/lang/Integer;", "edges", "Lkotlin/Pair;", "([Lkotlin/Pair;)[Ljava/lang/Integer;", "toPType", "Lorg/partiql/planner/internal/typer/CompilerType;", "partiql-planner"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getN$annotations() {
        }

        @JvmStatic
        private final Integer[] edges(Pair<Integer, Integer> ... edges) {
            Integer[] arr = new Integer[N];
            for (Pair<Integer, Integer> type : edges) {
                arr[((Number)type.getFirst()).intValue()] = type.getSecond();
            }
            return arr;
        }

        @NotNull
        public final Integer[][] getGraph$partiql_planner() {
            return graph;
        }

        @JvmStatic
        public static /* synthetic */ void getGraph$partiql_planner$annotations() {
        }

        private final CompilerType toPType(int $this$toPType) {
            PType pType;
            switch ($this$toPType) {
                case 1: {
                    pType = PType.bool();
                    break;
                }
                case 0: {
                    pType = PType.dynamic();
                    break;
                }
                case 2: {
                    pType = PType.tinyint();
                    break;
                }
                case 3: {
                    pType = PType.smallint();
                    break;
                }
                case 4: {
                    pType = PType.integer();
                    break;
                }
                case 5: {
                    pType = PType.bigint();
                    break;
                }
                case 6: {
                    pType = PType.numeric((int)38, (int)0);
                    break;
                }
                case 7: {
                    pType = PType.decimal((int)38, (int)0);
                    break;
                }
                case 8: {
                    pType = PType.real();
                    break;
                }
                case 9: {
                    pType = PType.doublePrecision();
                    break;
                }
                case 10: {
                    pType = PType.character((int)255);
                    break;
                }
                case 11: {
                    pType = PType.varchar((int)255);
                    break;
                }
                case 12: {
                    pType = PType.string();
                    break;
                }
                case 13: {
                    pType = PType.blob((int)Integer.MAX_VALUE);
                    break;
                }
                case 14: {
                    pType = PType.clob((int)Integer.MAX_VALUE);
                    break;
                }
                case 15: {
                    pType = PType.date();
                    break;
                }
                case 17: {
                    pType = PType.timez((int)6);
                    break;
                }
                case 16: {
                    pType = PType.time((int)6);
                    break;
                }
                case 19: {
                    pType = PType.timestampz((int)6);
                    break;
                }
                case 18: {
                    pType = PType.timestamp((int)6);
                    break;
                }
                case 21: {
                    pType = PType.bag();
                    break;
                }
                case 20: {
                    pType = PType.array();
                    break;
                }
                case 22: {
                    pType = PType.row((Collection)CollectionsKt.emptyList());
                    break;
                }
                case 23: {
                    pType = PType.struct();
                    break;
                }
                case 24: {
                    pType = PType.unknown();
                    break;
                }
                case 25: {
                    String string = "variant in dynamic typer";
                    throw new NotImplementedError("An operation is not implemented: " + string);
                }
                default: {
                    throw new IllegalStateException(("Unknown type: " + $this$toPType).toString());
                }
            }
            PType pType2 = pType;
            Intrinsics.checkNotNull((Object)pType2);
            return PlanTyper.Companion.toCType(pType2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bp\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00a8\u0006\u0006"}, d2={"Lorg/partiql/planner/internal/typer/DynamicTyper$Mapping;", "", "Coercion", "Replacement", "Lorg/partiql/planner/internal/typer/DynamicTyper$Mapping$Coercion;", "Lorg/partiql/planner/internal/typer/DynamicTyper$Mapping$Replacement;", "partiql-planner"})
    public static interface Mapping {

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/partiql/planner/internal/typer/DynamicTyper$Mapping$Coercion;", "Lorg/partiql/planner/internal/typer/DynamicTyper$Mapping;", "target", "Lorg/partiql/planner/internal/typer/CompilerType;", "(Lorg/partiql/planner/internal/typer/CompilerType;)V", "getTarget", "()Lorg/partiql/planner/internal/typer/CompilerType;", "partiql-planner"})
        public static final class Coercion
        implements Mapping {
            @NotNull
            private final CompilerType target;

            public Coercion(@NotNull CompilerType target) {
                Intrinsics.checkNotNullParameter((Object)((Object)target), (String)"target");
                this.target = target;
            }

            @NotNull
            public final CompilerType getTarget() {
                return this.target;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/partiql/planner/internal/typer/DynamicTyper$Mapping$Replacement;", "Lorg/partiql/planner/internal/typer/DynamicTyper$Mapping;", "replacement", "Lorg/partiql/planner/internal/ir/Rex;", "(Lorg/partiql/planner/internal/ir/Rex;)V", "getReplacement", "()Lorg/partiql/planner/internal/ir/Rex;", "partiql-planner"})
        public static final class Replacement
        implements Mapping {
            @NotNull
            private final Rex replacement;

            public Replacement(@NotNull Rex replacement) {
                Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
                this.replacement = replacement;
            }

            @NotNull
            public final Rex getReplacement() {
                return this.replacement;
            }
        }
    }
}

