/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.planner.internal.transforms;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.DataType;
import org.partiql.ast.DatetimeField;
import org.partiql.ast.Identifier;
import org.partiql.ast.IntervalQualifier;
import org.partiql.ast.Literal;
import org.partiql.ast.QueryBody;
import org.partiql.ast.SelectList;
import org.partiql.ast.SelectStar;
import org.partiql.ast.SetQuantifier;
import org.partiql.ast.expr.Expr;
import org.partiql.ast.expr.ExprAnd;
import org.partiql.ast.expr.ExprArray;
import org.partiql.ast.expr.ExprBag;
import org.partiql.ast.expr.ExprBetween;
import org.partiql.ast.expr.ExprBoolTest;
import org.partiql.ast.expr.ExprCall;
import org.partiql.ast.expr.ExprCase;
import org.partiql.ast.expr.ExprCast;
import org.partiql.ast.expr.ExprCoalesce;
import org.partiql.ast.expr.ExprExtract;
import org.partiql.ast.expr.ExprInCollection;
import org.partiql.ast.expr.ExprIsType;
import org.partiql.ast.expr.ExprLike;
import org.partiql.ast.expr.ExprLit;
import org.partiql.ast.expr.ExprMissingPredicate;
import org.partiql.ast.expr.ExprNot;
import org.partiql.ast.expr.ExprNullIf;
import org.partiql.ast.expr.ExprNullPredicate;
import org.partiql.ast.expr.ExprOperator;
import org.partiql.ast.expr.ExprOr;
import org.partiql.ast.expr.ExprOverlay;
import org.partiql.ast.expr.ExprPath;
import org.partiql.ast.expr.ExprPosition;
import org.partiql.ast.expr.ExprQuerySet;
import org.partiql.ast.expr.ExprRowValue;
import org.partiql.ast.expr.ExprSessionAttribute;
import org.partiql.ast.expr.ExprStruct;
import org.partiql.ast.expr.ExprSubstring;
import org.partiql.ast.expr.ExprTrim;
import org.partiql.ast.expr.ExprValues;
import org.partiql.ast.expr.ExprVarRef;
import org.partiql.ast.expr.ExprVariant;
import org.partiql.ast.expr.PathStep;
import org.partiql.ast.expr.TrimSpec;
import org.partiql.planner.internal.Env;
import org.partiql.planner.internal.PErrors;
import org.partiql.planner.internal.ir.Plan;
import org.partiql.planner.internal.ir.Rel;
import org.partiql.planner.internal.ir.Rex;
import org.partiql.planner.internal.ir.builder.PlanBuilder;
import org.partiql.planner.internal.ir.builder.PlanBuilderKt;
import org.partiql.planner.internal.transforms.AstToPlan;
import org.partiql.planner.internal.transforms.RelConverter;
import org.partiql.planner.internal.transforms.RexConverter;
import org.partiql.planner.internal.typer.CompilerType;
import org.partiql.planner.internal.typer.PlanTyper;
import org.partiql.planner.internal.util.DateTimeUtils;
import org.partiql.planner.internal.util.FunctionUtils;
import org.partiql.planner.internal.util.IntervalUtils;
import org.partiql.spi.types.PType;
import org.partiql.spi.value.Datum;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ\u001d\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/partiql/planner/internal/transforms/RexConverter;", "", "()V", "INTERVAL_DEFAULT_FRACTIONAL_PRECISION", "", "INTERVAL_DEFAULT_PRECISON", "apply", "Lorg/partiql/planner/internal/ir/Rex;", "expr", "Lorg/partiql/ast/expr/Expr;", "context", "Lorg/partiql/planner/internal/Env;", "apply$partiql_planner", "applyRel", "applyRel$partiql_planner", "ToRex", "partiql-planner"})
public final class RexConverter {
    @NotNull
    public static final RexConverter INSTANCE = new RexConverter();
    private static final int INTERVAL_DEFAULT_PRECISON = 2;
    private static final int INTERVAL_DEFAULT_FRACTIONAL_PRECISION = 6;

    private RexConverter() {
    }

    @NotNull
    public final Rex apply$partiql_planner(@NotNull Expr expr, @NotNull Env context) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return ToRex.visitExprCoerce$default(ToRex.INSTANCE, expr, context, null, 4, null);
    }

    @NotNull
    public final Rex applyRel$partiql_planner(@NotNull Expr expr, @NotNull Env context) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = expr.accept((AstVisitor)ToRex.INSTANCE, (Object)context);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"accept(...)");
        return (Rex)object;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00e8\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J4\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00152\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00130\u0019H\u0002J4\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00152\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00130\u0019H\u0002J(\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J)\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000b2\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020#\"\u00020\u0002H\u0002\u00a2\u0006\u0002\u0010$J(\u0010%\u001a\u00020\u00022\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020*H\u0002J\u0018\u0010+\u001a\u00020\u00022\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0003H\u0016J\u0010\u0010/\u001a\u00020\u001e2\u0006\u0010,\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020\u001e2\u0006\u0010,\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020\u001e2\u0006\u0010,\u001a\u000202H\u0002J\u0010\u00104\u001a\u00020 2\u0006\u0010\u001f\u001a\u000205H\u0002J\u0018\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u00022\u0006\u00109\u001a\u00020\u0015H\u0002J\u0018\u0010:\u001a\u0002072\u0006\u00108\u001a\u00020\u00022\u0006\u00109\u001a\u00020\u0015H\u0002J(\u0010;\u001a\u00020\u00022\u0006\u0010<\u001a\u0002022\u0006\u0010=\u001a\u00020\u000b2\u0006\u0010>\u001a\u0002022\u0006\u0010.\u001a\u00020\u0003H\u0002J \u0010?\u001a\u00020\u00022\u0006\u0010=\u001a\u00020\u000b2\u0006\u0010>\u001a\u0002022\u0006\u0010.\u001a\u00020\u0003H\u0002J\u0010\u0010@\u001a\u00020\u00022\u0006\u0010A\u001a\u00020\u000bH\u0002J\u0018\u0010B\u001a\u00020\u00022\u0006\u0010,\u001a\u00020C2\u0006\u0010D\u001a\u00020\u0003H\u0016J\u0018\u0010E\u001a\u00020\u00022\u0006\u0010,\u001a\u00020F2\u0006\u0010D\u001a\u00020\u0003H\u0016J\u0018\u0010G\u001a\u00020\u00022\u0006\u0010,\u001a\u00020H2\u0006\u0010D\u001a\u00020\u0003H\u0016J\u0018\u0010I\u001a\u00020\u00022\u0006\u0010,\u001a\u00020J2\u0006\u0010D\u001a\u00020\u0003H\u0016J\u0018\u0010K\u001a\u00020\u00022\u0006\u0010,\u001a\u00020L2\u0006\u0010D\u001a\u00020\u0003H\u0016J\u0018\u0010M\u001a\u00020\u00022\u0006\u0010,\u001a\u0002002\u0006\u0010.\u001a\u00020\u0003H\u0016J\u0018\u0010N\u001a\u00020\u00022\u0006\u0010,\u001a\u0002002\u0006\u0010.\u001a\u00020\u0003H\u0002J\u0018\u0010O\u001a\u00020\u00022\u0006\u0010,\u001a\u0002002\u0006\u0010.\u001a\u00020\u0003H\u0002J\u0018\u0010P\u001a\u00020\u00022\u0006\u0010,\u001a\u00020Q2\u0006\u0010.\u001a\u00020\u0003H\u0016J\u0018\u0010R\u001a\u00020\u00022\u0006\u0010,\u001a\u00020S2\u0006\u0010D\u001a\u00020\u0003H\u0016J\u0018\u0010T\u001a\u00020\u00022\u0006\u0010,\u001a\u00020U2\u0006\u0010D\u001a\u00020\u0003H\u0016J \u0010V\u001a\u00020\u00022\u0006\u0010,\u001a\u0002022\u0006\u0010D\u001a\u00020\u00032\b\b\u0002\u0010W\u001a\u00020XJ\u0018\u0010Y\u001a\u00020\u00022\u0006\u0010,\u001a\u00020Z2\u0006\u0010D\u001a\u00020\u0003H\u0016J\u0018\u0010[\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\\2\u0006\u0010D\u001a\u00020\u0003H\u0016J\u0018\u0010]\u001a\u00020\u00022\u0006\u0010,\u001a\u00020^2\u0006\u0010D\u001a\u00020\u0003H\u0016J\u0018\u0010_\u001a\u00020\u00022\u0006\u0010,\u001a\u00020`2\u0006\u0010D\u001a\u00020\u0003H\u0016J\u0018\u0010a\u001a\u00020\u00022\u0006\u0010,\u001a\u00020b2\u0006\u0010.\u001a\u00020\u0003H\u0016J\u0018\u0010c\u001a\u00020\u00022\u0006\u0010,\u001a\u00020d2\u0006\u0010D\u001a\u00020\u0003H\u0016J\u0018\u0010e\u001a\u00020\u00022\u0006\u0010,\u001a\u00020f2\u0006\u0010D\u001a\u00020\u0003H\u0016J\u0018\u0010g\u001a\u00020\u00022\u0006\u0010,\u001a\u00020h2\u0006\u0010D\u001a\u00020\u0003H\u0016J\u0018\u0010i\u001a\u00020\u00022\u0006\u0010,\u001a\u00020j2\u0006\u0010D\u001a\u00020\u0003H\u0016J\u0018\u0010k\u001a\u00020\u00022\u0006\u0010,\u001a\u00020l2\u0006\u0010D\u001a\u00020\u0003H\u0016J\u0018\u0010m\u001a\u00020\u00022\u0006\u0010,\u001a\u00020n2\u0006\u0010D\u001a\u00020\u0003H\u0016J\u0018\u0010o\u001a\u00020\u00022\u0006\u0010,\u001a\u00020p2\u0006\u0010D\u001a\u00020\u0003H\u0016J\u0018\u0010q\u001a\u00020\u00022\u0006\u0010,\u001a\u00020r2\u0006\u0010.\u001a\u00020\u0003H\u0016J\u0018\u0010s\u001a\u00020\u00022\u0006\u0010,\u001a\u00020t2\u0006\u0010D\u001a\u00020\u0003H\u0016J\u0018\u0010u\u001a\u00020\u00022\u0006\u0010,\u001a\u00020v2\u0006\u0010.\u001a\u00020\u0003H\u0016J\u0018\u0010w\u001a\u00020\u00022\u0006\u0010,\u001a\u00020x2\u0006\u0010D\u001a\u00020\u0003H\u0016J\u0018\u0010y\u001a\u00020\u00022\u0006\u0010,\u001a\u00020z2\u0006\u0010D\u001a\u00020\u0003H\u0016J\u0018\u0010{\u001a\u00020\u00022\u0006\u0010,\u001a\u00020|2\u0006\u0010.\u001a\u00020\u0003H\u0016J\u0018\u0010}\u001a\u00020\u00022\u0006\u0010,\u001a\u00020~2\u0006\u0010D\u001a\u00020\u0003H\u0016J\u0019\u0010\u007f\u001a\u00020\u00022\u0007\u0010,\u001a\u00030\u0080\u00012\u0006\u0010D\u001a\u00020\u0003H\u0016J\u001a\u0010\u0081\u0001\u001a\u00020\u00022\u0007\u0010,\u001a\u00030\u0082\u00012\u0006\u0010D\u001a\u00020\u0003H\u0016J\u001a\u0010\u0083\u0001\u001a\u00020\u00022\u0007\u0010,\u001a\u00030\u0084\u00012\u0006\u0010.\u001a\u00020\u0003H\u0016J\u001a\u0010\u0085\u0001\u001a\u00020\u00022\u0007\u0010,\u001a\u00030\u0086\u00012\u0006\u0010D\u001a\u00020\u0003H\u0016J\u0012\u0010\u0087\u0001\u001a\u00020\u00062\u0007\u0010\u0014\u001a\u00030\u0088\u0001H\u0002J\u000f\u0010\u0089\u0001\u001a\u00030\u008a\u0001*\u00030\u008b\u0001H\u0002J\u0015\u0010\u008c\u0001\u001a\u00020\u0002*\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0003\u0010\u008d\u0001R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008e\u0001"}, d2={"Lorg/partiql/planner/internal/transforms/RexConverter$ToRex;", "Lorg/partiql/ast/AstVisitor;", "Lorg/partiql/planner/internal/ir/Rex;", "Lorg/partiql/planner/internal/Env;", "()V", "ANY", "Lorg/partiql/planner/internal/typer/CompilerType;", "BAG", "BOOL", "COLL_AGG_NAMES", "", "", "INT", "INT4", "LIST", "STRING", "STRUCT", "TIMESTAMP", "assertGtEqZeroAndCreate", "Lorg/partiql/spi/types/PType;", "type", "", "param", "value", "create", "Lkotlin/Function1;", "assertGtZeroAndCreate", "assertParamCompToZero", "", "allowZero", "", "call", "Lorg/partiql/planner/internal/ir/Rex$Op$Call;", "name", "args", "", "(Ljava/lang/String;[Lorg/partiql/planner/internal/ir/Rex;)Lorg/partiql/planner/internal/ir/Rex$Op$Call;", "callToCollAgg", "id", "Lorg/partiql/spi/catalog/Identifier;", "setQuantifier", "Lorg/partiql/ast/SetQuantifier;", "", "defaultReturn", "node", "Lorg/partiql/ast/AstNode;", "context", "isCollAgg", "Lorg/partiql/ast/expr/ExprCall;", "isLiteralArray", "Lorg/partiql/ast/expr/Expr;", "isSqlSelect", "negate", "Lorg/partiql/planner/internal/ir/Rex$Op;", "relFromDefault", "Lorg/partiql/planner/internal/ir/Rel;", "path", "index", "relFromUnpivot", "resolveBinaryOp", "lhs", "symbol", "rhs", "resolveUnaryOp", "rexString", "str", "visitExprAnd", "Lorg/partiql/ast/expr/ExprAnd;", "ctx", "visitExprArray", "Lorg/partiql/ast/expr/ExprArray;", "visitExprBag", "Lorg/partiql/ast/expr/ExprBag;", "visitExprBetween", "Lorg/partiql/ast/expr/ExprBetween;", "visitExprBoolTest", "Lorg/partiql/ast/expr/ExprBoolTest;", "visitExprCall", "visitExprCallExists", "visitExprCallTupleUnion", "visitExprCase", "Lorg/partiql/ast/expr/ExprCase;", "visitExprCast", "Lorg/partiql/ast/expr/ExprCast;", "visitExprCoalesce", "Lorg/partiql/ast/expr/ExprCoalesce;", "visitExprCoerce", "coercion", "Lorg/partiql/planner/internal/ir/Rex$Op$Subquery$Coercion;", "visitExprExtract", "Lorg/partiql/ast/expr/ExprExtract;", "visitExprInCollection", "Lorg/partiql/ast/expr/ExprInCollection;", "visitExprIsType", "Lorg/partiql/ast/expr/ExprIsType;", "visitExprLike", "Lorg/partiql/ast/expr/ExprLike;", "visitExprLit", "Lorg/partiql/ast/expr/ExprLit;", "visitExprMissingPredicate", "Lorg/partiql/ast/expr/ExprMissingPredicate;", "visitExprNot", "Lorg/partiql/ast/expr/ExprNot;", "visitExprNullIf", "Lorg/partiql/ast/expr/ExprNullIf;", "visitExprNullPredicate", "Lorg/partiql/ast/expr/ExprNullPredicate;", "visitExprOperator", "Lorg/partiql/ast/expr/ExprOperator;", "visitExprOr", "Lorg/partiql/ast/expr/ExprOr;", "visitExprOverlay", "Lorg/partiql/ast/expr/ExprOverlay;", "visitExprPath", "Lorg/partiql/ast/expr/ExprPath;", "visitExprPosition", "Lorg/partiql/ast/expr/ExprPosition;", "visitExprQuerySet", "Lorg/partiql/ast/expr/ExprQuerySet;", "visitExprRowValue", "Lorg/partiql/ast/expr/ExprRowValue;", "visitExprSessionAttribute", "Lorg/partiql/ast/expr/ExprSessionAttribute;", "visitExprStruct", "Lorg/partiql/ast/expr/ExprStruct;", "visitExprSubstring", "Lorg/partiql/ast/expr/ExprSubstring;", "visitExprTrim", "Lorg/partiql/ast/expr/ExprTrim;", "visitExprValues", "Lorg/partiql/ast/expr/ExprValues;", "visitExprVarRef", "Lorg/partiql/ast/expr/ExprVarRef;", "visitExprVariant", "Lorg/partiql/ast/expr/ExprVariant;", "visitType", "Lorg/partiql/ast/DataType;", "toDatum", "Lorg/partiql/spi/value/Datum;", "Lorg/partiql/ast/Literal;", "toRex", "(Ljava/lang/Integer;)Lorg/partiql/planner/internal/ir/Rex;", "partiql-planner"})
    @SourceDebugExtension(value={"SMAP\nRexConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RexConverter.kt\norg/partiql/planner/internal/transforms/RexConverter$ToRex\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1261:1\n1549#2:1262\n1620#2,3:1263\n1789#2,3:1268\n2661#2,7:1271\n1549#2:1278\n1620#2,3:1279\n1549#2:1282\n1620#2,3:1283\n1549#2:1286\n1620#2,3:1287\n1549#2:1290\n1620#2,3:1291\n1549#2:1294\n1620#2,3:1295\n1549#2:1298\n1620#2,3:1299\n1549#2:1303\n1620#2,3:1304\n37#3,2:1266\n1#4:1302\n*S KotlinDebug\n*F\n+ 1 RexConverter.kt\norg/partiql/planner/internal/transforms/RexConverter$ToRex\n*L\n135#1:1262\n135#1:1263,3\n459#1:1268,3\n538#1:1271,7\n561#1:1278\n561#1:1279,3\n619#1:1282\n619#1:1283,3\n675#1:1286\n675#1:1287,3\n726#1:1290\n726#1:1291,3\n732#1:1294\n732#1:1295,3\n739#1:1298\n739#1:1299,3\n929#1:1303\n929#1:1304,3\n341#1:1266,2\n*E\n"})
    private static final class ToRex
    extends AstVisitor<Rex, Env> {
        @NotNull
        public static final ToRex INSTANCE = new ToRex();
        @NotNull
        private static final Set<String> COLL_AGG_NAMES;
        @NotNull
        private static final CompilerType ANY;
        @NotNull
        private static final CompilerType BOOL;
        @NotNull
        private static final CompilerType STRING;
        @NotNull
        private static final CompilerType STRUCT;
        @NotNull
        private static final CompilerType BAG;
        @NotNull
        private static final CompilerType LIST;
        @NotNull
        private static final CompilerType INT;
        @NotNull
        private static final CompilerType INT4;
        @NotNull
        private static final CompilerType TIMESTAMP;

        private ToRex() {
        }

        @NotNull
        public Rex defaultReturn(@NotNull AstNode node, @NotNull Env context) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            throw new IllegalArgumentException("unsupported rex " + node);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Rex visitExprRowValue(@NotNull ExprRowValue node, @NotNull Env ctx) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            List list = node.getValues();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValues(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Expr expr = (Expr)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(ToRex.visitExprCoerce$default(INSTANCE, (Expr)it, ctx, null, 4, null));
            }
            List values = (List)destination$iv$iv;
            Rex.Op.Collection op = Plan.rexOpCollection(values);
            return Plan.rex(LIST, op);
        }

        @NotNull
        public Rex visitExprLit(@NotNull ExprLit node, @NotNull Env context) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Literal literal = node.getLit();
            Intrinsics.checkNotNullExpressionValue((Object)literal, (String)"getLit(...)");
            Datum datum = this.toDatum(literal);
            PType pType = datum.getType();
            Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"getType(...)");
            PType type = pType;
            CompilerType cType = new CompilerType(type, node.getLit().code() == 0, node.getLit().code() == 1);
            Rex.Op.Lit op = Plan.rexOpLit(datum);
            return Plan.rex(cType, op);
        }

        private final Datum toDatum(Literal $this$toDatum) {
            Datum datum;
            Literal lit = $this$toDatum;
            switch (lit.code()) {
                case 0: {
                    Datum datum2 = Datum.nullValue();
                    datum = datum2;
                    Intrinsics.checkNotNullExpressionValue((Object)datum2, (String)"nullValue(...)");
                    break;
                }
                case 1: {
                    Datum datum3 = Datum.missing();
                    datum = datum3;
                    Intrinsics.checkNotNullExpressionValue((Object)datum3, (String)"missing(...)");
                    break;
                }
                case 6: {
                    Datum datum4 = Datum.string((String)lit.stringValue());
                    datum = datum4;
                    Intrinsics.checkNotNullExpressionValue((Object)datum4, (String)"string(...)");
                    break;
                }
                case 2: {
                    Datum datum5 = Datum.bool((boolean)lit.booleanValue());
                    datum = datum5;
                    Intrinsics.checkNotNullExpressionValue((Object)datum5, (String)"bool(...)");
                    break;
                }
                case 4: {
                    BigDecimal dec = lit.bigDecimalValue().round(new MathContext(38, RoundingMode.HALF_EVEN));
                    Datum datum6 = Datum.decimal((BigDecimal)dec, (int)dec.precision(), (int)dec.scale());
                    Intrinsics.checkNotNull((Object)datum6);
                    datum = datum6;
                    break;
                }
                case 5: {
                    String string = lit.numberValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"numberValue(...)");
                    String n = string;
                    try {
                        int v = Integer.parseInt(n, CharsKt.checkRadix((int)10));
                        Datum datum7 = Datum.integer((int)v);
                        Intrinsics.checkNotNullExpressionValue((Object)datum7, (String)"integer(...)");
                        return datum7;
                    }
                    catch (NumberFormatException v) {
                        try {
                            long v2 = Long.parseLong(n, CharsKt.checkRadix((int)10));
                            Datum datum8 = Datum.bigint((long)v2);
                            Intrinsics.checkNotNullExpressionValue((Object)datum8, (String)"bigint(...)");
                            return datum8;
                        }
                        catch (NumberFormatException v2) {
                            BigInteger v3 = new BigInteger(n);
                            BigDecimal vDecimal = new BigDecimal(v3);
                            Datum datum9 = Datum.decimal((BigDecimal)vDecimal, (int)vDecimal.precision(), (int)vDecimal.scale());
                            Intrinsics.checkNotNullExpressionValue((Object)datum9, (String)"decimal(...)");
                            return datum9;
                        }
                    }
                }
                case 3: {
                    String string = lit.numberValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"numberValue(...)");
                    Datum datum10 = Datum.doublePrecision((double)Double.parseDouble(string));
                    Intrinsics.checkNotNullExpressionValue((Object)datum10, (String)"doublePrecision(...)");
                    return datum10;
                }
                case 7: {
                    DataType dataType = $this$toDatum.dataType();
                    Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"dataType(...)");
                    DataType type = dataType;
                    String string = $this$toDatum.stringValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringValue(...)");
                    String typedString = string;
                    switch (type.code()) {
                        case 33: {
                            LocalDate date = DateTimeUtils.INSTANCE.parseDate$partiql_planner(typedString);
                            Datum datum11 = Datum.date((LocalDate)date);
                            Intrinsics.checkNotNullExpressionValue((Object)datum11, (String)"date(...)");
                            return datum11;
                        }
                        case 34: {
                            LocalTime time = DateTimeUtils.INSTANCE.parseTime$partiql_planner(typedString);
                            Integer n = type.getPrecision();
                            int precision = n == null ? 6 : n;
                            Datum datum12 = Datum.time((LocalTime)time, (int)precision);
                            Intrinsics.checkNotNullExpressionValue((Object)datum12, (String)"time(...)");
                            return datum12;
                        }
                        case 35: {
                            OffsetTime time = DateTimeUtils.INSTANCE.parseTimez$partiql_planner(typedString);
                            Integer n = type.getPrecision();
                            int precision = n == null ? 6 : n;
                            Datum datum13 = Datum.timez((OffsetTime)time, (int)precision);
                            Intrinsics.checkNotNullExpressionValue((Object)datum13, (String)"timez(...)");
                            return datum13;
                        }
                        case 36: {
                            LocalDateTime timestamp = DateTimeUtils.INSTANCE.parseTimestamp(typedString);
                            Integer n = type.getPrecision();
                            int precision = n == null ? 6 : n;
                            Datum datum14 = Datum.timestamp((LocalDateTime)timestamp, (int)precision);
                            Intrinsics.checkNotNullExpressionValue((Object)datum14, (String)"timestamp(...)");
                            return datum14;
                        }
                        case 37: {
                            OffsetDateTime timestamp = DateTimeUtils.INSTANCE.parseTimestampz(typedString);
                            Integer n = type.getPrecision();
                            int precision = n == null ? 6 : n;
                            Datum datum15 = Datum.timestampz((OffsetDateTime)timestamp, (int)precision);
                            Intrinsics.checkNotNullExpressionValue((Object)datum15, (String)"timestampz(...)");
                            return datum15;
                        }
                        case 38: {
                            IntervalQualifier intervalQualifier = type.getIntervalQualifier();
                            if (intervalQualifier == null) {
                                throw new IllegalStateException("This interval should have a qualifier.".toString());
                            }
                            IntervalQualifier qualifier = intervalQualifier;
                            return IntervalUtils.INSTANCE.parseInterval$partiql_planner(typedString, qualifier);
                        }
                    }
                    throw new IllegalStateException(("Unsupported typed literal string: " + $this$toDatum).toString());
                }
                default: {
                    throw new IllegalStateException(("Unsupported literal: " + $this$toDatum).toString());
                }
            }
            return datum;
        }

        @NotNull
        public Rex visitExprVariant(@NotNull ExprVariant node, @NotNull Env ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            if (!Intrinsics.areEqual((Object)node.getEncoding(), (Object)"ion")) {
                throw new IllegalArgumentException("unsupported encoding " + node.getEncoding());
            }
            Datum datum = Datum.ion((String)node.getValue());
            Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"ion(...)");
            Datum datum2 = datum;
            PType pType = datum2.getType();
            Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"getType(...)");
            CompilerType type = new CompilerType(pType, false, false, 6, null);
            return Plan.rex(type, Plan.rexOpLit(datum2));
        }

        @NotNull
        public final Rex visitExprCoerce(@NotNull Expr node, @NotNull Env ctx, @NotNull Rex.Op.Subquery.Coercion coercion) {
            Rex rex2;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)((Object)coercion), (String)"coercion");
            Rex rex3 = (Rex)node.accept((AstVisitor)this, (Object)ctx);
            boolean bl = this.isSqlSelect(node);
            if (bl) {
                Rex.Op op = rex3.op;
                Intrinsics.checkNotNull((Object)op, (String)"null cannot be cast to non-null type org.partiql.planner.internal.ir.Rex.Op.Select");
                Rex.Op.Select select = (Rex.Op.Select)op;
                PType pType = PType.dynamic();
                Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"dynamic(...)");
                rex2 = Plan.rex(new CompilerType(pType, false, false, 6, null), Plan.rexOpSubquery(select.constructor, select.rel, coercion));
            } else if (!bl) {
                Intrinsics.checkNotNull((Object)rex3);
                rex2 = rex3;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return rex2;
        }

        public static /* synthetic */ Rex visitExprCoerce$default(ToRex toRex, Expr expr, Env env, Rex.Op.Subquery.Coercion coercion, int n, Object object) {
            if ((n & 4) != 0) {
                coercion = Rex.Op.Subquery.Coercion.SCALAR;
            }
            return toRex.visitExprCoerce(expr, env, coercion);
        }

        @NotNull
        public Rex visitExprVarRef(@NotNull ExprVarRef node, @NotNull Env context) {
            Rex.Op.Var.Scope scope;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            CompilerType type = ANY;
            Identifier identifier = node.getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)identifier, (String)"getIdentifier(...)");
            org.partiql.spi.catalog.Identifier identifier2 = AstToPlan.INSTANCE.convert(identifier);
            boolean bl = node.isQualified();
            if (!bl) {
                scope = Rex.Op.Var.Scope.DEFAULT;
            } else if (bl) {
                scope = Rex.Op.Var.Scope.LOCAL;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Rex.Op.Var.Scope isQualified = scope;
            Rex.Op.Var.Unresolved op = Plan.rexOpVarUnresolved(identifier2, isQualified);
            return Plan.rex(type, op);
        }

        private final Rex resolveUnaryOp(String symbol, Expr rhs, Env context) {
            CompilerType type = ANY;
            Rex arg = ToRex.visitExprCoerce$default(this, rhs, context, null, 4, null);
            List args = CollectionsKt.listOf((Object)arg);
            String string = FunctionUtils.INSTANCE.getUnaryOp(symbol);
            if (string == null) {
                throw new IllegalStateException(("unsupported unary op " + symbol).toString());
            }
            String name = string;
            org.partiql.spi.catalog.Identifier id = org.partiql.spi.catalog.Identifier.Companion.delimited(name);
            Rex.Op.Call.Unresolved op = Plan.rexOpCallUnresolved(id, args);
            return Plan.rex(type, op);
        }

        /*
         * Unable to fully structure code
         */
        private final Rex resolveBinaryOp(Expr lhs, String symbol, Expr rhs, Env context) {
            block22: {
                type = ToRex.ANY;
                var7_6 = symbol;
                switch (var7_6.hashCode()) {
                    case 1921: {
                        if (!var7_6.equals("<=")) {
                            break;
                        }
                        ** GOTO lbl31
                    }
                    case 1922: {
                        if (!var7_6.equals("<>")) {
                            break;
                        }
                        ** GOTO lbl31
                    }
                    case 60: {
                        if (!var7_6.equals("<")) {
                            break;
                        }
                        ** GOTO lbl31
                    }
                    case 1084: {
                        if (!var7_6.equals("!=")) {
                            break;
                        }
                        ** GOTO lbl31
                    }
                    case 61: {
                        if (!var7_6.equals("=")) {
                            break;
                        }
                        ** GOTO lbl31
                    }
                    case 62: {
                        if (!var7_6.equals(">")) {
                            break;
                        }
                        ** GOTO lbl31
                    }
                    case 1983: {
                        if (!var7_6.equals(">=")) break;
lbl31:
                        // 7 sources

                        if (this.isLiteralArray(lhs) && this.isSqlSelect(rhs)) {
                            l = ToRex.visitExprCoerce$default(this, lhs, context, null, 4, null);
                            r = this.visitExprCoerce(rhs, context, Rex.Op.Subquery.Coercion.ROW);
                            var10_9 = new Rex[]{l, r};
                            v0 = CollectionsKt.listOf((Object[])var10_9);
                        } else if (this.isSqlSelect(lhs) && this.isLiteralArray(rhs)) {
                            l = this.visitExprCoerce(lhs, context, Rex.Op.Subquery.Coercion.ROW);
                            r = ToRex.visitExprCoerce$default(this, rhs, context, null, 4, null);
                            var10_9 = new Rex[]{l, r};
                            v0 = CollectionsKt.listOf((Object[])var10_9);
                        } else {
                            l = ToRex.visitExprCoerce$default(this, lhs, context, null, 4, null);
                            r = ToRex.visitExprCoerce$default(this, rhs, context, null, 4, null);
                            var10_9 = new Rex[]{l, r};
                            v0 = CollectionsKt.listOf((Object[])var10_9);
                        }
                        break block22;
                    }
                }
                l = ToRex.visitExprCoerce$default(this, lhs, context, null, 4, null);
                r = ToRex.visitExprCoerce$default(this, rhs, context, null, 4, null);
                var10_9 = new Rex[]{l, r};
                v0 = CollectionsKt.listOf((Object[])var10_9);
            }
            args = v0;
            var7_6 = symbol;
            if (Intrinsics.areEqual((Object)var7_6, (Object)"<>") != false ? true : Intrinsics.areEqual((Object)var7_6, (Object)"!=")) {
                $this$toTypedArray$iv = args;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                r = thisCollection$iv.toArray(new Rex[0]);
                op = this.negate(this.call(FunctionUtils.INSTANCE.getOP_EQ(), Arrays.copyOf(r, r.length)));
                v1 = Plan.rex(type, op);
            } else {
                v2 = FunctionUtils.INSTANCE.getBinaryOp(symbol);
                if (v2 == null) {
                    throw new IllegalStateException(("unsupported binary op " + symbol).toString());
                }
                name = v2;
                id = org.partiql.spi.catalog.Identifier.Companion.delimited(name);
                op = Plan.rexOpCallUnresolved(id, args);
                v1 = Plan.rex(type, op);
            }
            return v1;
        }

        @NotNull
        public Rex visitExprOperator(@NotNull ExprOperator node, @NotNull Env ctx) {
            Rex rex2;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Expr lhs = node.getLhs();
            if (lhs != null) {
                String string = node.getSymbol();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSymbol(...)");
                Expr expr = node.getRhs();
                Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getRhs(...)");
                rex2 = this.resolveBinaryOp(lhs, string, expr, ctx);
            } else {
                String string = node.getSymbol();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSymbol(...)");
                Expr expr = node.getRhs();
                Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getRhs(...)");
                rex2 = this.resolveUnaryOp(string, expr, ctx);
            }
            return rex2;
        }

        @NotNull
        public Rex visitExprBoolTest(@NotNull ExprBoolTest node, @NotNull Env ctx) {
            Rex.Op.Call call;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Expr expr = node.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getValue(...)");
            Rex value = ToRex.visitExprCoerce$default(this, expr, ctx, null, 4, null);
            switch (node.getTruthValue().code()) {
                case 0: {
                    Rex[] rexArray = new Rex[]{value};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_TRUE(), rexArray);
                    break;
                }
                case 1: {
                    Rex[] rexArray = new Rex[]{value};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_FALSE(), rexArray);
                    break;
                }
                case 2: {
                    Rex[] rexArray = new Rex[]{value};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_UNKNOWN(), rexArray);
                    break;
                }
                default: {
                    throw new IllegalStateException(("Unexpected TruthValue: " + node.getTruthValue()).toString());
                }
            }
            Rex.Op.Call call2 = call;
            if (node.isNot()) {
                call2 = this.negate(call2);
            }
            return Plan.rex(BOOL, call2);
        }

        @NotNull
        public Rex visitExprNot(@NotNull ExprNot node, @NotNull Env ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            CompilerType type = ANY;
            Expr expr = node.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getValue(...)");
            Rex arg = ToRex.visitExprCoerce$default(this, expr, ctx, null, 4, null);
            List args = CollectionsKt.listOf((Object)arg);
            org.partiql.spi.catalog.Identifier id = org.partiql.spi.catalog.Identifier.Companion.delimited(FunctionUtils.INSTANCE.getOP_NOT());
            Rex.Op.Call.Unresolved op = Plan.rexOpCallUnresolved(id, args);
            return Plan.rex(type, op);
        }

        @NotNull
        public Rex visitExprAnd(@NotNull ExprAnd node, @NotNull Env ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            CompilerType type = ANY;
            Expr expr = node.getLhs();
            Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getLhs(...)");
            Rex l = ToRex.visitExprCoerce$default(this, expr, ctx, null, 4, null);
            Expr expr2 = node.getRhs();
            Intrinsics.checkNotNullExpressionValue((Object)expr2, (String)"getRhs(...)");
            Rex r = ToRex.visitExprCoerce$default(this, expr2, ctx, null, 4, null);
            Object[] objectArray = new Rex[]{l, r};
            List args = CollectionsKt.listOf((Object[])objectArray);
            org.partiql.spi.catalog.Identifier id = org.partiql.spi.catalog.Identifier.Companion.delimited(FunctionUtils.INSTANCE.getOP_AND());
            Rex.Op.Call.Unresolved op = Plan.rexOpCallUnresolved(id, args);
            return Plan.rex(type, op);
        }

        @NotNull
        public Rex visitExprOr(@NotNull ExprOr node, @NotNull Env ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            CompilerType type = ANY;
            Expr expr = node.getLhs();
            Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getLhs(...)");
            Rex l = ToRex.visitExprCoerce$default(this, expr, ctx, null, 4, null);
            Expr expr2 = node.getRhs();
            Intrinsics.checkNotNullExpressionValue((Object)expr2, (String)"getRhs(...)");
            Rex r = ToRex.visitExprCoerce$default(this, expr2, ctx, null, 4, null);
            Object[] objectArray = new Rex[]{l, r};
            List args = CollectionsKt.listOf((Object[])objectArray);
            org.partiql.spi.catalog.Identifier id = org.partiql.spi.catalog.Identifier.Companion.delimited(FunctionUtils.INSTANCE.getOP_OR());
            Rex.Op.Call.Unresolved op = Plan.rexOpCallUnresolved(id, args);
            return Plan.rex(type, op);
        }

        private final boolean isLiteralArray(Expr node) {
            return node instanceof ExprArray;
        }

        private final boolean isSqlSelect(Expr node) {
            boolean bl;
            if (node instanceof ExprQuerySet) {
                QueryBody queryBody = ((ExprQuerySet)node).getBody();
                Intrinsics.checkNotNullExpressionValue((Object)queryBody, (String)"getBody(...)");
                QueryBody body = queryBody;
                bl = body instanceof QueryBody.SFW && (((QueryBody.SFW)body).getSelect() instanceof SelectList || ((QueryBody.SFW)body).getSelect() instanceof SelectStar);
            } else {
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NotNull
        public Rex visitExprPath(@NotNull ExprPath node, @NotNull Env context) {
            Rex rex2;
            void var14_22;
            Rel step;
            Pair pair;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Expr expr = node.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getRoot(...)");
            Rex root = ToRex.visitExprCoerce$default(this, expr, context, null, 4, null);
            Rex.Op op = root.op;
            if (op instanceof Rex.Op.Var.Unresolved) {
                PathStep step2;
                int i = 0;
                List parts = new ArrayList();
                parts.addAll(((Rex.Op.Var.Unresolved)op).identifier.getParts());
                Iterator iterator = node.getSteps().iterator();
                while (iterator.hasNext() && (step2 = (PathStep)iterator.next()) instanceof PathStep.Field) {
                    Identifier.Simple simple = ((PathStep.Field)step2).getField();
                    Intrinsics.checkNotNullExpressionValue((Object)simple, (String)"getField(...)");
                    parts.add(AstToPlan.INSTANCE.part(simple));
                    ++i;
                }
                Rex newRoot = Plan.rex(ANY, Plan.rexOpVarUnresolved(org.partiql.spi.catalog.Identifier.Companion.of(parts), ((Rex.Op.Var.Unresolved)op).scope));
                List newSteps = node.getSteps().subList(i, node.getSteps().size());
                pair = TuplesKt.to((Object)newRoot, newSteps);
            } else {
                pair = TuplesKt.to((Object)root, (Object)node.getSteps());
            }
            Pair pair2 = pair;
            Rex newRoot = (Rex)pair2.component1();
            List newSteps = (List)pair2.component2();
            if (newSteps.isEmpty()) {
                return newRoot;
            }
            List fromList = new ArrayList();
            int varRefIndex = 0;
            Iterable $this$fold$iv = newSteps;
            boolean $i$f$fold = false;
            Rex accumulator$iv = newRoot;
            for (Object t : $this$fold$iv) {
                Rex.Op.Var.Local op2;
                Rex.Op op3;
                PathStep pathStep = (PathStep)t;
                Rex current = accumulator$iv;
                boolean bl = false;
                Rel rel2 = step;
                if (rel2 instanceof PathStep.Element) {
                    Rex.Op.Path path;
                    Expr astKey;
                    Expr expr2 = ((PathStep.Element)step).getElement();
                    Intrinsics.checkNotNullExpressionValue((Object)expr2, (String)"getElement(...)");
                    Rex key = ToRex.visitExprCoerce$default(INSTANCE, expr2, context, null, 4, null);
                    Intrinsics.checkNotNullExpressionValue((Object)((PathStep.Element)step).getElement(), (String)"getElement(...)");
                    if (astKey instanceof ExprLit) {
                        path = ((ExprLit)astKey).getLit().code() == 6 ? (Rex.Op.Path)Plan.rexOpPathKey(current, key) : (Rex.Op.Path)Plan.rexOpPathIndex(current, key);
                    } else if (astKey instanceof ExprCast) {
                        boolean bl2;
                        boolean bl3 = bl2 = ((ExprCast)astKey).getAsType().code() == 8;
                        if (bl2) {
                            path = Plan.rexOpPathKey(current, key);
                        } else {
                            if (bl2) throw new NoWhenBranchMatchedException();
                            path = Plan.rexOpPathIndex(current, key);
                        }
                    } else {
                        path = Plan.rexOpPathIndex(current, key);
                    }
                    Rex.Op.Path op4 = path;
                    op3 = op4;
                } else if (rel2 instanceof PathStep.Field) {
                    Rex.Op.Path path;
                    boolean key = ((PathStep.Field)step).getField().isRegular();
                    if (key) {
                        String string = ((PathStep.Field)step).getField().getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        path = Plan.rexOpPathSymbol(current, string);
                    } else {
                        if (key) throw new NoWhenBranchMatchedException();
                        String string = ((PathStep.Field)step).getField().getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        path = Plan.rexOpPathKey(current, INSTANCE.rexString(string));
                    }
                    op3 = path;
                } else if (rel2 instanceof PathStep.AllFields) {
                    op2 = Plan.rexOpVarLocal(1, varRefIndex + 1);
                    varRefIndex += 2;
                    int index = fromList.size();
                    fromList.add(INSTANCE.relFromUnpivot(current, index));
                    op3 = op2;
                } else {
                    if (!(rel2 instanceof PathStep.AllElements)) throw new IllegalStateException(("Unexpected PathStep type: " + step).toString());
                    op2 = Plan.rexOpVarLocal(1, varRefIndex);
                    ++varRefIndex;
                    int index = fromList.size();
                    fromList.add(INSTANCE.relFromDefault(current, index));
                    op3 = op2;
                }
                Rex.Op path = op3;
                accumulator$iv = Plan.rex(ANY, path);
            }
            Rex pathNavi = accumulator$iv;
            if (fromList.size() == 0) {
                return pathNavi;
            }
            Iterable $this$reduce$iv = fromList;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object t = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void scan;
                step = (Rel)iterator$iv.next();
                Rel acc = (Rel)var14_22;
                boolean bl = false;
                List schema = CollectionsKt.plus((Collection)acc.type.schema, (Iterable)scan.type.schema);
                Set props = SetsKt.emptySet();
                Rel.Type type = Plan.relType(schema, props);
                Datum datum = Datum.bool((boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"bool(...)");
                Rel rel3 = Plan.rel(type, Plan.relOpJoin(acc, (Rel)scan, Plan.rex(BOOL, Plan.rexOpLit(datum)), Rel.Op.Join.Type.INNER));
            }
            Rel fromNode = (Rel)var14_22;
            int selectRef = fromNode.type.schema.size() - 1;
            Rex.Op op5 = pathNavi.op;
            if (op5 instanceof Rex.Op.Path.Index) {
                rex2 = Plan.rex(pathNavi.type, Plan.rexOpPathIndex(Plan.rex(((Rex.Op.Path.Index)op5).root.type, Plan.rexOpVarLocal(0, selectRef)), ((Rex.Op.Path.Index)op5).key));
            } else if (op5 instanceof Rex.Op.Path.Key) {
                rex2 = Plan.rex(pathNavi.type, Plan.rexOpPathKey(Plan.rex(((Rex.Op.Path.Key)op5).root.type, Plan.rexOpVarLocal(0, selectRef)), ((Rex.Op.Path.Key)op5).key));
            } else if (op5 instanceof Rex.Op.Path.Symbol) {
                rex2 = Plan.rex(pathNavi.type, Plan.rexOpPathSymbol(Plan.rex(((Rex.Op.Path.Symbol)op5).root.type, Plan.rexOpVarLocal(0, selectRef)), ((Rex.Op.Path.Symbol)op5).key));
            } else {
                if (!(op5 instanceof Rex.Op.Var.Local)) throw new IllegalStateException();
                rex2 = Plan.rex(pathNavi.type, Plan.rexOpVarLocal(0, selectRef));
            }
            Rex constructor = rex2;
            op5 = Plan.rexOpSelect(constructor, fromNode);
            return Plan.rex(ANY, op5);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Rex visitExprValues(@NotNull ExprValues node, @NotNull Env ctx) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            List list = node.getRows();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRows(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Expr expr = (Expr)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(ToRex.visitExprCoerce$default(INSTANCE, (Expr)it, ctx, null, 4, null));
            }
            List rows = (List)destination$iv$iv;
            return Plan.rex(BAG, Plan.rexOpCollection(rows));
        }

        private final Rel relFromDefault(Rex path, int index) {
            List schema = CollectionsKt.listOf((Object)Plan.relBinding("_v" + index, path.type));
            Set props = SetsKt.emptySet();
            Rel.Type relType2 = Plan.relType(schema, props);
            return Plan.rel(relType2, Plan.relOpScan(path));
        }

        private final Rel relFromUnpivot(Rex path, int index) {
            Object[] objectArray = new Rel.Binding[]{Plan.relBinding("_k" + index, STRING), Plan.relBinding("_v" + index, path.type)};
            List schema = CollectionsKt.listOf((Object[])objectArray);
            Set props = SetsKt.emptySet();
            Rel.Type relType2 = Plan.relType(schema, props);
            return Plan.rel(relType2, Plan.relOpUnpivot(path));
        }

        private final Rex rexString(String str) {
            Datum datum = Datum.string((String)str);
            Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"string(...)");
            return Plan.rex(STRING, Plan.rexOpLit(datum));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Rex visitExprCall(@NotNull ExprCall node, @NotNull Env context) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            CompilerType type = ANY;
            Identifier identifier = node.getFunction();
            Intrinsics.checkNotNullExpressionValue((Object)identifier, (String)"getFunction(...)");
            org.partiql.spi.catalog.Identifier id = AstToPlan.INSTANCE.convert(identifier);
            if (id.hasQualifier()) {
                throw new IllegalStateException("Qualified function calls are not currently supported.".toString());
            }
            if (org.partiql.spi.catalog.Identifier.matches$default((org.partiql.spi.catalog.Identifier)id, (String)"TUPLEUNION", (boolean)false, (int)2, null)) {
                return this.visitExprCallTupleUnion(node, context);
            }
            if (id.matches("EXISTS", true)) {
                return this.visitExprCallExists(node, context);
            }
            List list = node.getArgs();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getArgs(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Expr expr = (Expr)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(ToRex.visitExprCoerce$default(INSTANCE, (Expr)it, context, null, 4, null));
            }
            List args = (List)destination$iv$iv;
            if (this.isCollAgg(node)) {
                return this.callToCollAgg(id, node.getSetq(), args);
            }
            if (node.getSetq() != null) {
                throw new IllegalStateException("Currently, only COLL_<AGG> may use set quantifiers.".toString());
            }
            Rex.Op.Call.Unresolved op = Plan.rexOpCallUnresolved(id, args);
            return Plan.rex(type, op);
        }

        private final boolean isCollAgg(ExprCall node) {
            Identifier identifier = node.getFunction();
            Intrinsics.checkNotNullExpressionValue((Object)identifier, (String)"getFunction(...)");
            Identifier fn = identifier;
            if (fn.hasQualifier()) {
                return false;
            }
            Identifier.Simple simple = node.getFunction().getIdentifier();
            Intrinsics.checkNotNull((Object)simple);
            Identifier.Simple id = simple;
            String string = id.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            return COLL_AGG_NAMES.contains(string2);
        }

        private final Rex callToCollAgg(org.partiql.spi.catalog.Identifier id, SetQuantifier setQuantifier, List<Rex> args) {
            String string;
            Integer n;
            if (id.hasQualifier()) {
                throw new IllegalStateException("Qualified function calls are not currently supported.".toString());
            }
            if (args.size() != 1) {
                throw new IllegalStateException(("Aggregate calls currently only support single arguments. Received " + args.size() + " arguments.").toString());
            }
            SetQuantifier setQuantifier2 = setQuantifier;
            Integer n2 = n = setQuantifier2 != null ? Integer.valueOf(setQuantifier2.code()) : null;
            int n3 = 1;
            if (n2 != null && n2 == n3) {
                string = "_distinct";
            } else {
                Integer n4 = n;
                if (n4 != null && n4 == 0) {
                    string = "_all";
                } else if (n == null) {
                    string = "_all";
                } else {
                    throw new IllegalStateException(("Unexpected SetQuantifier type: " + setQuantifier).toString());
                }
            }
            String postfix = string;
            org.partiql.spi.catalog.Identifier newId = org.partiql.spi.catalog.Identifier.Companion.regular(FunctionUtils.INSTANCE.hide(id.getIdentifier().getText() + postfix));
            Rex.Op.Call.Unresolved op = new Rex.Op.Call.Unresolved(newId, CollectionsKt.listOf((Object)args.get(0)));
            return new Rex(ANY, op);
        }

        /*
         * WARNING - void declaration
         */
        private final Rex visitExprCallTupleUnion(ExprCall node, Env context) {
            void $this$mapTo$iv$iv;
            CompilerType type = STRUCT;
            List list = node.getArgs();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getArgs(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Expr expr = (Expr)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(ToRex.visitExprCoerce$default(INSTANCE, (Expr)it, context, null, 4, null));
            }
            List args = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            Rex.Op.TupleUnion op = Plan.rexOpTupleUnion(args);
            return Plan.rex(type, op);
        }

        private final Rex visitExprCallExists(ExprCall node, Env context) {
            CompilerType type = BOOL;
            if (node.getArgs().size() != 1) {
                throw new IllegalStateException("EXISTS requires a single argument.".toString());
            }
            Rex arg = (Rex)this.visitExpr((Expr)node.getArgs().get(0), context);
            Identifier identifier = node.getFunction();
            Intrinsics.checkNotNullExpressionValue((Object)identifier, (String)"getFunction(...)");
            Rex.Op.Call.Unresolved op = Plan.rexOpCallUnresolved(AstToPlan.INSTANCE.convert(identifier), CollectionsKt.listOf((Object)arg));
            return Plan.rex(type, op);
        }

        @NotNull
        public Rex visitExprCase(@NotNull ExprCase node, @NotNull Env context) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return (Rex)PlanBuilderKt.plan((Function1)new Function1<PlanBuilder, Rex>(node, context){
                final /* synthetic */ ExprCase $node;
                final /* synthetic */ Env $context;
                {
                    this.$node = $node;
                    this.$context = $context;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Rex invoke(@NotNull PlanBuilder $this$plan) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Rex rex2;
                    Intrinsics.checkNotNullParameter((Object)$this$plan, (String)"$this$plan");
                    CompilerType type = ToRex.access$getANY$p();
                    if (this.$node.getExpr() != null) {
                        Expr expr = this.$node.getExpr();
                        Intrinsics.checkNotNull((Object)expr);
                        rex2 = ToRex.visitExprCoerce$default(ToRex.INSTANCE, expr, this.$context, null, 4, null);
                    } else {
                        rex2 = null;
                    }
                    Rex rex3 = rex2;
                    org.partiql.spi.catalog.Identifier id = org.partiql.spi.catalog.Identifier.Companion.delimited(FunctionUtils.INSTANCE.getOP_EQ());
                    Function2 createBranch2 = (Function2)new Function2<Rex, Rex, Rex.Op.Case.Branch>(rex3, $this$plan, type, id){
                        final /* synthetic */ Rex $rex;
                        final /* synthetic */ PlanBuilder $this_plan;
                        final /* synthetic */ CompilerType $type;
                        final /* synthetic */ org.partiql.spi.catalog.Identifier $id;
                        {
                            this.$rex = $rex;
                            this.$this_plan = $this_plan;
                            this.$type = $type;
                            this.$id = $id;
                            super(2);
                        }

                        @NotNull
                        public final Rex.Op.Case.Branch invoke(@NotNull Rex condition, @NotNull Rex result) {
                            Rex rex2;
                            Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
                            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                            if (this.$rex == null) {
                                rex2 = condition;
                            } else {
                                Object[] objectArray = new Rex[]{this.$rex, condition};
                                rex2 = PlanBuilder.rex$partiql_planner$default(this.$this_plan, this.$type, Plan.rexOpCallUnresolved(this.$id, CollectionsKt.listOf((Object[])objectArray)), null, 4, null);
                            }
                            Rex updatedCondition = rex2;
                            return PlanBuilder.rexOpCaseBranch$partiql_planner$default(this.$this_plan, updatedCondition, result, null, 4, null);
                        }
                    };
                    List list = this.$node.getBranches();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBranches(...)");
                    Iterable iterable = list;
                    Env env = this.$context;
                    boolean $i$f$map = false;
                    void var10_9 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        ExprCase.Branch branch = (ExprCase.Branch)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Expr expr = it.getCondition();
                        Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getCondition(...)");
                        Rex branchCondition = ToRex.visitExprCoerce$default(ToRex.INSTANCE, expr, env, null, 4, null);
                        Expr expr2 = it.getExpr();
                        Intrinsics.checkNotNullExpressionValue((Object)expr2, (String)"getExpr(...)");
                        Rex branchRex = ToRex.visitExprCoerce$default(ToRex.INSTANCE, expr2, env, null, 4, null);
                        collection.add((Rex.Op.Case.Branch)createBranch2.invoke((Object)branchCondition, (Object)branchRex));
                    }
                    List branches = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                    Expr expr = this.$node.getDefaultExpr();
                    Rex defaultRex = expr == null ? PlanBuilder.rex$partiql_planner$default($this$plan, ToRex.access$getANY$p(), PlanBuilder.rexOpLit$partiql_planner$default($this$plan, Datum.nullValue(), null, 2, null), null, 4, null) : ToRex.visitExprCoerce$default(ToRex.INSTANCE, expr, this.$context, null, 4, null);
                    Rex.Op.Case op = PlanBuilder.rexOpCase$partiql_planner$default($this$plan, branches, defaultRex, null, 4, null);
                    return PlanBuilder.rex$partiql_planner$default($this$plan, type, op, null, 4, null);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Rex visitExprArray(@NotNull ExprArray node, @NotNull Env ctx) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            List list = node.getValues();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValues(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Expr expr = (Expr)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(ToRex.visitExprCoerce$default(INSTANCE, (Expr)it, ctx, null, 4, null));
            }
            List values = (List)destination$iv$iv;
            Rex.Op.Collection op = Plan.rexOpCollection(values);
            return Plan.rex(LIST, op);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Rex visitExprBag(@NotNull ExprBag node, @NotNull Env ctx) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            List list = node.getValues();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValues(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Expr expr = (Expr)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(ToRex.visitExprCoerce$default(INSTANCE, (Expr)it, ctx, null, 4, null));
            }
            List values = (List)destination$iv$iv;
            Rex.Op.Collection op = Plan.rexOpCollection(values);
            return Plan.rex(BAG, op);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Rex visitExprStruct(@NotNull ExprStruct node, @NotNull Env context) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            CompilerType type = STRUCT;
            List list = node.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFields(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ExprStruct.Field field = (ExprStruct.Field)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Expr expr = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getName(...)");
                Rex k = ToRex.visitExprCoerce$default(INSTANCE, expr, context, null, 4, null);
                Expr expr2 = it.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)expr2, (String)"getValue(...)");
                Rex v = ToRex.visitExprCoerce$default(INSTANCE, expr2, context, null, 4, null);
                collection.add(Plan.rexOpStructField(k, v));
            }
            List fields = (List)destination$iv$iv;
            Rex.Op.Struct op = Plan.rexOpStruct(fields);
            return Plan.rex(type, op);
        }

        @NotNull
        public Rex visitExprLike(@NotNull ExprLike node, @NotNull Env ctx) {
            Rex.Op.Call call;
            Rex.Op.Call call2;
            Rex[] rexArray;
            Rex arg2;
            Rex rex2;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            CompilerType type = BOOL;
            Expr expr = node.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getValue(...)");
            Rex arg0 = ToRex.visitExprCoerce$default(this, expr, ctx, null, 4, null);
            Expr expr2 = node.getPattern();
            Intrinsics.checkNotNullExpressionValue((Object)expr2, (String)"getPattern(...)");
            Rex arg1 = ToRex.visitExprCoerce$default(this, expr2, ctx, null, 4, null);
            Expr expr3 = node.getEscape();
            if (expr3 != null) {
                Expr it = expr3;
                boolean bl = false;
                rex2 = ToRex.visitExprCoerce$default(INSTANCE, it, ctx, null, 4, null);
            } else {
                rex2 = arg2 = null;
            }
            if (arg2 == null) {
                rexArray = new Rex[]{arg0, arg1};
                call2 = this.call(FunctionUtils.INSTANCE.getOP_LIKE(), rexArray);
            } else {
                rexArray = new Rex[]{arg0, arg1, arg2};
                call2 = call = this.call(FunctionUtils.INSTANCE.getOP_LIKE_ESCAPE(), rexArray);
            }
            if (node.isNot()) {
                call = this.negate(call);
            }
            return Plan.rex(type, call);
        }

        @NotNull
        public Rex visitExprBetween(@NotNull ExprBetween node, @NotNull Env ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            return (Rex)PlanBuilderKt.plan((Function1)new Function1<PlanBuilder, Rex>(node, ctx){
                final /* synthetic */ ExprBetween $node;
                final /* synthetic */ Env $ctx;
                {
                    this.$node = $node;
                    this.$ctx = $ctx;
                    super(1);
                }

                @NotNull
                public final Rex invoke(@NotNull PlanBuilder $this$plan) {
                    Intrinsics.checkNotNullParameter((Object)$this$plan, (String)"$this$plan");
                    CompilerType type = ToRex.access$getBOOL$p();
                    Expr expr = this.$node.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getValue(...)");
                    Rex arg0 = ToRex.visitExprCoerce$default(ToRex.INSTANCE, expr, this.$ctx, null, 4, null);
                    Expr expr2 = this.$node.getFrom();
                    Intrinsics.checkNotNullExpressionValue((Object)expr2, (String)"getFrom(...)");
                    Rex arg1 = ToRex.visitExprCoerce$default(ToRex.INSTANCE, expr2, this.$ctx, null, 4, null);
                    Expr expr3 = this.$node.getTo();
                    Intrinsics.checkNotNullExpressionValue((Object)expr3, (String)"getTo(...)");
                    Rex arg2 = ToRex.visitExprCoerce$default(ToRex.INSTANCE, expr3, this.$ctx, null, 4, null);
                    Rex[] rexArray = new Rex[]{arg0, arg1, arg2};
                    Rex.Op.Call call = ToRex.access$call(ToRex.INSTANCE, FunctionUtils.INSTANCE.getOP_BETWEEN(), rexArray);
                    if (this.$node.isNot()) {
                        call = ToRex.access$negate(ToRex.INSTANCE, call);
                    }
                    return PlanBuilder.rex$partiql_planner$default($this$plan, type, call, null, 4, null);
                }
            });
        }

        @NotNull
        public Rex visitExprInCollection(@NotNull ExprInCollection node, @NotNull Env ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            CompilerType type = BOOL;
            Expr expr = node.getLhs();
            Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getLhs(...)");
            Rex arg0 = ToRex.visitExprCoerce$default(this, expr, ctx, null, 4, null);
            Rex arg1 = (Rex)node.getRhs().accept((AstVisitor)this, (Object)ctx);
            String string = FunctionUtils.INSTANCE.getOP_IN_COLLECTION();
            Rex[] rexArray = new Rex[2];
            rexArray[0] = arg0;
            Intrinsics.checkNotNull((Object)arg1);
            rexArray[1] = arg1;
            Rex.Op.Call call = this.call(string, rexArray);
            if (node.isNot()) {
                call = this.negate(call);
            }
            return Plan.rex(type, call);
        }

        @NotNull
        public Rex visitExprNullPredicate(@NotNull ExprNullPredicate node, @NotNull Env ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Expr expr = node.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getValue(...)");
            Rex value = ToRex.visitExprCoerce$default(this, expr, ctx, null, 4, null);
            Rex[] rexArray = new Rex[]{value};
            Rex.Op.Call call = this.call(FunctionUtils.INSTANCE.getOP_IS_NULL(), rexArray);
            if (node.isNot()) {
                call = this.negate(call);
            }
            return Plan.rex(BOOL, call);
        }

        @NotNull
        public Rex visitExprMissingPredicate(@NotNull ExprMissingPredicate node, @NotNull Env ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Expr expr = node.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getValue(...)");
            Rex value = ToRex.visitExprCoerce$default(this, expr, ctx, null, 4, null);
            Rex[] rexArray = new Rex[]{value};
            Rex.Op.Call call = this.call(FunctionUtils.INSTANCE.getOP_IS_MISSING(), rexArray);
            if (node.isNot()) {
                call = this.negate(call);
            }
            return Plan.rex(BOOL, call);
        }

        @NotNull
        public Rex visitExprIsType(@NotNull ExprIsType node, @NotNull Env ctx) {
            Rex.Op.Call call;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            CompilerType type = BOOL;
            Expr expr = node.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getValue(...)");
            Rex arg0 = ToRex.visitExprCoerce$default(this, expr, ctx, null, 4, null);
            DataType dataType = node.getType();
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"getType(...)");
            DataType targetType = dataType;
            switch (targetType.code()) {
                case 0: 
                case 1: {
                    Rex[] rexArray = new Rex[]{this.toRex(targetType.getLength()), arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_CHAR(), rexArray);
                    break;
                }
                case 2: 
                case 4: {
                    Rex[] rexArray = new Rex[]{this.toRex(targetType.getLength()), arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_VARCHAR(), rexArray);
                    break;
                }
                case 7: {
                    Rex[] rexArray = new Rex[]{arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_CLOB(), rexArray);
                    break;
                }
                case 8: {
                    Rex[] rexArray;
                    if (targetType.getLength() == null) {
                        rexArray = new Rex[]{arg0};
                        call = this.call(FunctionUtils.INSTANCE.getOP_IS_STRING(), rexArray);
                        break;
                    }
                    rexArray = new Rex[]{this.toRex(targetType.getLength()), arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_STRING(), rexArray);
                    break;
                }
                case 9: {
                    Rex[] rexArray = new Rex[]{arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_SYMBOL(), rexArray);
                    break;
                }
                case 10: {
                    Rex[] rexArray = new Rex[]{arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_BLOB(), rexArray);
                    break;
                }
                case 12: {
                    Rex[] rexArray = new Rex[]{arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_BIT(), rexArray);
                    break;
                }
                case 13: {
                    Rex[] rexArray = new Rex[]{arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_BIT_VARYING(), rexArray);
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    Rex[] rexArray;
                    if (targetType.getPrecision() == null && targetType.getScale() == null) {
                        rexArray = new Rex[]{arg0};
                        call = this.call(FunctionUtils.INSTANCE.getOP_IS_DECIMAL(), rexArray);
                        break;
                    }
                    if (targetType.getScale() == null) {
                        rexArray = new Rex[]{this.toRex(targetType.getPrecision()), this.toRex(0), arg0};
                        call = this.call(FunctionUtils.INSTANCE.getOP_IS_DECIMAL(), rexArray);
                        break;
                    }
                    rexArray = new Rex[]{this.toRex(targetType.getPrecision()), this.toRex(targetType.getScale()), arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_DECIMAL(), rexArray);
                    break;
                }
                case 17: 
                case 18: 
                case 19: {
                    Rex[] rexArray = new Rex[]{arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_INT64(), rexArray);
                    break;
                }
                case 20: 
                case 21: 
                case 22: {
                    Rex[] rexArray = new Rex[]{arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_INT32(), rexArray);
                    break;
                }
                case 23: {
                    Rex[] rexArray = new Rex[]{arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_INT(), rexArray);
                    break;
                }
                case 24: 
                case 26: {
                    Rex[] rexArray = new Rex[]{arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_INT16(), rexArray);
                    break;
                }
                case 27: {
                    Rex[] rexArray = new Rex[]{arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_INT8(), rexArray);
                    break;
                }
                case 28: {
                    Rex[] rexArray = new Rex[]{arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_FLOAT32(), rexArray);
                    break;
                }
                case 29: {
                    Rex[] rexArray = new Rex[]{arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_REAL(), rexArray);
                    break;
                }
                case 30: {
                    Rex[] rexArray = new Rex[]{arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_FLOAT64(), rexArray);
                    break;
                }
                case 31: 
                case 32: {
                    Rex[] rexArray = new Rex[]{arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_BOOL(), rexArray);
                    break;
                }
                case 33: {
                    Rex[] rexArray = new Rex[]{arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_DATE(), rexArray);
                    break;
                }
                case 34: {
                    Rex[] rexArray = new Rex[]{arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_TIME(), rexArray);
                    break;
                }
                case 35: {
                    Rex[] rexArray = new Rex[]{arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_TIMEZ(), rexArray);
                    break;
                }
                case 36: {
                    Rex[] rexArray = new Rex[]{arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_TIMESTAMP(), rexArray);
                    break;
                }
                case 37: {
                    Rex[] rexArray = new Rex[]{arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_TIMESTAMPZ(), rexArray);
                    break;
                }
                case 38: {
                    Rex[] rexArray = new Rex[]{arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_INTERVAL(), rexArray);
                    break;
                }
                case 39: 
                case 40: {
                    Rex[] rexArray = new Rex[]{arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_STRUCT(), rexArray);
                    break;
                }
                case 41: {
                    Rex[] rexArray = new Rex[]{arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_LIST(), rexArray);
                    break;
                }
                case 43: {
                    Rex[] rexArray = new Rex[]{arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_BAG(), rexArray);
                    break;
                }
                case 44: {
                    Rex[] rexArray = new Rex[]{arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_SEXP(), rexArray);
                    break;
                }
                case 45: {
                    Rex[] rexArray = new Rex[]{arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_IS_CUSTOM(), rexArray);
                    break;
                }
                default: {
                    throw new IllegalStateException(("Unexpected DataType type: " + targetType).toString());
                }
            }
            Rex.Op.Call call2 = call;
            if (node.isNot()) {
                call2 = this.negate(call2);
            }
            return Plan.rex(type, call2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Rex visitExprCoalesce(@NotNull ExprCoalesce node, @NotNull Env ctx) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            CompilerType type = ANY;
            List list = node.getArgs();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getArgs(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void arg;
                Expr expr = (Expr)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)arg);
                collection.add(ToRex.visitExprCoerce$default(INSTANCE, (Expr)arg, ctx, null, 4, null));
            }
            List args = (List)destination$iv$iv;
            Rex.Op.Coalesce op = Plan.rexOpCoalesce(args);
            return Plan.rex(type, op);
        }

        @NotNull
        public Rex visitExprNullIf(@NotNull ExprNullIf node, @NotNull Env ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            CompilerType type = ANY;
            Expr expr = node.getV1();
            Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getV1(...)");
            Rex v1 = ToRex.visitExprCoerce$default(this, expr, ctx, null, 4, null);
            Expr expr2 = node.getV2();
            Intrinsics.checkNotNullExpressionValue((Object)expr2, (String)"getV2(...)");
            Rex v2 = ToRex.visitExprCoerce$default(this, expr2, ctx, null, 4, null);
            Rex.Op.Nullif op = Plan.rexOpNullif(v1, v2);
            return Plan.rex(type, op);
        }

        @NotNull
        public Rex visitExprSubstring(@NotNull ExprSubstring node, @NotNull Env ctx) {
            Rex.Op.Call call;
            Rex[] rexArray;
            Rex arg2;
            Rex rex2;
            Expr it;
            Object object;
            Rex arg0;
            CompilerType type;
            block8: {
                block7: {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    type = ANY;
                    Expr expr = node.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getValue(...)");
                    arg0 = ToRex.visitExprCoerce$default(this, expr, ctx, null, 4, null);
                    object = node.getStart();
                    if (object == null) break block7;
                    it = object;
                    boolean bl = false;
                    Rex rex3 = ToRex.visitExprCoerce$default(INSTANCE, it, ctx, null, 4, null);
                    object = rex3;
                    if (rex3 != null) break block8;
                }
                Datum datum = Datum.bigint((long)1L);
                Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"bigint(...)");
                object = Plan.rex(INT, Plan.rexOpLit(datum));
            }
            Object arg1 = object;
            Expr expr = node.getLength();
            if (expr != null) {
                it = expr;
                boolean bl = false;
                rex2 = ToRex.visitExprCoerce$default(INSTANCE, it, ctx, null, 4, null);
            } else {
                rex2 = arg2 = null;
            }
            if (arg2 == null) {
                rexArray = new Rex[]{arg0, arg1};
                call = this.call("substring", rexArray);
            } else {
                rexArray = new Rex[]{arg0, arg1, arg2};
                call = this.call("substring", rexArray);
            }
            Rex.Op.Call call2 = call;
            return Plan.rex(type, call2);
        }

        @NotNull
        public Rex visitExprPosition(@NotNull ExprPosition node, @NotNull Env ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            CompilerType type = ANY;
            Expr expr = node.getLhs();
            Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getLhs(...)");
            Rex arg0 = ToRex.visitExprCoerce$default(this, expr, ctx, null, 4, null);
            Expr expr2 = node.getRhs();
            Intrinsics.checkNotNullExpressionValue((Object)expr2, (String)"getRhs(...)");
            Rex arg1 = ToRex.visitExprCoerce$default(this, expr2, ctx, null, 4, null);
            Rex[] rexArray = new Rex[]{arg0, arg1};
            Rex.Op.Call call = this.call(FunctionUtils.INSTANCE.getOP_POSITION(), rexArray);
            return Plan.rex(type, call);
        }

        @NotNull
        public Rex visitExprTrim(@NotNull ExprTrim node, @NotNull Env ctx) {
            Rex.Op.Call call;
            Rex[] rexArray;
            Integer n;
            Rex rex2;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            CompilerType type = STRING;
            Expr expr = node.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getValue(...)");
            Rex arg0 = ToRex.visitExprCoerce$default(this, expr, ctx, null, 4, null);
            Expr expr2 = node.getChars();
            if (expr2 != null) {
                Expr it = expr2;
                boolean bl = false;
                rex2 = ToRex.visitExprCoerce$default(INSTANCE, it, ctx, null, 4, null);
            } else {
                rex2 = null;
            }
            Rex arg1 = rex2;
            TrimSpec trimSpec = node.getTrimSpec();
            Integer n2 = n = trimSpec != null ? Integer.valueOf(trimSpec.code()) : null;
            if (n2 != null && n2 == 0) {
                if (arg1 == null) {
                    rexArray = new Rex[]{arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_TRIM_LEADING(), rexArray);
                } else {
                    rexArray = new Rex[]{arg0, arg1};
                    call = this.call(FunctionUtils.INSTANCE.getOP_TRIM_LEADING_CHARS(), rexArray);
                }
            } else {
                Integer n3 = n;
                int n4 = 1;
                if (n3 != null && n3 == n4) {
                    if (arg1 == null) {
                        rexArray = new Rex[]{arg0};
                        call = this.call(FunctionUtils.INSTANCE.getOP_TRIM_TRAILING(), rexArray);
                    } else {
                        rexArray = new Rex[]{arg0, arg1};
                        call = this.call(FunctionUtils.INSTANCE.getOP_TRIM_TRAILING_CHARS(), rexArray);
                    }
                } else if (arg1 == null) {
                    rexArray = new Rex[]{arg0};
                    call = this.call(FunctionUtils.INSTANCE.getOP_TRIM(), rexArray);
                } else {
                    rexArray = new Rex[]{arg0, arg1};
                    call = this.call(FunctionUtils.INSTANCE.getOP_TRIM_CHARS(), rexArray);
                }
            }
            Rex.Op.Call call2 = call;
            return Plan.rex(type, call2);
        }

        @NotNull
        public Rex visitExprOverlay(@NotNull ExprOverlay node, @NotNull Env ctx) {
            Rex[] rexArray;
            Object object;
            Rex rs;
            Rex sp;
            Rex cv;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    Expr expr = node.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getValue(...)");
                    cv = ToRex.visitExprCoerce$default(this, expr, ctx, null, 4, null);
                    Expr expr2 = node.getFrom();
                    Intrinsics.checkNotNullExpressionValue((Object)expr2, (String)"getFrom(...)");
                    sp = ToRex.visitExprCoerce$default(this, expr2, ctx, null, 4, null);
                    Expr expr3 = node.getPlacing();
                    Intrinsics.checkNotNullExpressionValue((Object)expr3, (String)"getPlacing(...)");
                    rs = ToRex.visitExprCoerce$default(this, expr3, ctx, null, 4, null);
                    object = node.getForLength();
                    if (object == null) break block2;
                    Expr it = object;
                    boolean bl = false;
                    Rex rex2 = ToRex.visitExprCoerce$default(INSTANCE, it, ctx, null, 4, null);
                    object = rex2;
                    if (rex2 != null) break block3;
                }
                rexArray = new Rex[]{rs};
                object = Plan.rex(ANY, this.call("char_length", rexArray));
            }
            Object sl = object;
            Rex[] rexArray2 = new Rex[3];
            rexArray2[0] = cv;
            Datum datum = Datum.integer((int)1);
            Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"integer(...)");
            rexArray2[1] = Plan.rex(INT4, Plan.rexOpLit(datum));
            String string = FunctionUtils.INSTANCE.getOP_MINUS();
            rexArray = new Rex[2];
            rexArray[0] = sp;
            Datum datum2 = Datum.integer((int)1);
            Intrinsics.checkNotNullExpressionValue((Object)datum2, (String)"integer(...)");
            rexArray[1] = Plan.rex(INT4, Plan.rexOpLit(datum2));
            rexArray2[2] = Plan.rex(ANY, this.call(string, rexArray));
            Rex p1 = Plan.rex(ANY, this.call("substring", rexArray2));
            rexArray = new Rex[]{p1, rs};
            Rex p2 = Plan.rex(ANY, this.call(FunctionUtils.INSTANCE.getOP_CONCAT(), rexArray));
            rexArray = new Rex[2];
            rexArray[0] = p2;
            Rex[] rexArray3 = new Rex[2];
            rexArray3[0] = cv;
            Rex[] rexArray4 = new Rex[]{sp, sl};
            rexArray3[1] = Plan.rex(ANY, this.call(FunctionUtils.INSTANCE.getOP_PLUS(), rexArray4));
            rexArray[1] = Plan.rex(ANY, this.call("substring", rexArray3));
            return Plan.rex(ANY, this.call(FunctionUtils.INSTANCE.getOP_CONCAT(), rexArray));
        }

        @NotNull
        public Rex visitExprExtract(@NotNull ExprExtract node, @NotNull Env ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            DatetimeField datetimeField = node.getField();
            Intrinsics.checkNotNullExpressionValue((Object)datetimeField, (String)"getField(...)");
            String string = FunctionUtils.INSTANCE.opExtract(datetimeField);
            Rex[] rexArray = new Rex[1];
            Expr expr = node.getSource();
            Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getSource(...)");
            rexArray[0] = ToRex.visitExprCoerce$default(this, expr, ctx, null, 4, null);
            Rex.Op.Call call = this.call(string, rexArray);
            return Plan.rex(ANY, call);
        }

        @NotNull
        public Rex visitExprCast(@NotNull ExprCast node, @NotNull Env ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            DataType dataType = node.getAsType();
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"getAsType(...)");
            CompilerType type = this.visitType(dataType);
            Expr expr = node.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getValue(...)");
            Rex arg = ToRex.visitExprCoerce$default(this, expr, ctx, null, 4, null);
            return Plan.rex(ANY, Plan.rexOpCastUnresolved(type, arg));
        }

        /*
         * Unable to fully structure code
         */
        private final CompilerType visitType(DataType type) {
            switch (type.code()) {
                case 0: 
                case 1: {
                    v0 = type.getLength();
                    length = v0 == null ? 1 : v0;
                    v1 = this.assertGtZeroAndCreate(10, "length", length, (Function1<? super Integer, ? extends PType>)((Function1)visitType.1.INSTANCE));
                    break;
                }
                case 2: 
                case 4: {
                    v2 = type.getLength();
                    length = v2 == null ? 1 : v2;
                    v1 = this.assertGtZeroAndCreate(11, "length", length, (Function1<? super Integer, ? extends PType>)((Function1)visitType.2.INSTANCE));
                    break;
                }
                case 7: {
                    v3 = type.getLength();
                    v1 = this.assertGtZeroAndCreate(14, "length", v3 == null ? 0x7FFFFFFF : v3, (Function1<? super Integer, ? extends PType>)((Function1)visitType.3.INSTANCE));
                    break;
                }
                case 8: {
                    v4 = PType.string();
                    v1 = v4;
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"string(...)");
                    break;
                }
                case 10: {
                    v5 = type.getLength();
                    v1 = this.assertGtZeroAndCreate(13, "length", v5 == null ? 0x7FFFFFFF : v5, (Function1<? super Integer, ? extends PType>)((Function1)visitType.4.INSTANCE));
                    break;
                }
                case 12: {
                    throw new IllegalStateException("BIT is not supported yet.".toString());
                }
                case 13: {
                    throw new IllegalStateException("BIT VARYING is not supported yet.".toString());
                }
                case 14: {
                    p = type.getPrecision();
                    s = type.getScale();
                    if (p == null && s == null) {
                        v6 = PType.decimal((int)38, (int)0);
                    } else if (p != null && s != null) {
                        this.assertParamCompToZero(6, "precision", p, false);
                        this.assertParamCompToZero(6, "scale", s, true);
                        if (s > p) {
                            throw PErrors.INSTANCE.internalErrorException$partiql_planner(new IllegalArgumentException("Scale cannot be greater than precision."));
                        }
                        v7 = type.getPrecision();
                        Intrinsics.checkNotNull((Object)v7);
                        v8 = v7;
                        v9 = type.getScale();
                        Intrinsics.checkNotNull((Object)v9);
                        v6 = PType.decimal((int)v8, (int)v9);
                    } else if (p != null && s == null) {
                        this.assertParamCompToZero(6, "precision", p, false);
                        v6 = PType.decimal((int)p, (int)0);
                    } else {
                        throw new IllegalStateException("Precision can never be null while scale is specified.".toString());
                    }
                    var2_4 = v6;
                    Intrinsics.checkNotNull((Object)var2_4);
                    v1 = var2_4;
                    break;
                }
                case 15: 
                case 16: {
                    p = type.getPrecision();
                    s = type.getScale();
                    if (p == null && s == null) {
                        v10 = PType.decimal((int)38, (int)0);
                    } else if (p != null && s != null) {
                        this.assertParamCompToZero(7, "precision", p, false);
                        this.assertParamCompToZero(7, "scale", s, true);
                        if (s > p) {
                            throw PErrors.INSTANCE.internalErrorException$partiql_planner(new IllegalArgumentException("Decimal scale cannot be greater than precision."));
                        }
                        v10 = PType.decimal((int)p, (int)s);
                    } else if (p != null && s == null) {
                        this.assertParamCompToZero(7, "precision", p, false);
                        v10 = PType.decimal((int)p, (int)0);
                    } else {
                        throw new IllegalStateException("Precision can never be null while scale is specified.".toString());
                    }
                    var2_5 = v10;
                    Intrinsics.checkNotNull((Object)var2_5);
                    v1 = var2_5;
                    break;
                }
                case 17: 
                case 18: 
                case 19: {
                    v11 = PType.bigint();
                    v1 = v11;
                    Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"bigint(...)");
                    break;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    v12 = PType.integer();
                    v1 = v12;
                    Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"integer(...)");
                    break;
                }
                case 24: 
                case 26: {
                    v13 = PType.smallint();
                    v1 = v13;
                    Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"smallint(...)");
                    break;
                }
                case 27: {
                    v14 = PType.tinyint();
                    v1 = v14;
                    Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"tinyint(...)");
                    break;
                }
                case 28: {
                    v15 = PType.real();
                    v1 = v15;
                    Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"real(...)");
                    break;
                }
                case 29: {
                    v16 = PType.real();
                    v1 = v16;
                    Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"real(...)");
                    break;
                }
                case 30: {
                    v17 = PType.doublePrecision();
                    v1 = v17;
                    Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"doublePrecision(...)");
                    break;
                }
                case 32: {
                    v18 = PType.bool();
                    v1 = v18;
                    Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"bool(...)");
                    break;
                }
                case 33: {
                    v19 = PType.date();
                    v1 = v19;
                    Intrinsics.checkNotNullExpressionValue((Object)v19, (String)"date(...)");
                    break;
                }
                case 34: {
                    v20 = type.getPrecision();
                    v1 = this.assertGtEqZeroAndCreate(16, "precision", v20 == null ? 0 : v20, (Function1<? super Integer, ? extends PType>)((Function1)visitType.5.INSTANCE));
                    break;
                }
                case 35: {
                    v21 = type.getPrecision();
                    v1 = this.assertGtEqZeroAndCreate(17, "precision", v21 == null ? 0 : v21, (Function1<? super Integer, ? extends PType>)((Function1)visitType.6.INSTANCE));
                    break;
                }
                case 36: {
                    v22 = type.getPrecision();
                    v1 = this.assertGtEqZeroAndCreate(18, "precision", v22 == null ? 6 : v22, (Function1<? super Integer, ? extends PType>)((Function1)visitType.7.INSTANCE));
                    break;
                }
                case 37: {
                    v23 = type.getPrecision();
                    v1 = this.assertGtEqZeroAndCreate(19, "precision", v23 == null ? 6 : v23, (Function1<? super Integer, ? extends PType>)((Function1)visitType.8.INSTANCE));
                    break;
                }
                case 39: {
                    v24 = PType.struct();
                    v1 = v24;
                    Intrinsics.checkNotNullExpressionValue((Object)v24, (String)"struct(...)");
                    break;
                }
                case 40: {
                    v25 = PType.struct();
                    v1 = v25;
                    Intrinsics.checkNotNullExpressionValue((Object)v25, (String)"struct(...)");
                    break;
                }
                case 41: {
                    v26 = PType.array();
                    v1 = v26;
                    Intrinsics.checkNotNullExpressionValue((Object)v26, (String)"array(...)");
                    break;
                }
                case 43: {
                    v27 = PType.bag();
                    v1 = v27;
                    Intrinsics.checkNotNullExpressionValue((Object)v27, (String)"bag(...)");
                    break;
                }
                case 45: {
                    var2_6 = "Custom type not supported ";
                    throw new NotImplementedError("An operation is not implemented: " + var2_6);
                }
                case 38: {
                    q = type.getIntervalQualifier();
                    if (!(q instanceof IntervalQualifier.Single)) ** GOTO lbl196
                    v28 = ((IntervalQualifier.Single)q).getPrecision();
                    if (v28 == null) {
                        v28 = 2;
                    }
                    precision = ((Number)v28).intValue();
                    v29 = ((IntervalQualifier.Single)q).getFractionalPrecision();
                    if (v29 == null) {
                        v29 = 6;
                    }
                    fractionalPrecision = ((Number)v29).intValue();
                    switch (((IntervalQualifier.Single)q).getField().code()) {
                        case 0: {
                            v30 = PType.intervalYear((int)precision);
                            ** GOTO lbl231
                        }
                        case 1: {
                            v30 = PType.intervalMonth((int)precision);
                            ** GOTO lbl231
                        }
                        case 2: {
                            v30 = PType.intervalDay((int)precision);
                            ** GOTO lbl231
                        }
                        case 3: {
                            v30 = PType.intervalHour((int)precision);
                            ** GOTO lbl231
                        }
                        case 4: {
                            v30 = PType.intervalMinute((int)precision);
                            ** GOTO lbl231
                        }
                        case 5: {
                            v30 = PType.intervalSecond((int)precision, (int)fractionalPrecision);
                            ** GOTO lbl231
                        }
                        default: {
                            throw new IllegalStateException(("Unsupported DatetimeField: " + ((IntervalQualifier.Single)q).getField()).toString());
                        }
                    }
lbl196:
                    // 1 sources

                    if (!(q instanceof IntervalQualifier.Range)) ** GOTO lbl230
                    v31 = ((IntervalQualifier.Range)q).getStartFieldPrecision();
                    if (v31 == null) {
                        v31 = 2;
                    }
                    precision = ((Number)v31).intValue();
                    v32 = ((IntervalQualifier.Range)q).getEndFieldFractionalPrecision();
                    if (v32 == null) {
                        v32 = 6;
                    }
                    scale = ((Number)v32).intValue();
                    lhsField = ((IntervalQualifier.Range)q).getStartField().code();
                    rhsField = ((IntervalQualifier.Range)q).getEndField().code();
                    var8_17 = TuplesKt.to((Object)lhsField, (Object)rhsField);
                    if (Intrinsics.areEqual((Object)var8_17, (Object)TuplesKt.to((Object)0, (Object)1))) {
                        v30 = PType.intervalYearMonth((int)precision);
                    } else if (Intrinsics.areEqual((Object)var8_17, (Object)TuplesKt.to((Object)2, (Object)3))) {
                        v30 = PType.intervalDayHour((int)precision);
                    } else if (Intrinsics.areEqual((Object)var8_17, (Object)TuplesKt.to((Object)2, (Object)4))) {
                        v30 = PType.intervalDayMinute((int)precision);
                    } else if (Intrinsics.areEqual((Object)var8_17, (Object)TuplesKt.to((Object)2, (Object)5))) {
                        v30 = PType.intervalDaySecond((int)precision, (int)scale);
                    } else if (Intrinsics.areEqual((Object)var8_17, (Object)TuplesKt.to((Object)3, (Object)4))) {
                        v30 = PType.intervalHourMinute((int)precision);
                    } else if (Intrinsics.areEqual((Object)var8_17, (Object)TuplesKt.to((Object)3, (Object)5))) {
                        v30 = PType.intervalHourSecond((int)precision, (int)scale);
                    } else if (Intrinsics.areEqual((Object)var8_17, (Object)TuplesKt.to((Object)4, (Object)5))) {
                        v30 = PType.intervalMinuteSecond((int)precision, (int)scale);
                    } else {
                        throw new IllegalStateException(("Unsupported DatetimeField: " + lhsField + " to " + rhsField).toString());
lbl230:
                        // 1 sources

                        throw new IllegalStateException(("Unsupported IntervalQualifier: " + q).toString());
                    }
lbl231:
                    // 13 sources

                    var2_7 = v30;
                    Intrinsics.checkNotNull((Object)var2_7);
                    v1 = var2_7;
                    break;
                }
                default: {
                    throw new IllegalStateException(("Unsupported DataType type: " + type).toString());
                }
            }
            return PlanTyper.Companion.toCType(v1);
        }

        private final PType assertGtZeroAndCreate(int type, String param, int value, Function1<? super Integer, ? extends PType> create) {
            this.assertParamCompToZero(type, param, value, false);
            return (PType)create.invoke((Object)value);
        }

        private final PType assertGtEqZeroAndCreate(int type, String param, int value, Function1<? super Integer, ? extends PType> create) {
            this.assertParamCompToZero(type, param, value, true);
            return (PType)create.invoke((Object)value);
        }

        private final void assertParamCompToZero(int type, String param, int value, boolean allowZero) {
            Pair pair;
            boolean bl = allowZero;
            if (bl) {
                pair = TuplesKt.to((Object)(value >= 0 ? 1 : 0), (Object)"greater than");
            } else if (!bl) {
                pair = TuplesKt.to((Object)(value > 0 ? 1 : 0), (Object)"greater than or equal to");
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Pair pair2 = pair;
            boolean result = (Boolean)pair2.component1();
            String compString = (String)pair2.component2();
            if (!result) {
                throw PErrors.INSTANCE.internalErrorException$partiql_planner(new IllegalArgumentException("" + type + ' ' + param + " must be an integer value " + compString + " 0."));
            }
        }

        @NotNull
        public Rex visitExprSessionAttribute(@NotNull ExprSessionAttribute node, @NotNull Env ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            CompilerType type = ANY;
            String string = node.getSessionAttribute().name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String fn = string2;
            Rex.Op.Call call = this.call(FunctionUtils.INSTANCE.hide(fn), new Rex[0]);
            return Plan.rex(type, call);
        }

        @NotNull
        public Rex visitExprQuerySet(@NotNull ExprQuerySet node, @NotNull Env context) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return RelConverter.INSTANCE.apply$partiql_planner(node, context);
        }

        private final Rex.Op.Call negate(Rex.Op call) {
            org.partiql.spi.catalog.Identifier id = org.partiql.spi.catalog.Identifier.Companion.delimited(FunctionUtils.INSTANCE.getOP_NOT());
            Rex arg = Plan.rex(BOOL, call);
            return Plan.rexOpCallUnresolved(id, CollectionsKt.listOf((Object)arg));
        }

        private final Rex.Op.Call call(String name, Rex ... args) {
            org.partiql.spi.catalog.Identifier id = org.partiql.spi.catalog.Identifier.Companion.regular(name);
            return Plan.rexOpCallUnresolved(id, ArraysKt.toList((Object[])args));
        }

        private final Rex toRex(Integer $this$toRex) {
            Rex rex2;
            if ($this$toRex == null) {
                Datum datum = Datum.nullValue((PType)PType.integer());
                Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"nullValue(...)");
                rex2 = Plan.rex(INT4, Plan.rexOpLit(datum));
            } else {
                Datum datum = Datum.integer((int)$this$toRex);
                Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"integer(...)");
                rex2 = Plan.rex(INT4, Plan.rexOpLit(datum));
            }
            return rex2;
        }

        public static final /* synthetic */ CompilerType access$getANY$p() {
            return ANY;
        }

        public static final /* synthetic */ CompilerType access$getBOOL$p() {
            return BOOL;
        }

        public static final /* synthetic */ Rex.Op.Call access$call(ToRex $this, String name, Rex ... args) {
            return $this.call(name, args);
        }

        public static final /* synthetic */ Rex.Op.Call access$negate(ToRex $this, Rex.Op call) {
            return $this.negate(call);
        }

        static {
            Object[] objectArray = new String[]{"coll_any", "coll_avg", "coll_count", "coll_every", "coll_max", "coll_min", "coll_some", "coll_sum"};
            COLL_AGG_NAMES = SetsKt.setOf((Object[])objectArray);
            PType pType = PType.dynamic();
            Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"dynamic(...)");
            ANY = new CompilerType(pType, false, false, 6, null);
            PType pType2 = PType.bool();
            Intrinsics.checkNotNullExpressionValue((Object)pType2, (String)"bool(...)");
            BOOL = new CompilerType(pType2, false, false, 6, null);
            PType pType3 = PType.string();
            Intrinsics.checkNotNullExpressionValue((Object)pType3, (String)"string(...)");
            STRING = new CompilerType(pType3, false, false, 6, null);
            PType pType4 = PType.struct();
            Intrinsics.checkNotNullExpressionValue((Object)pType4, (String)"struct(...)");
            STRUCT = new CompilerType(pType4, false, false, 6, null);
            PType pType5 = PType.bag();
            Intrinsics.checkNotNullExpressionValue((Object)pType5, (String)"bag(...)");
            BAG = new CompilerType(pType5, false, false, 6, null);
            PType pType6 = PType.array();
            Intrinsics.checkNotNullExpressionValue((Object)pType6, (String)"array(...)");
            LIST = new CompilerType(pType6, false, false, 6, null);
            PType pType7 = PType.numeric((int)38, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)pType7, (String)"numeric(...)");
            INT = new CompilerType(pType7, false, false, 6, null);
            PType pType8 = PType.integer();
            Intrinsics.checkNotNullExpressionValue((Object)pType8, (String)"integer(...)");
            INT4 = new CompilerType(pType8, false, false, 6, null);
            PType pType9 = PType.timestamp((int)6);
            Intrinsics.checkNotNullExpressionValue((Object)pType9, (String)"timestamp(...)");
            TIMESTAMP = new CompilerType(pType9, false, false, 6, null);
        }
    }
}

