/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.planner.internal.transforms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.plan.Action;
import org.partiql.plan.Collation;
import org.partiql.plan.Exclusion;
import org.partiql.plan.JoinType;
import org.partiql.plan.Operators;
import org.partiql.plan.Plan;
import org.partiql.plan.rel.RelAggregate;
import org.partiql.plan.rel.RelType;
import org.partiql.plan.rex.RexBase;
import org.partiql.plan.rex.RexCase;
import org.partiql.plan.rex.RexStruct;
import org.partiql.plan.rex.RexType;
import org.partiql.plan.rex.RexVar;
import org.partiql.planner.internal.PlannerFlag;
import org.partiql.planner.internal.ir.PartiQLPlan;
import org.partiql.planner.internal.ir.PlanNode;
import org.partiql.planner.internal.ir.Rel;
import org.partiql.planner.internal.ir.Rex;
import org.partiql.planner.internal.ir.SetQuantifier;
import org.partiql.planner.internal.ir.Statement;
import org.partiql.planner.internal.ir.visitor.PlanBaseVisitor;
import org.partiql.planner.internal.typer.CompilerType;
import org.partiql.spi.errors.PErrorListener;
import org.partiql.spi.function.Agg;
import org.partiql.spi.function.Fn;
import org.partiql.spi.types.PType;
import org.partiql.spi.types.PTypeField;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\fB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/partiql/planner/internal/transforms/PlanTransform;", "", "flags", "", "Lorg/partiql/planner/internal/PlannerFlag;", "(Ljava/util/Set;)V", "transform", "Lorg/partiql/plan/Plan;", "internal", "Lorg/partiql/planner/internal/ir/PartiQLPlan;", "listener", "Lorg/partiql/spi/errors/PErrorListener;", "Visitor", "partiql-planner"})
public final class PlanTransform {
    @NotNull
    private final Set<PlannerFlag> flags;

    public PlanTransform(@NotNull Set<? extends PlannerFlag> flags) {
        Intrinsics.checkNotNullParameter(flags, (String)"flags");
        this.flags = flags;
    }

    @NotNull
    public final Plan transform(@NotNull PartiQLPlan internal, @NotNull PErrorListener listener) {
        Intrinsics.checkNotNullParameter((Object)internal, (String)"internal");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        boolean signal = this.flags.contains((Object)PlannerFlag.SIGNAL_MODE);
        Statement statement = internal.statement;
        Intrinsics.checkNotNull((Object)statement, (String)"null cannot be cast to non-null type org.partiql.planner.internal.ir.Statement.Query");
        Statement.Query query = (Statement.Query)statement;
        Visitor visitor = new Visitor(listener, signal);
        org.partiql.plan.rex.Rex root = visitor.visitRex(query.root, query.root.type);
        Action.Query action = () -> PlanTransform.transform$lambda$0(root);
        return () -> PlanTransform.transform$lambda$1(action);
    }

    private static final org.partiql.plan.rex.Rex transform$lambda$0(org.partiql.plan.rex.Rex $root) {
        Intrinsics.checkNotNullParameter((Object)$root, (String)"$root");
        return $root;
    }

    private static final Action transform$lambda$1(Action.Query $action) {
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        return (Action)$action;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001d\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010!\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010#\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010%\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020&2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010'\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010)\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020*2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010+\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020,2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u001a\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010\u0013\u001a\u00020/2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u00100\u001a\u0002012\u0006\u0010\u0013\u001a\u0002022\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u00103\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u0002042\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u00105\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u0002062\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u00107\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u0002082\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u00109\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020:2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010;\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020<2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010=\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020>2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010?\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020@2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010A\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020B2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010C\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020D2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010E\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020F2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010G\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020H2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010I\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020J2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u001a\u0010K\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020L2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010M\u001a\u00020N2\u0006\u0010\u0013\u001a\u00020O2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010P\u001a\u00020N2\u0006\u0010\u0013\u001a\u00020Q2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010R\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020S2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010T\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020U2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010V\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020W2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010X\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020Y2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010Z\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020[2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010\\\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020]2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010^\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020_2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010`\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020a2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010b\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020c2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010d\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020e2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010f\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020g2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010h\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020i2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010j\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020k2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010l\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020m2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010n\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020o2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010p\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020q2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010r\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020s2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010t\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020u2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010v\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020w2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010x\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020y2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010z\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020{2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010|\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020}2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006~"}, d2={"Lorg/partiql/planner/internal/transforms/PlanTransform$Visitor;", "Lorg/partiql/planner/internal/ir/visitor/PlanBaseVisitor;", "", "Lorg/partiql/spi/types/PType;", "listener", "Lorg/partiql/spi/errors/PErrorListener;", "signal", "", "(Lorg/partiql/spi/errors/PErrorListener;Z)V", "operators", "Lorg/partiql/plan/Operators;", "branch", "Lorg/partiql/plan/rex/RexCase$Branch;", "Lorg/partiql/planner/internal/ir/Rex$Op$Case$Branch;", "collation", "Lorg/partiql/plan/Collation;", "spec", "Lorg/partiql/planner/internal/ir/Rel$Op$Sort$Spec;", "defaultReturn", "node", "Lorg/partiql/planner/internal/ir/PlanNode;", "ctx", "defaultReturn$partiql_planner", "field", "Lorg/partiql/plan/rex/RexStruct$Field;", "Lorg/partiql/planner/internal/ir/Rex$Op$Struct$Field;", "visitRel", "Lorg/partiql/plan/rel/Rel;", "Lorg/partiql/planner/internal/ir/Rel;", "visitRelOp", "Lorg/partiql/planner/internal/ir/Rel$Op;", "visitRelOpAggregate", "Lorg/partiql/planner/internal/ir/Rel$Op$Aggregate;", "visitRelOpAggregateCallResolved", "Lorg/partiql/planner/internal/ir/Rel$Op$Aggregate$Call$Resolved;", "visitRelOpAggregateCallUnresolved", "Lorg/partiql/planner/internal/ir/Rel$Op$Aggregate$Call$Unresolved;", "visitRelOpDistinct", "Lorg/partiql/planner/internal/ir/Rel$Op$Distinct;", "visitRelOpErr", "Lorg/partiql/planner/internal/ir/Rel$Op$Err;", "visitRelOpExcept", "Lorg/partiql/planner/internal/ir/Rel$Op$Except;", "visitRelOpExclude", "Lorg/partiql/planner/internal/ir/Rel$Op$Exclude;", "visitRelOpExcludePath", "Lorg/partiql/plan/Exclusion;", "Lorg/partiql/planner/internal/ir/Rel$Op$Exclude$Path;", "visitRelOpExcludeStep", "Lorg/partiql/plan/Exclusion$Item;", "Lorg/partiql/planner/internal/ir/Rel$Op$Exclude$Step;", "visitRelOpFilter", "Lorg/partiql/planner/internal/ir/Rel$Op$Filter;", "visitRelOpIntersect", "Lorg/partiql/planner/internal/ir/Rel$Op$Intersect;", "visitRelOpJoin", "Lorg/partiql/planner/internal/ir/Rel$Op$Join;", "visitRelOpLimit", "Lorg/partiql/planner/internal/ir/Rel$Op$Limit;", "visitRelOpOffset", "Lorg/partiql/planner/internal/ir/Rel$Op$Offset;", "visitRelOpProject", "Lorg/partiql/planner/internal/ir/Rel$Op$Project;", "visitRelOpScan", "Lorg/partiql/planner/internal/ir/Rel$Op$Scan;", "visitRelOpScanIndexed", "Lorg/partiql/planner/internal/ir/Rel$Op$ScanIndexed;", "visitRelOpSort", "Lorg/partiql/planner/internal/ir/Rel$Op$Sort;", "visitRelOpUnion", "Lorg/partiql/planner/internal/ir/Rel$Op$Union;", "visitRelOpUnpivot", "Lorg/partiql/planner/internal/ir/Rel$Op$Unpivot;", "visitRelOpWith", "Lorg/partiql/planner/internal/ir/Rel$Op$With;", "visitRelOpWithWithListElement", "Lorg/partiql/planner/internal/ir/Rel$Op$With$WithListElement;", "visitRex", "Lorg/partiql/plan/rex/Rex;", "Lorg/partiql/planner/internal/ir/Rex;", "visitRexOp", "Lorg/partiql/planner/internal/ir/Rex$Op;", "visitRexOpCallDynamic", "Lorg/partiql/planner/internal/ir/Rex$Op$Call$Dynamic;", "visitRexOpCallStatic", "Lorg/partiql/planner/internal/ir/Rex$Op$Call$Static;", "visitRexOpCallUnresolved", "Lorg/partiql/planner/internal/ir/Rex$Op$Call$Unresolved;", "visitRexOpCase", "Lorg/partiql/planner/internal/ir/Rex$Op$Case;", "visitRexOpCastResolved", "Lorg/partiql/planner/internal/ir/Rex$Op$Cast$Resolved;", "visitRexOpCastUnresolved", "Lorg/partiql/planner/internal/ir/Rex$Op$Cast$Unresolved;", "visitRexOpCoalesce", "Lorg/partiql/planner/internal/ir/Rex$Op$Coalesce;", "visitRexOpCollection", "Lorg/partiql/planner/internal/ir/Rex$Op$Collection;", "visitRexOpErr", "Lorg/partiql/planner/internal/ir/Rex$Op$Err;", "visitRexOpLit", "Lorg/partiql/planner/internal/ir/Rex$Op$Lit;", "visitRexOpNullif", "Lorg/partiql/planner/internal/ir/Rex$Op$Nullif;", "visitRexOpPathIndex", "Lorg/partiql/planner/internal/ir/Rex$Op$Path$Index;", "visitRexOpPathKey", "Lorg/partiql/planner/internal/ir/Rex$Op$Path$Key;", "visitRexOpPathSymbol", "Lorg/partiql/planner/internal/ir/Rex$Op$Path$Symbol;", "visitRexOpPivot", "Lorg/partiql/planner/internal/ir/Rex$Op$Pivot;", "visitRexOpSelect", "Lorg/partiql/planner/internal/ir/Rex$Op$Select;", "visitRexOpStruct", "Lorg/partiql/planner/internal/ir/Rex$Op$Struct;", "visitRexOpSubquery", "Lorg/partiql/planner/internal/ir/Rex$Op$Subquery;", "visitRexOpTupleUnion", "Lorg/partiql/planner/internal/ir/Rex$Op$TupleUnion;", "visitRexOpVarGlobal", "Lorg/partiql/planner/internal/ir/Rex$Op$Var$Global;", "visitRexOpVarLocal", "Lorg/partiql/planner/internal/ir/Rex$Op$Var$Local;", "visitRexOpVarUnresolved", "Lorg/partiql/planner/internal/ir/Rex$Op$Var$Unresolved;", "partiql-planner"})
    @SourceDebugExtension(value={"SMAP\nPlanTransform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlanTransform.kt\norg/partiql/planner/internal/transforms/PlanTransform$Visitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,405:1\n1549#2:406\n1620#2,3:407\n1549#2:410\n1620#2,3:411\n1549#2:414\n1620#2,3:415\n1549#2:418\n1620#2,3:419\n1549#2:422\n1620#2,3:423\n1549#2:426\n1620#2,3:427\n1549#2:430\n1620#2,3:431\n1549#2:434\n1620#2,3:435\n1549#2:438\n1620#2,3:439\n1549#2:444\n1620#2,3:445\n1549#2:448\n1620#2,3:449\n1549#2:452\n1620#2,3:453\n1603#2,9:456\n1855#2:465\n1856#2:467\n1612#2:468\n1549#2:469\n1620#2,3:470\n1549#2:473\n1620#2,3:474\n1549#2:477\n1620#2,3:478\n1549#2:481\n1620#2,3:482\n37#3,2:442\n1#4:466\n*S KotlinDebug\n*F\n+ 1 PlanTransform.kt\norg/partiql/planner/internal/transforms/PlanTransform$Visitor\n*L\n99#1:406\n99#1:407,3\n131#1:410\n131#1:411,3\n136#1:414\n136#1:415,3\n145#1:418\n145#1:419,3\n156#1:422\n156#1:423,3\n163#1:426\n163#1:427,3\n164#1:430\n164#1:431,3\n171#1:434\n171#1:435,3\n229#1:438\n229#1:439,3\n240#1:444\n240#1:445,3\n241#1:448\n241#1:449,3\n259#1:452\n259#1:453,3\n280#1:456,9\n280#1:465\n280#1:467\n280#1:468\n286#1:469\n286#1:470,3\n291#1:473\n291#1:474,3\n303#1:477\n303#1:478,3\n342#1:481\n342#1:482,3\n229#1:442,2\n280#1:466\n*E\n"})
    private static final class Visitor
    extends PlanBaseVisitor<Object, PType> {
        @NotNull
        private final PErrorListener listener;
        private final boolean signal;
        @NotNull
        private final Operators operators;

        public Visitor(@NotNull PErrorListener listener, boolean signal) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            this.listener = listener;
            this.signal = signal;
            this.operators = Operators.STANDARD;
        }

        @Override
        @NotNull
        public Object defaultReturn$partiql_planner(@NotNull PlanNode node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            String string = "Translation not supported for " + Reflection.getOrCreateKotlinClass(node.getClass()).getSimpleName();
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        @NotNull
        public Object visitRexOpErr(@NotNull Rex.Op.Err node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            return this.operators.error(ctx);
        }

        @Override
        @NotNull
        public Object visitRelOpErr(@NotNull Rel.Op.Err node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            return this.operators.scan((org.partiql.plan.rex.Rex)this.operators.error(ctx));
        }

        @Override
        @NotNull
        public org.partiql.plan.rex.Rex visitRex(@NotNull Rex node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            org.partiql.plan.rex.Rex o = this.visitRexOp(node.op, node.type);
            o.setType(RexType.of((PType)ctx));
            return o;
        }

        @Override
        @NotNull
        public org.partiql.plan.rex.Rex visitRexOp(@NotNull Rex.Op node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Object r = super.visitRexOp(node, ctx);
            Intrinsics.checkNotNull(r, (String)"null cannot be cast to non-null type org.partiql.plan.rex.Rex");
            return (org.partiql.plan.rex.Rex)r;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Object visitRexOpTupleUnion(@NotNull Rex.Op.TupleUnion node, @NotNull PType ctx) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Iterable $this$map$iv = node.args;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Rex rex2 = (Rex)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.visitRex((Rex)it, ctx));
            }
            List args = (List)destination$iv$iv;
            return this.operators.spread(args);
        }

        @Override
        @NotNull
        public Object visitRexOpSelect(@NotNull Rex.Op.Select node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            org.partiql.plan.rel.Rel input = this.visitRel(node.rel, ctx);
            org.partiql.plan.rex.Rex constructor = this.visitRex(node.constructor, ctx);
            return this.operators.select(input, constructor);
        }

        @Override
        @NotNull
        public Object visitRexOpSubquery(@NotNull Rex.Op.Subquery node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            org.partiql.plan.rel.Rel input = this.visitRel(node.rel, ctx);
            org.partiql.plan.rex.Rex constructor = this.visitRex(node.constructor, ctx);
            boolean isScalar = node.coercion == Rex.Op.Subquery.Coercion.SCALAR;
            return this.operators.subquery(input, constructor, isScalar);
        }

        @Override
        @NotNull
        public Object visitRexOpPivot(@NotNull Rex.Op.Pivot node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            org.partiql.plan.rel.Rel input = this.visitRel(node.rel, ctx);
            org.partiql.plan.rex.Rex key = this.visitRex(node.key, ctx);
            org.partiql.plan.rex.Rex value = this.visitRex(node.value, ctx);
            return this.operators.pivot(input, key, value);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Object visitRexOpStruct(@NotNull Rex.Op.Struct node, @NotNull PType ctx) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Iterable $this$map$iv = node.fields;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Rex.Op.Struct.Field field = (Rex.Op.Struct.Field)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.field((Rex.Op.Struct.Field)it));
            }
            List fields = (List)destination$iv$iv;
            return this.operators.struct(fields);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Object visitRexOpCollection(@NotNull Rex.Op.Collection node, @NotNull PType ctx) {
            RexBase rexBase;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Iterable $this$map$iv = node.values;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Rex rex2 = (Rex)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.visitRex((Rex)it, ctx));
            }
            List values = (List)destination$iv$iv;
            switch (ctx.code()) {
                case 20: {
                    rexBase = (RexBase)this.operators.array(values);
                    break;
                }
                case 21: {
                    rexBase = (RexBase)this.operators.bag((Collection)values);
                    break;
                }
                default: {
                    StringBuilder stringBuilder = new StringBuilder().append("Expected bag or array, found ");
                    String string = ctx.name();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
                    String string2 = string.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    String string3 = stringBuilder.append(string2).toString();
                    throw new IllegalStateException(string3.toString());
                }
            }
            return rexBase;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Object visitRexOpCoalesce(@NotNull Rex.Op.Coalesce node, @NotNull PType ctx) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Iterable $this$map$iv = node.args;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Rex rex2 = (Rex)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.visitRex((Rex)it, ctx));
            }
            List args = (List)destination$iv$iv;
            return this.operators.coalesce(args);
        }

        @Override
        @NotNull
        public Object visitRexOpNullif(@NotNull Rex.Op.Nullif node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            org.partiql.plan.rex.Rex value = this.visitRex(node.value, ctx);
            org.partiql.plan.rex.Rex nullifier = this.visitRex(node.nullifier, ctx);
            return this.operators.nullIf(value, nullifier);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Object visitRexOpCase(@NotNull Rex.Op.Case node, @NotNull PType ctx) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Iterable $this$map$iv = node.branches;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Rex.Op.Case.Branch branch = (Rex.Op.Case.Branch)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.branch((Rex.Op.Case.Branch)it));
            }
            List branches = (List)destination$iv$iv;
            org.partiql.plan.rex.Rex rex2 = this.visitRex(node.default, ctx);
            return this.operators.caseWhen(null, branches, rex2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Object visitRexOpCallDynamic(@NotNull Rex.Op.Call.Dynamic node, @NotNull PType ctx) {
            void $this$mapTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Iterable $this$map$iv = node.args;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Rex rex2 = (Rex)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.visitRex((Rex)it, ctx));
            }
            List args = (List)destination$iv$iv;
            Iterable $this$map$iv2 = node.candidates;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Rex.Op.Call.Dynamic.Candidate bl = (Rex.Op.Call.Dynamic.Candidate)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.fn.signature);
            }
            List fns = (List)destination$iv$iv2;
            String name = ((Rex.Op.Call.Dynamic.Candidate)CollectionsKt.first(node.candidates)).fn.name.getName();
            return this.operators.dispatch(name, fns, args);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Object visitRexOpCallStatic(@NotNull Rex.Op.Call.Static node, @NotNull PType ctx) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Fn fn = node.fn;
            Iterable $this$map$iv = node.args;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Rex rex2 = (Rex)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.visitRex((Rex)it, it.type));
            }
            List args = (List)destination$iv$iv;
            return this.operators.call(fn, args);
        }

        @Override
        @NotNull
        public Object visitRexOpCallUnresolved(@NotNull Rex.Op.Call.Unresolved node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            throw new IllegalStateException("The Internal Node Rex.Op.Call.Unresolved should be converted to an Err Node during type resolution if resolution failed".toString());
        }

        @Override
        @NotNull
        public Object visitRexOpCastUnresolved(@NotNull Rex.Op.Cast.Unresolved node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            throw new IllegalStateException("This should have been converted to an error node.".toString());
        }

        @Override
        @NotNull
        public Object visitRexOpCastResolved(@NotNull Rex.Op.Cast.Resolved node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            org.partiql.plan.rex.Rex operand = this.visitRex(node.arg, ctx);
            CompilerType target = node.cast.target;
            return this.operators.cast(operand, (PType)target);
        }

        @Override
        @NotNull
        public Object visitRexOpPathSymbol(@NotNull Rex.Op.Path.Symbol node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            org.partiql.plan.rex.Rex operand = this.visitRex(node.root, ctx);
            String symbol = node.key;
            return this.operators.pathSymbol(operand, symbol);
        }

        @Override
        @NotNull
        public Object visitRexOpPathKey(@NotNull Rex.Op.Path.Key node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            org.partiql.plan.rex.Rex operand = this.visitRex(node.root, ctx);
            org.partiql.plan.rex.Rex key = this.visitRex(node.key, ctx);
            return this.operators.pathKey(operand, key);
        }

        @Override
        @NotNull
        public Object visitRexOpPathIndex(@NotNull Rex.Op.Path.Index node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            org.partiql.plan.rex.Rex operand = this.visitRex(node.root, ctx);
            org.partiql.plan.rex.Rex index = this.visitRex(node.key, ctx);
            return this.operators.pathIndex(operand, index);
        }

        @Override
        @NotNull
        public Object visitRexOpVarGlobal(@NotNull Rex.Op.Var.Global node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            return this.operators.table(node.ref.table);
        }

        @Override
        @NotNull
        public Object visitRexOpVarUnresolved(@NotNull Rex.Op.Var.Unresolved node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            throw new IllegalStateException("The Internal Plan Node Rex.Op.Var.Unresolved should be converted to an MISSING Node during type resolution if resolution failed".toString());
        }

        @Override
        @NotNull
        public Object visitRexOpVarLocal(@NotNull Rex.Op.Var.Local node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            int depth = node.depth;
            int offset = node.ref;
            return this.operators.variable(depth, offset, ctx);
        }

        @Override
        @NotNull
        public Object visitRexOpLit(@NotNull Rex.Op.Lit node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            return this.operators.lit(node.value);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public org.partiql.plan.rel.Rel visitRel(@NotNull Rel node, @NotNull PType ctx) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            org.partiql.plan.rel.Rel o = this.visitRelOp(node.op, ctx);
            Iterable $this$map$iv = node.type.schema;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Rel.Binding binding = (Rel.Binding)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(PTypeField.of((String)it.name, (PType)it.type));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            PTypeField[] fields = thisCollection$iv.toArray(new PTypeField[0]);
            int properties = node.type.props.contains((Object)Rel.Prop.ORDERED) ? 1 : 0;
            o.setType(RelType.of((PTypeField[])fields, (int)properties));
            return o;
        }

        @Override
        @NotNull
        public org.partiql.plan.rel.Rel visitRelOp(@NotNull Rel.Op node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Object r = super.visitRelOp(node, ctx);
            Intrinsics.checkNotNull(r, (String)"null cannot be cast to non-null type org.partiql.plan.rel.Rel");
            return (org.partiql.plan.rel.Rel)r;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Object visitRelOpAggregate(@NotNull Rel.Op.Aggregate node, @NotNull PType ctx) {
            void $this$mapTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            org.partiql.plan.rel.Rel input = this.visitRel(node.input, ctx);
            Iterable $this$map$iv = node.calls;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Rel.Op.Aggregate.Call call = (Rel.Op.Aggregate.Call)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Object r = this.visitRelOpAggregateCall((Rel.Op.Aggregate.Call)it, ctx);
                Intrinsics.checkNotNull(r, (String)"null cannot be cast to non-null type org.partiql.plan.rel.RelAggregate.Measure");
                collection.add((RelAggregate.Measure)r);
            }
            List calls = (List)destination$iv$iv;
            Iterable $this$map$iv2 = node.groups;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Rex bl = (Rex)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(this.visitRex((Rex)it, ctx));
            }
            List groups = (List)destination$iv$iv2;
            return this.operators.aggregate(input, calls, groups);
        }

        @Override
        @NotNull
        public org.partiql.plan.rel.Rel visitRelOpWith(@NotNull Rel.Op.With node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            return this.visitRel(node.input, ctx);
        }

        @Override
        @Nullable
        public Object visitRelOpWithWithListElement(@NotNull Rel.Op.With.WithListElement node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            throw new IllegalStateException("WITH clause element was not transformed yet.".toString());
        }

        @Override
        @NotNull
        public Object visitRelOpAggregateCallUnresolved(@NotNull Rel.Op.Aggregate.Call.Unresolved node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            throw new IllegalStateException(("Unresolved aggregate call " + node).toString());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Object visitRelOpAggregateCallResolved(@NotNull Rel.Op.Aggregate.Call.Resolved node, @NotNull PType ctx) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Agg agg = node.agg.signature;
            Iterable $this$map$iv = node.args;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Rex rex2 = (Rex)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.visitRex((Rex)it, ctx));
            }
            List args = (List)destination$iv$iv;
            boolean isDistinct = node.setq == SetQuantifier.DISTINCT;
            RelAggregate.Measure measure = RelAggregate.measure((Agg)agg, (List)args, (boolean)isDistinct);
            Intrinsics.checkNotNullExpressionValue((Object)measure, (String)"measure(...)");
            return measure;
        }

        @Override
        @NotNull
        public Object visitRelOpJoin(@NotNull Rel.Op.Join node, @NotNull PType ctx) {
            JoinType joinType;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            org.partiql.plan.rel.Rel lhs = this.visitRel(node.lhs, ctx);
            org.partiql.plan.rel.Rel rhs = this.visitRel(node.rhs, ctx);
            org.partiql.plan.rex.Rex condition = this.visitRex(node.rex, ctx);
            switch (WhenMappings.$EnumSwitchMapping$0[node.type.ordinal()]) {
                case 1: {
                    joinType = JoinType.INNER();
                    break;
                }
                case 2: {
                    joinType = JoinType.LEFT();
                    break;
                }
                case 3: {
                    joinType = JoinType.RIGHT();
                    break;
                }
                case 4: {
                    joinType = JoinType.FULL();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            JoinType joinType2 = joinType;
            Intrinsics.checkNotNull((Object)joinType2);
            JoinType joinType3 = joinType2;
            return this.operators.join(lhs, rhs, condition, joinType3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Object visitRelOpExclude(@NotNull Rel.Op.Exclude node, @NotNull PType ctx) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            org.partiql.plan.rel.Rel input = this.visitRel(node.input, ctx);
            Iterable $this$mapNotNull$iv = node.paths;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Exclusion it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Rel.Op.Exclude.Path it = (Rel.Op.Exclude.Path)element$iv$iv;
                boolean bl2 = false;
                if (this.visitRelOpExcludePath(it, ctx) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List paths = (List)destination$iv$iv;
            return this.operators.exclude(input, paths);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public Exclusion visitRelOpExcludePath(@NotNull Rel.Op.Exclude.Path node, @NotNull PType ctx) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            org.partiql.plan.rex.Rex rex2 = this.visitRexOp(node.root, ctx);
            RexVar rexVar = rex2 instanceof RexVar ? (RexVar)rex2 : null;
            if (rexVar == null) {
                return null;
            }
            RexVar variable = rexVar;
            Iterable $this$map$iv = node.steps;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Rel.Op.Exclude.Step step = (Rel.Op.Exclude.Step)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.visitRelOpExcludeStep((Rel.Op.Exclude.Step)it, ctx));
            }
            List items = (List)destination$iv$iv;
            return new Exclusion(variable, items);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Exclusion.Item visitRelOpExcludeStep(@NotNull Rel.Op.Exclude.Step node, @NotNull PType ctx) {
            Exclusion.Item item;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Iterable $this$map$iv = node.substeps;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Rel.Op.Exclude.Step step = (Rel.Op.Exclude.Step)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.visitRelOpExcludeStep((Rel.Op.Exclude.Step)it, ctx));
            }
            List items = (List)destination$iv$iv;
            Rel.Op.Exclude.Type type = node.type;
            if (type instanceof Rel.Op.Exclude.Type.CollIndex) {
                item = (Exclusion.Item)Exclusion.Companion.collIndex(((Rel.Op.Exclude.Type.CollIndex)node.type).index, items);
            } else if (type instanceof Rel.Op.Exclude.Type.CollWildcard) {
                item = (Exclusion.Item)Exclusion.Companion.collWildcard(items);
            } else if (type instanceof Rel.Op.Exclude.Type.StructKey) {
                item = (Exclusion.Item)Exclusion.Companion.structKey(((Rel.Op.Exclude.Type.StructKey)node.type).key, items);
            } else if (type instanceof Rel.Op.Exclude.Type.StructSymbol) {
                item = (Exclusion.Item)Exclusion.Companion.structSymbol(((Rel.Op.Exclude.Type.StructSymbol)node.type).symbol, items);
            } else if (type instanceof Rel.Op.Exclude.Type.StructWildcard) {
                item = (Exclusion.Item)Exclusion.Companion.structWildCard(items);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return item;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Object visitRelOpProject(@NotNull Rel.Op.Project node, @NotNull PType ctx) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            org.partiql.plan.rel.Rel input = this.visitRel(node.input, ctx);
            Iterable $this$map$iv = node.projections;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Rex rex2 = (Rex)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.visitRex((Rex)it, ctx));
            }
            List projections = (List)destination$iv$iv;
            return this.operators.project(input, projections);
        }

        @Override
        @NotNull
        public Object visitRelOpOffset(@NotNull Rel.Op.Offset node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            org.partiql.plan.rel.Rel input = this.visitRel(node.input, ctx);
            org.partiql.plan.rex.Rex offset = this.visitRex(node.offset, ctx);
            return this.operators.offset(input, offset);
        }

        @Override
        @NotNull
        public Object visitRelOpLimit(@NotNull Rel.Op.Limit node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            org.partiql.plan.rel.Rel input = this.visitRel(node.input, ctx);
            org.partiql.plan.rex.Rex limit = this.visitRex(node.limit, ctx);
            return this.operators.limit(input, limit);
        }

        @Override
        @NotNull
        public Object visitRelOpIntersect(@NotNull Rel.Op.Intersect node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            org.partiql.plan.rel.Rel lhs = this.visitRel(node.lhs, ctx);
            org.partiql.plan.rel.Rel rhs = this.visitRel(node.rhs, ctx);
            boolean isAll = node.setq == SetQuantifier.ALL;
            return this.operators.intersect(lhs, rhs, isAll);
        }

        @Override
        @NotNull
        public Object visitRelOpUnion(@NotNull Rel.Op.Union node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            org.partiql.plan.rel.Rel lhs = this.visitRel(node.lhs, ctx);
            org.partiql.plan.rel.Rel rhs = this.visitRel(node.rhs, ctx);
            boolean isAll = node.setq == SetQuantifier.ALL;
            return this.operators.union(lhs, rhs, isAll);
        }

        @Override
        @NotNull
        public Object visitRelOpExcept(@NotNull Rel.Op.Except node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            org.partiql.plan.rel.Rel lhs = this.visitRel(node.lhs, ctx);
            org.partiql.plan.rel.Rel rhs = this.visitRel(node.rhs, ctx);
            boolean isAll = node.setq == SetQuantifier.ALL;
            return this.operators.except(lhs, rhs, isAll);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Object visitRelOpSort(@NotNull Rel.Op.Sort node, @NotNull PType ctx) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            org.partiql.plan.rel.Rel input = this.visitRel(node.input, ctx);
            Iterable $this$map$iv = node.specs;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Rel.Op.Sort.Spec spec = (Rel.Op.Sort.Spec)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.collation((Rel.Op.Sort.Spec)it));
            }
            List collations = (List)destination$iv$iv;
            return this.operators.sort(input, collations);
        }

        @Override
        @NotNull
        public Object visitRelOpFilter(@NotNull Rel.Op.Filter node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            org.partiql.plan.rel.Rel input = this.visitRel(node.input, ctx);
            org.partiql.plan.rex.Rex condition = this.visitRex(node.predicate, ctx);
            return this.operators.filter(input, condition);
        }

        @Override
        @NotNull
        public Object visitRelOpDistinct(@NotNull Rel.Op.Distinct node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            org.partiql.plan.rel.Rel input = this.visitRel(node.input, ctx);
            return this.operators.distinct(input);
        }

        @Override
        @NotNull
        public Object visitRelOpUnpivot(@NotNull Rel.Op.Unpivot node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            org.partiql.plan.rex.Rex input = this.visitRex(node.rex, ctx);
            return this.operators.unpivot(input);
        }

        @Override
        @NotNull
        public Object visitRelOpScanIndexed(@NotNull Rel.Op.ScanIndexed node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            org.partiql.plan.rex.Rex input = this.visitRex(node.rex, ctx);
            return this.operators.iterate(input);
        }

        @Override
        @NotNull
        public Object visitRelOpScan(@NotNull Rel.Op.Scan node, @NotNull PType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            org.partiql.plan.rex.Rex input = this.visitRex(node.rex, ctx);
            return this.operators.scan(input);
        }

        private final Collation collation(Rel.Op.Sort.Spec spec) {
            Pair pair;
            org.partiql.plan.rex.Rex rex2 = this.visitRex(spec.rex, spec.rex.type);
            switch (WhenMappings.$EnumSwitchMapping$1[spec.order.ordinal()]) {
                case 1: {
                    pair = TuplesKt.to((Object)Collation.Order.ASC(), (Object)Collation.Nulls.LAST());
                    break;
                }
                case 2: {
                    pair = TuplesKt.to((Object)Collation.Order.ASC(), (Object)Collation.Nulls.FIRST());
                    break;
                }
                case 3: {
                    pair = TuplesKt.to((Object)Collation.Order.DESC(), (Object)Collation.Nulls.LAST());
                    break;
                }
                case 4: {
                    pair = TuplesKt.to((Object)Collation.Order.DESC(), (Object)Collation.Nulls.FIRST());
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Pair pair2 = pair;
            Collation.Order order = (Collation.Order)pair2.component1();
            Collation.Nulls nulls = (Collation.Nulls)pair2.component2();
            return new Collation(rex2, order, nulls){
                final /* synthetic */ org.partiql.plan.rex.Rex $rex;
                final /* synthetic */ Collation.Order $order;
                final /* synthetic */ Collation.Nulls $nulls;
                {
                    this.$rex = $rex;
                    this.$order = $order;
                    this.$nulls = $nulls;
                }

                @NotNull
                public org.partiql.plan.rex.Rex getColumn() {
                    return this.$rex;
                }

                @NotNull
                public Collation.Order getOrder() {
                    Collation.Order order = this.$order;
                    Intrinsics.checkNotNullExpressionValue((Object)order, (String)"$order");
                    return order;
                }

                @NotNull
                public Collation.Nulls getNulls() {
                    Collation.Nulls nulls = this.$nulls;
                    Intrinsics.checkNotNullExpressionValue((Object)nulls, (String)"$nulls");
                    return nulls;
                }
            };
        }

        private final RexStruct.Field field(Rex.Op.Struct.Field field) {
            org.partiql.plan.rex.Rex key = this.visitRex(field.k, field.k.type);
            org.partiql.plan.rex.Rex value = this.visitRex(field.v, field.v.type);
            RexStruct.Field field2 = RexStruct.field((org.partiql.plan.rex.Rex)key, (org.partiql.plan.rex.Rex)value);
            Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"field(...)");
            return field2;
        }

        private final RexCase.Branch branch(Rex.Op.Case.Branch branch) {
            org.partiql.plan.rex.Rex condition = this.visitRex(branch.condition, branch.condition.type);
            org.partiql.plan.rex.Rex result = this.visitRex(branch.rex, branch.rex.type);
            RexCase.Branch branch2 = RexCase.branch((org.partiql.plan.rex.Rex)condition, (org.partiql.plan.rex.Rex)result);
            Intrinsics.checkNotNullExpressionValue((Object)branch2, (String)"branch(...)");
            return branch2;
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[Rel.Op.Join.Type.values().length];
                try {
                    nArray[Rel.Op.Join.Type.INNER.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Rel.Op.Join.Type.LEFT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Rel.Op.Join.Type.RIGHT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Rel.Op.Join.Type.FULL.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[Rel.Op.Sort.Order.values().length];
                try {
                    nArray[Rel.Op.Sort.Order.ASC_NULLS_LAST.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Rel.Op.Sort.Order.ASC_NULLS_FIRST.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Rel.Op.Sort.Order.DESC_NULLS_LAST.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Rel.Op.Sort.Order.DESC_NULLS_FIRST.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }
}

