/*
 * Decompiled with CFR 0.152.
 */
package panda.utilities.text;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class Joiner {
    private final String separator;
    private final StringBuilder builder;

    private Joiner(String separator) {
        this.separator = separator;
        this.builder = new StringBuilder();
    }

    public <T> Joiner join(T[] elements, Function<T, ?> mapper) {
        return this.join((Iterable<T>)Arrays.asList(elements), mapper);
    }

    public <T> Joiner join(T[] elements, BiFunction<Integer, T, ?> mapper) {
        return this.join((Iterable<T>)Arrays.asList(elements), mapper);
    }

    public <T> Joiner join(Iterable<T> elements, Function<T, ?> mapper) {
        for (T element : elements) {
            this.append(mapper.apply(element));
        }
        return this;
    }

    public <T> Joiner join(Iterable<T> elements, BiFunction<Integer, T, ?> mapper) {
        int index = 0;
        for (T element : elements) {
            this.append(mapper.apply(index++, (Integer)element));
        }
        return this;
    }

    @SafeVarargs
    public final <T> Joiner join(T ... elements) {
        return this.join((Collection<?>)Arrays.asList(elements));
    }

    public Joiner join(Collection<?> elements) {
        for (Object element : elements) {
            this.append(element);
        }
        return this;
    }

    public Joiner append(Object element) {
        this.builder.append(element).append(this.separator);
        return this;
    }

    public String toString() {
        return this.builder.length() == 0 ? "" : this.builder.substring(0, this.builder.length() - this.separator.length());
    }

    public static Joiner on(String separator) {
        return new Joiner(separator);
    }
}

