/*
 * Decompiled with CFR 0.152.
 */
package panda.utilities.collection;

import java.util.Arrays;
import panda.utilities.collection.IStack;

public final class FixedStack<T>
implements IStack<T> {
    private final T[] stack;
    private int index;

    public FixedStack(int size) {
        this.stack = new Object[size];
    }

    @Override
    public void push(T element) {
        this.stack[this.index] = element;
        ++this.index;
    }

    @Override
    public T peek() {
        return this.stack[this.index - 1];
    }

    @Override
    public T pop() {
        T object = this.stack[this.index - 1];
        --this.index;
        return object;
    }

    @Override
    public int size() {
        return this.index;
    }

    @Override
    public boolean isEmpty() {
        return this.index == 0;
    }

    @Override
    public void clear() {
        this.index = 0;
    }

    @Override
    public final T[] toArray(Class<T[]> arrayType) {
        Object[] array = new Object[this.size()];
        int stackIndex = this.size() - 1;
        int arrayIndex = 0;
        while (stackIndex > -1) {
            array[arrayIndex] = this.stack[stackIndex];
            --stackIndex;
            ++arrayIndex;
        }
        return Arrays.copyOf(array, array.length, arrayType);
    }
}

