/*
 * Decompiled with CFR 0.152.
 */
package panda.utilities;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import panda.std.Result;

public final class IOUtils {
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    private IOUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result<String, IOException> fetchContent(String url) {
        Result<String, IOException> result;
        InputStream stream = null;
        try {
            URLConnection connection = IOUtils.createConnection(url);
            stream = connection.getInputStream();
            String encoding = connection.getContentEncoding();
            Charset charset = encoding == null ? StandardCharsets.UTF_8 : Charset.forName(encoding);
            result = IOUtils.convertStreamToString(stream, charset);
        }
        catch (IOException exception) {
            Result result2;
            try {
                result2 = Result.error((Object)exception);
            }
            catch (Throwable throwable) {
                IOUtils.close(stream);
                throw throwable;
            }
            IOUtils.close(stream);
            return result2;
        }
        IOUtils.close(stream);
        return result;
    }

    public static Result<InputStream, IOException> fetchContentAsStream(String url) {
        try {
            return Result.ok((Object)IOUtils.createConnection(url).getInputStream());
        }
        catch (IOException exception) {
            return Result.error((Object)exception);
        }
    }

    private static URLConnection createConnection(String url) throws IOException {
        URLConnection connection = new URL(url).openConnection();
        connection.setRequestProperty("User-Agent", "Mozilla/5.0");
        return connection;
    }

    public static InputStream convertStringToStream(String str) {
        return new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));
    }

    public static Result<String, IOException> convertStreamToString(InputStream inputStream) {
        return IOUtils.convertStreamToString(inputStream, StandardCharsets.UTF_8);
    }

    public static Result<String, IOException> convertStreamToString(InputStream inputStream, Charset encoding) {
        Result result;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int length;
            byte[] buffer = new byte[8192];
            while ((length = inputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, length);
            }
            result = Result.ok((Object)new String(byteArrayOutputStream.toByteArray(), encoding));
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                return Result.error((Object)exception);
            }
        }
        byteArrayOutputStream.close();
        return result;
    }

    public static void close(@Nullable Closeable closeable) {
        IOUtils.close(closeable, null);
    }

    public static void close(@Nullable Closeable closeable, @Nullable Consumer<IOException> exceptionConsumer) {
        block3: {
            if (closeable == null) {
                return;
            }
            try {
                closeable.close();
            }
            catch (IOException exception) {
                if (exceptionConsumer == null) break block3;
                exceptionConsumer.accept(exception);
            }
        }
    }
}

