/*
 * Decompiled with CFR 0.152.
 */
package panda.utilities.javassist;

import java.util.Arrays;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;

public final class ClassPoolUtils {
    private static final ClassPool CLASS_POOL = ClassPool.getDefault();
    private static final double VERSION = Double.parseDouble(System.getProperty("java.specification.version"));

    private ClassPoolUtils() {
    }

    public static CtClass[] toCt(Class<?> ... classes) {
        CtClass[] ctClasses = new CtClass[classes.length];
        for (int index = 0; index < classes.length; ++index) {
            ctClasses[index] = ClassPoolUtils.require(classes[index]);
        }
        return ctClasses;
    }

    public static Class<?> toClass(CtClass clazz, Class<?> domainClass) throws CannotCompileException {
        if (VERSION >= 11.0) {
            return clazz.toClass(domainClass);
        }
        return clazz.toClass();
    }

    public static CtClass require(Class<?> clazz) {
        try {
            return ClassPoolUtils.get(clazz);
        }
        catch (NotFoundException notFoundException) {
            throw new ClassPoolException("Cannot find class " + clazz);
        }
    }

    public static CtClass[] require(Class<?>[] classes) {
        return (CtClass[])Arrays.stream(classes).map(ClassPoolUtils::require).toArray(CtClass[]::new);
    }

    public static CtClass get(Class<?> clazz) throws NotFoundException {
        return CLASS_POOL.get(clazz.getName());
    }

    public static ClassPool getClassPool() {
        return CLASS_POOL;
    }

    static {
        CLASS_POOL.insertClassPath((ClassPath)new ClassClassPath(ClassPoolUtils.class));
    }

    public static class ClassPoolException
    extends RuntimeException {
        public ClassPoolException(String message) {
            super(message);
        }

        public ClassPoolException(Throwable cause) {
            super(cause);
        }
    }
}

