/*
 * Decompiled with CFR 0.152.
 */
package panda.utilities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Stack;

public final class StackUtils {
    private StackUtils() {
    }

    @SafeVarargs
    public static <T> Stack<T> push(Stack<T> stack, T ... values) {
        Arrays.stream(values).forEach(stack::push);
        return stack;
    }

    public static <T> Stack<T> popSilently(Stack<T> stack, int amount) {
        for (int i = 0; i < amount; ++i) {
            if (stack.isEmpty()) continue;
            stack.pop();
        }
        return stack;
    }

    public static <T> Stack<T> fill(Stack<T> stack, T object, int amount) {
        for (int i = 0; i < amount; ++i) {
            stack.push(object);
        }
        return stack;
    }

    public static <T> Stack<T> reverse(Stack<T> stack) {
        ArrayList<T> reversed = new ArrayList<T>(stack);
        Collections.reverse(reversed);
        stack.clear();
        for (Object element : reversed) {
            stack.push(element);
        }
        return stack;
    }

    public static <T> Stack<T> of(Collection<? extends T> collection) {
        Stack<? extends T> stack = new Stack<T>();
        stack.addAll(collection);
        return stack;
    }
}

