/*
 * Decompiled with CFR 0.152.
 */
package panda.utilities;

import org.jetbrains.annotations.Nullable;
import panda.utilities.StringUtils;

public final class PackageUtils {
    private PackageUtils() {
    }

    public static String getShortenPackage(Class<?> clazz) {
        return PackageUtils.getShortenPackage(clazz.getName());
    }

    public static String getShortenPackage(String pack) {
        int separator = StringUtils.lastIndexOfBefore(pack, ".", 1);
        String className = pack.substring(separator + 1);
        String packagePath = pack.substring(0, separator - 1);
        String[] packages = StringUtils.split(packagePath, ".");
        StringBuilder builder = new StringBuilder();
        for (String element : packages) {
            builder.append(element, 0, 1).append(".");
        }
        return builder.append(className).toString();
    }

    @Nullable
    public static String getPackageName(Class<?> clazz) {
        return clazz.getPackage() == null ? null : clazz.getPackage().getName();
    }

    public static String toString(@Nullable Package pack, @Nullable String defaultValue) {
        return pack != null ? pack.getName() : defaultValue;
    }

    @Nullable
    public static String toString(@Nullable Package pkg) {
        return PackageUtils.toString(pkg, null);
    }
}

