/*
 * Decompiled with CFR 0.152.
 */
package panda.utilities;

import java.lang.reflect.Array;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;
import panda.std.Option;
import panda.std.Pair;
import panda.std.function.ThrowingConsumer;

public final class ArrayUtils {
    private ArrayUtils() {
    }

    public static <T> void forEach(T[] array, Consumer<T> consumer) {
        for (T element : array) {
            consumer.accept(element);
        }
    }

    public static <T, E extends Exception> void forEachThrowing(T[] array, ThrowingConsumer<T, E> consumer) throws E {
        for (T element : array) {
            consumer.accept(element);
        }
    }

    @SafeVarargs
    public static <T> T[] merge(T[] ... arrays) {
        if (ArrayUtils.isEmpty(arrays)) {
            throw new IllegalArgumentException("Merge arrays requires at least one array as argument");
        }
        return ArrayUtils.merge(length -> (Object[])Array.newInstance(arrays[0].getClass().getComponentType(), (int)length), arrays);
    }

    @SafeVarargs
    public static <T> T[] merge(Function<Integer, T[]> arrayFunction, T[] ... arrays) {
        T[] merged = arrayFunction.apply(ArrayUtils.length(arrays));
        int index = 0;
        for (T[] array : arrays) {
            System.arraycopy(array, 0, merged, index, array.length);
            index += array.length;
        }
        return merged;
    }

    public static <T> T[] merge(T firstElement, T[] array, Function<Integer, T[]> arrayFunction) {
        T[] merged = arrayFunction.apply(array.length + 1);
        merged[0] = firstElement;
        System.arraycopy(array, 0, merged, 1, array.length);
        return merged;
    }

    public static <T> Option<T> findIn(T[] array, Predicate<T> condition) {
        for (T element : array) {
            if (!condition.test(element)) continue;
            return Option.of(element);
        }
        return Option.none();
    }

    public static boolean containsNull(Object[] array) {
        return ArrayUtils.contains(array, null);
    }

    public static boolean contains(Object[] array, Object element) {
        for (Object arrayElement : array) {
            if (!Objects.equals(arrayElement, element)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static <T> int length(T[] ... arrays) {
        int size = 0;
        for (T[] array : arrays) {
            size += array.length;
        }
        return size;
    }

    public static boolean isArray(@Nullable Object object) {
        return object != null && object.getClass().isArray();
    }

    public static boolean isEmpty(@Nullable Object[] array) {
        return array == null || array.length == 0;
    }

    public static Class<?> getDimensionalArrayType(Class<?> type, int dimensions) {
        if (dimensions == 0) {
            throw new IllegalArgumentException("Cannot get dimensional array for 0 dimensions");
        }
        if (dimensions == 1) {
            return type;
        }
        return Array.newInstance(type, new int[dimensions - 1]).getClass();
    }

    public static Class<?> getBaseClass(Class<?> arrayClass) {
        return (Class)ArrayUtils.getBaseClassWithDimensions(arrayClass).getFirst();
    }

    public static Pair<Class<?>, Integer> getBaseClassWithDimensions(Class<?> arrayClass) {
        Class<?> currentClass = arrayClass;
        int dimensions = 0;
        while (currentClass.isArray()) {
            currentClass = arrayClass.getComponentType();
            ++dimensions;
        }
        return new Pair(currentClass, (Object)dimensions);
    }

    public static Class<?> getArrayClass(Class<?> clazz) {
        return Array.newInstance(clazz, 0).getClass();
    }

    public static <T> int getIndex(T[] array, Predicate<T> condition) {
        for (int i = 0; i < array.length; ++i) {
            if (!condition.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static <T> int indexOf(T[] array, @Nullable T element) {
        for (int index = 0; index < array.length; ++index) {
            if (!Objects.equals(array[index], element)) continue;
            return index;
        }
        return -1;
    }

    public static <T> Option<T> getFirst(T[] array) {
        return ArrayUtils.get(array, 0);
    }

    public static <T> Option<T> getLast(T[] array) {
        return ArrayUtils.get(array, array.length - 1);
    }

    public static <T> Option<T> get(T[] array, int index) {
        return index > -1 && index < array.length ? Option.of(array[index]) : Option.none();
    }

    public static <T> T get(T[] array, int index, T defaultValue) {
        return index > -1 && index < array.length ? array[index] : defaultValue;
    }

    @SafeVarargs
    public static <T> T[] of(T ... elements) {
        return elements;
    }
}

