/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.springframework.component;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.pac4j.core.adapter.FrameworkAdapter;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.FrameworkParameters;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.context.JEEFrameworkParameters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.annotation.RequestScope;

@Configuration
public class ComponentConfig {
    @Autowired
    protected HttpServletRequest request;
    @Autowired
    protected HttpServletResponse response;
    @Autowired(required=false)
    protected Config config;

    @Bean
    @RequestScope
    public SessionStore getSessionStore() {
        FrameworkAdapter.INSTANCE.applyDefaultSettingsIfUndefined(this.config);
        return this.config.getSessionStoreFactory().newSessionStore((FrameworkParameters)new JEEFrameworkParameters(this.request, this.response));
    }

    @Bean
    @RequestScope
    public JEEContext getWebContext() {
        FrameworkAdapter.INSTANCE.applyDefaultSettingsIfUndefined(this.config);
        return new JEEContext(this.request, this.response);
    }

    @Bean
    @RequestScope
    public ProfileManager getProfileManager() {
        return (ProfileManager)this.config.getProfileManagerFactory().apply((Object)this.getWebContext(), (Object)this.getSessionStore());
    }
}

