/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.springframework.web;

import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.authorization.authorizer.Authorizer;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.JEEContextFactory;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.WebContextFactory;
import org.pac4j.core.context.session.JEESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.DefaultSecurityLogic;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.http.adapter.JEEHttpActionAdapter;
import org.pac4j.core.matching.matcher.Matcher;
import org.pac4j.core.util.FindBest;
import org.springframework.web.servlet.HandlerInterceptor;

public class SecurityInterceptor
implements HandlerInterceptor {
    private static final AtomicInteger internalNumber = new AtomicInteger(1);
    private SecurityLogic securityLogic;
    private String clients;
    private String authorizers;
    private String matchers;
    private Config config;
    private HttpActionAdapter httpActionAdapter;

    public SecurityInterceptor(Config config) {
        this.config = config;
    }

    public SecurityInterceptor(Config config, String clients) {
        this(config);
        this.clients = clients;
    }

    public SecurityInterceptor(Config config, String clients, HttpActionAdapter httpActionAdapter) {
        this.clients = clients;
        this.config = config;
        this.httpActionAdapter = httpActionAdapter;
    }

    public SecurityInterceptor(Config config, String clients, String authorizers) {
        this(config, clients);
        this.authorizers = authorizers;
    }

    public SecurityInterceptor(Config config, String clients, Authorizer[] authorizers) {
        this(config, clients);
        this.authorizers = SecurityInterceptor.addAuthorizers(config, authorizers);
    }

    public SecurityInterceptor(Config config, String clients, String authorizers, String matchers) {
        this(config, clients, authorizers);
        this.matchers = matchers;
    }

    public SecurityInterceptor(Config config, String clients, Authorizer[] authorizers, Matcher[] matchers) {
        this(config, clients, SecurityInterceptor.addAuthorizers(config, authorizers));
        this.matchers = SecurityInterceptor.addMatchers(config, matchers);
    }

    private static String addAuthorizers(Config config, Authorizer[] authorizers) {
        int n = internalNumber.getAndAdd(1);
        int nbAuthorizers = authorizers.length;
        StringBuilder names = new StringBuilder("");
        for (int i = 0; i < nbAuthorizers; ++i) {
            String name = "$int_authorizer" + n + "." + i;
            config.addAuthorizer(name, authorizers[i]);
            if (i > 0) {
                names.append(",");
            }
            names.append(name);
        }
        return names.toString();
    }

    private static String addMatchers(Config config, Matcher[] matchers) {
        int n = internalNumber.getAndAdd(1);
        int nbMatchers = matchers.length;
        StringBuilder names = new StringBuilder("");
        for (int i = 0; i < nbMatchers; ++i) {
            String name = "$int_matcher" + n + "." + i;
            config.addMatcher(name, matchers[i]);
            if (i > 0) {
                names.append(",");
            }
            names.append(name);
        }
        return names.toString();
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        SessionStore bestSessionStore = FindBest.sessionStore(null, (Config)this.config, (SessionStore)JEESessionStore.INSTANCE);
        HttpActionAdapter bestAdapter = FindBest.httpActionAdapter((HttpActionAdapter)this.httpActionAdapter, (Config)this.config, (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE);
        SecurityLogic bestLogic = FindBest.securityLogic((SecurityLogic)this.securityLogic, (Config)this.config, (SecurityLogic)DefaultSecurityLogic.INSTANCE);
        JEEContext context = (JEEContext)FindBest.webContextFactory(null, (Config)this.config, (WebContextFactory)JEEContextFactory.INSTANCE).newContext(new Object[]{request, response});
        Object result = bestLogic.perform((WebContext)context, bestSessionStore, this.config, (ctx, session, profiles, parameters) -> true, bestAdapter, this.clients, this.authorizers, this.matchers, new Object[0]);
        if (result == null) {
            return false;
        }
        return Boolean.parseBoolean(result.toString());
    }

    public SecurityLogic getSecurityLogic() {
        return this.securityLogic;
    }

    public void setSecurityLogic(SecurityLogic securityLogic) {
        this.securityLogic = securityLogic;
    }

    public String getClients() {
        return this.clients;
    }

    public void setClients(String clients) {
        this.clients = clients;
    }

    public String getAuthorizers() {
        return this.authorizers;
    }

    public void setAuthorizers(String authorizers) {
        this.authorizers = authorizers;
    }

    public String getMatchers() {
        return this.matchers;
    }

    public void setMatchers(String matchers) {
        this.matchers = matchers;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public HttpActionAdapter getHttpActionAdapter() {
        return this.httpActionAdapter;
    }

    public void setHttpActionAdapter(HttpActionAdapter httpActionAdapter) {
        this.httpActionAdapter = httpActionAdapter;
    }
}

