/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.metadata.keystore;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDateTime;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.V3TBSCertificateGenerator;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.metadata.keystore.SAML2KeystoreGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSAML2KeystoreGenerator
implements SAML2KeystoreGenerator {
    protected static final String CERTIFICATES_PREFIX = "saml-signing-cert";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final SAML2Configuration saml2Configuration;

    public BaseSAML2KeystoreGenerator(SAML2Configuration saml2Configuration) {
        this.saml2Configuration = saml2Configuration;
    }

    @Override
    public boolean shouldGenerate() {
        return this.saml2Configuration.isForceKeystoreGeneration();
    }

    @Override
    public void generate() {
        try {
            if (CommonHelper.isBlank((String)this.saml2Configuration.getKeyStoreAlias())) {
                this.saml2Configuration.setKeyStoreAlias(this.getClass().getSimpleName());
                this.logger.warn("Defaulting keystore alias {}", (Object)this.saml2Configuration.getKeyStoreAlias());
            }
            if (CommonHelper.isBlank((String)this.saml2Configuration.getKeyStoreType())) {
                this.saml2Configuration.setKeyStoreType(KeyStore.getDefaultType());
                this.logger.warn("Defaulting keystore type {}", (Object)this.saml2Configuration.getKeyStoreType());
            }
            this.validate();
            KeyStore ks = KeyStore.getInstance(this.saml2Configuration.getKeyStoreType());
            char[] password = this.saml2Configuration.getKeystorePassword().toCharArray();
            ks.load(null, password);
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            kpg.initialize(this.saml2Configuration.getPrivateKeySize());
            KeyPair kp = kpg.genKeyPair();
            String sigAlg = this.saml2Configuration.getCertificateSignatureAlg();
            AlgorithmIdentifier sigAlgID = new DefaultSignatureAlgorithmIdentifierFinder().find(sigAlg);
            String dn = InetAddress.getLocalHost().getHostName();
            X509Certificate certificate = this.createSelfSignedCert(new X500Name("CN=" + dn), sigAlg, sigAlgID, kp);
            char[] keyPassword = this.saml2Configuration.getPrivateKeyPassword().toCharArray();
            PrivateKey signingKey = kp.getPrivate();
            ks.setKeyEntry(this.saml2Configuration.getKeyStoreAlias(), signingKey, keyPassword, new Certificate[]{certificate});
            this.store(ks, certificate, signingKey);
            this.logger.info("Created keystore {} with key alias {}", (Object)this.saml2Configuration.getKeystoreResource(), (Object)ks.aliases().nextElement());
        }
        catch (Exception e) {
            throw new SAMLException("Could not create keystore", e);
        }
    }

    protected abstract void store(KeyStore var1, X509Certificate var2, PrivateKey var3) throws Exception;

    private static Time time(ChronoLocalDateTime<LocalDate> localDateTime) {
        return new Time(Date.from(localDateTime.toInstant(ZoneOffset.UTC)));
    }

    private X509Certificate createSelfSignedCert(X500Name dn, String sigName, AlgorithmIdentifier sigAlgID, KeyPair keyPair) throws Exception {
        V3TBSCertificateGenerator certGen = new V3TBSCertificateGenerator();
        certGen.setSerialNumber(new ASN1Integer(BigInteger.valueOf(1L)));
        certGen.setIssuer(dn);
        certGen.setSubject(dn);
        LocalDateTime startDate = LocalDateTime.now(Clock.systemUTC()).minusSeconds(1L);
        certGen.setStartDate(BaseSAML2KeystoreGenerator.time(startDate));
        LocalDateTime endDate = startDate.plus(this.saml2Configuration.getCertificateExpirationPeriod());
        certGen.setEndDate(BaseSAML2KeystoreGenerator.time(endDate));
        certGen.setSignature(sigAlgID);
        certGen.setSubjectPublicKeyInfo(SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded()));
        Signature sig = Signature.getInstance(sigName);
        sig.initSign(keyPair.getPrivate());
        sig.update(certGen.generateTBSCertificate().getEncoded("DER"));
        TBSCertificate tbsCert = certGen.generateTBSCertificate();
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)tbsCert);
        v.add((ASN1Encodable)sigAlgID);
        v.add((ASN1Encodable)new DERBitString(sig.sign()));
        X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(new DERSequence(v).getEncoded("DER")));
        cert.verify(keyPair.getPublic());
        return cert;
    }

    private void validate() {
        CommonHelper.assertNotBlank((String)"keystoreAlias", (String)this.saml2Configuration.getKeyStoreAlias());
        CommonHelper.assertNotBlank((String)"keystoreType", (String)this.saml2Configuration.getKeyStoreType());
        CommonHelper.assertNotBlank((String)"privateKeyPassword", (String)this.saml2Configuration.getPrivateKeyPassword());
    }
}

