/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.transport;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.pac4j.core.context.WebContext;
import org.pac4j.saml.transport.Pac4jSAMLResponse;

public class DefaultPac4jSAMLResponse
implements Pac4jSAMLResponse {
    private final ByteArrayOutputStream outputStream;
    private final OutputStreamWriter outputStreamWriter;
    private final WebContext webContext;
    private String redirectUrl;

    public DefaultPac4jSAMLResponse(WebContext response) {
        this.webContext = response;
        this.outputStream = new ByteArrayOutputStream();
        this.outputStreamWriter = new Pac4jServletOutputStreamWriter(this.outputStream);
    }

    @Override
    public final String getOutgoingContent() {
        return this.outputStreamWriter.toString();
    }

    @Override
    public void init() {
        this.setNoCacheHeaders();
    }

    public void setNoCacheHeaders() {
        this.webContext.setResponseHeader("Cache-control", "no-cache, no-store");
        this.webContext.setResponseHeader("Pragma", "no-cache");
    }

    @Override
    public void setContentType(String type) {
        this.webContext.setResponseContentType(type + ";charset=" + String.valueOf(StandardCharsets.UTF_8));
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OutputStreamWriter getOutputStreamWriter() {
        return this.outputStreamWriter;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public WebContext getWebContext() {
        return this.webContext;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    private static class Pac4jServletOutputStreamWriter
    extends OutputStreamWriter {
        private final ByteArrayOutputStream outputStream;

        public Pac4jServletOutputStreamWriter(ByteArrayOutputStream out) {
            super((OutputStream)out, StandardCharsets.UTF_8);
            this.outputStream = out;
        }

        public final String getOutgoingContent() {
            try {
                String result = new String(this.outputStream.toByteArray(), StandardCharsets.UTF_8);
                return result;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return this.getOutgoingContent();
        }
    }
}

