/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.crypto;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.trust.TrustedCredentialTrustEngine;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.pac4j.saml.crypto.SAML2SignatureTrustEngineProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogOnlySignatureTrustEngineProvider
implements SAML2SignatureTrustEngineProvider {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LogOnlySignatureTrustEngineProvider.class);
    private final SAML2SignatureTrustEngineProvider wrapped;

    public LogOnlySignatureTrustEngineProvider(SAML2SignatureTrustEngineProvider wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public SignatureTrustEngine build() {
        return new LogOnlySignatureTrustEngine(this.wrapped.build());
    }

    private static class LogOnlySignatureTrustEngine
    implements TrustedCredentialTrustEngine<Signature>,
    SignatureTrustEngine {
        private final SignatureTrustEngine wrapped;

        public LogOnlySignatureTrustEngine(SignatureTrustEngine wrapped) {
            LOGGER.error("SIGNATURE VALIDATION DISABLED, DO NOT USE THIS ON PRODUCTION");
            this.wrapped = wrapped;
        }

        public CredentialResolver getCredentialResolver() {
            return ((TrustedCredentialTrustEngine)this.wrapped).getCredentialResolver();
        }

        public KeyInfoCredentialResolver getKeyInfoResolver() {
            return this.wrapped.getKeyInfoResolver();
        }

        public boolean validate(Signature token, CriteriaSet trustBasisCriteria) throws SecurityException {
            try {
                if (!this.wrapped.validate((Object)token, trustBasisCriteria)) {
                    LOGGER.error("Signature validation failed, continuing anyway. Criteria: " + String.valueOf(trustBasisCriteria));
                }
            }
            catch (SecurityException e) {
                LOGGER.error("Signature validation failed, continuing anyway. Criteria: " + String.valueOf(trustBasisCriteria) + ", cause: " + e.getMessage(), (Throwable)e);
            }
            return true;
        }

        public boolean validate(byte[] signature, byte[] content, String algorithmURI, CriteriaSet trustBasisCriteria, Credential candidateCredential) throws SecurityException {
            try {
                if (!this.wrapped.validate(signature, content, algorithmURI, trustBasisCriteria, candidateCredential)) {
                    LOGGER.error("Signature validation failed, continuing anyway. Criteria: " + String.valueOf(trustBasisCriteria));
                }
            }
            catch (SecurityException e) {
                LOGGER.error("Signature validation failed, continuing anyway. Criteria: " + String.valueOf(trustBasisCriteria) + ", cause: " + e.getMessage(), (Throwable)e);
            }
            return true;
        }
    }
}

