/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.context;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLSubjectNameIdentifierContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.BaseID;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.context.SAML2ConfigurationContext;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.store.SAMLMessageStore;
import org.pac4j.saml.transport.Pac4jSAMLResponse;

public class SAML2MessageContext {
    private final List<SubjectConfirmation> subjectConfirmations = new ArrayList<SubjectConfirmation>();
    private MessageContext messageContext = new MessageContext();
    private SAML2Configuration saml2Configuration;
    private final CallContext callContext;
    private Assertion subjectAssertion;
    private BaseID baseID;
    private SAMLMessageStore samlMessageStore;

    public SAML2MessageContext(CallContext callContext) {
        this.callContext = callContext;
    }

    public SAML2ConfigurationContext getConfigurationContext() {
        WebContext webContext = this.callContext.webContext();
        CommonHelper.assertNotNull((String)"webContext", (Object)webContext);
        CommonHelper.assertNotNull((String)"saml2Configuration", (Object)((Object)this.saml2Configuration));
        return new SAML2ConfigurationContext(webContext, this.saml2Configuration);
    }

    public final SPSSODescriptor getSPSSODescriptor() {
        SAMLMetadataContext selfContext = this.getSAMLSelfMetadataContext();
        SPSSODescriptor spDescriptor = (SPSSODescriptor)selfContext.getRoleDescriptor();
        return spDescriptor;
    }

    public final IDPSSODescriptor getIDPSSODescriptor() {
        SAMLMetadataContext peerContext = this.getSAMLPeerMetadataContext();
        IDPSSODescriptor idpssoDescriptor = (IDPSSODescriptor)peerContext.getRoleDescriptor();
        return idpssoDescriptor;
    }

    public final SingleLogoutService getIDPSingleLogoutService(String binding) {
        List services = this.getIDPSSODescriptor().getSingleLogoutServices();
        for (SingleLogoutService service : services) {
            if (!service.getBinding().equals(binding)) continue;
            return service;
        }
        throw new SAMLException("Identity provider has no single logout service available for the selected profile " + binding);
    }

    public SingleSignOnService getIDPSingleSignOnService(String binding) {
        List services = this.getIDPSSODescriptor().getSingleSignOnServices();
        for (SingleSignOnService service : services) {
            if (!service.getBinding().equals(binding)) continue;
            return service;
        }
        throw new SAMLException("Identity provider has no single sign on service available for the selected profile " + binding);
    }

    public AssertionConsumerService getSPAssertionConsumerService() {
        SPSSODescriptor spssoDescriptor = this.getSPSSODescriptor();
        return this.getSPAssertionConsumerService(spssoDescriptor, spssoDescriptor.getAssertionConsumerServices());
    }

    public AssertionConsumerService getSPAssertionConsumerService(StatusResponseType response) {
        SPSSODescriptor spssoDescriptor = this.getSPSSODescriptor();
        List services = spssoDescriptor.getAssertionConsumerServices();
        if (response != null && StringUtils.isNotEmpty((CharSequence)response.getDestination())) {
            for (AssertionConsumerService service : services) {
                if (!response.getDestination().equals(service.getLocation())) continue;
                return service;
            }
            throw new SAMLException("Assertion consumer service with destination " + response.getDestination() + " could not be found for spDescriptor " + String.valueOf(spssoDescriptor));
        }
        return this.getSPAssertionConsumerService(spssoDescriptor, services);
    }

    public AssertionConsumerService getSPAssertionConsumerService(String acsIndex) {
        SPSSODescriptor spssoDescriptor = this.getSPSSODescriptor();
        List services = spssoDescriptor.getAssertionConsumerServices();
        if (acsIndex != null) {
            for (AssertionConsumerService service : services) {
                if (!Integer.valueOf(acsIndex).equals(service.getIndex())) continue;
                return service;
            }
            throw new SAMLException("Assertion consumer service with index " + acsIndex + " could not be found for spDescriptor " + String.valueOf(spssoDescriptor));
        }
        return this.getSPAssertionConsumerService(spssoDescriptor, services);
    }

    protected AssertionConsumerService getSPAssertionConsumerService(SPSSODescriptor spssoDescriptor, Collection<AssertionConsumerService> services) {
        if (spssoDescriptor.getDefaultAssertionConsumerService() != null) {
            return spssoDescriptor.getDefaultAssertionConsumerService();
        }
        if (!services.isEmpty()) {
            return services.iterator().next();
        }
        throw new SAMLException("No assertion consumer services could be found for " + String.valueOf(spssoDescriptor));
    }

    public final ProfileRequestContext getProfileRequestContext() {
        return (ProfileRequestContext)this.getMessageContext().getSubcontext(ProfileRequestContext.class, true);
    }

    public final SAMLSelfEntityContext getSAMLSelfEntityContext() {
        return (SAMLSelfEntityContext)this.getMessageContext().getSubcontext(SAMLSelfEntityContext.class, true);
    }

    public final SOAP11Context getSOAP11Context() {
        return (SOAP11Context)this.getMessageContext().getSubcontext(SOAP11Context.class, true);
    }

    public final SAMLMetadataContext getSAMLSelfMetadataContext() {
        return (SAMLMetadataContext)this.getSAMLSelfEntityContext().getSubcontext(SAMLMetadataContext.class, true);
    }

    public final SAMLMetadataContext getSAMLPeerMetadataContext() {
        return (SAMLMetadataContext)this.getSAMLPeerEntityContext().getSubcontext(SAMLMetadataContext.class, true);
    }

    public final SAMLPeerEntityContext getSAMLPeerEntityContext() {
        return (SAMLPeerEntityContext)this.getMessageContext().getSubcontext(SAMLPeerEntityContext.class, true);
    }

    public final SAMLSubjectNameIdentifierContext getSAMLSubjectNameIdentifierContext() {
        return (SAMLSubjectNameIdentifierContext)this.getMessageContext().getSubcontext(SAMLSubjectNameIdentifierContext.class, true);
    }

    public final SAMLEndpointContext getSAMLPeerEndpointContext() {
        return (SAMLEndpointContext)this.getSAMLPeerEntityContext().getSubcontext(SAMLEndpointContext.class, true);
    }

    public final SAMLEndpointContext getSAMLSelfEndpointContext() {
        return (SAMLEndpointContext)this.getSAMLSelfEntityContext().getSubcontext(SAMLEndpointContext.class, true);
    }

    public final SAMLBindingContext getSAMLBindingContext() {
        return (SAMLBindingContext)this.getMessageContext().getSubcontext(SAMLBindingContext.class, true);
    }

    public final SecurityParametersContext getSecurityParametersContext() {
        return (SecurityParametersContext)this.getMessageContext().getSubcontext(SecurityParametersContext.class, true);
    }

    public final SAMLProtocolContext getSAMLSelfProtocolContext() {
        return (SAMLProtocolContext)this.getSAMLSelfEntityContext().getSubcontext(SAMLProtocolContext.class, true);
    }

    public final SAMLProtocolContext getSAMLProtocolContext() {
        return (SAMLProtocolContext)this.getMessageContext().getSubcontext(SAMLProtocolContext.class, true);
    }

    public final Pac4jSAMLResponse getProfileRequestContextOutboundMessageTransportResponse() {
        return (Pac4jSAMLResponse)this.getProfileRequestContext().getOutboundMessageContext().getMessage();
    }

    public final SAMLEndpointContext getSAMLEndpointContext() {
        return (SAMLEndpointContext)this.getMessageContext().getSubcontext(SAMLEndpointContext.class, true);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<SubjectConfirmation> getSubjectConfirmations() {
        return this.subjectConfirmations;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MessageContext getMessageContext() {
        return this.messageContext;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration getSaml2Configuration() {
        return this.saml2Configuration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CallContext getCallContext() {
        return this.callContext;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Assertion getSubjectAssertion() {
        return this.subjectAssertion;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BaseID getBaseID() {
        return this.baseID;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAMLMessageStore getSamlMessageStore() {
        return this.samlMessageStore;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setMessageContext(MessageContext messageContext) {
        this.messageContext = messageContext;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setSaml2Configuration(SAML2Configuration saml2Configuration) {
        this.saml2Configuration = saml2Configuration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setSubjectAssertion(Assertion subjectAssertion) {
        this.subjectAssertion = subjectAssertion;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setBaseID(BaseID baseID) {
        this.baseID = baseID;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setSamlMessageStore(SAMLMessageStore samlMessageStore) {
        this.samlMessageStore = samlMessageStore;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "SAML2MessageContext(subjectConfirmations=" + String.valueOf(this.subjectConfirmations) + ", messageContext=" + String.valueOf(this.messageContext) + ", saml2Configuration=" + String.valueOf((Object)this.saml2Configuration) + ", callContext=" + String.valueOf(this.callContext) + ", subjectAssertion=" + String.valueOf(this.subjectAssertion) + ", baseID=" + String.valueOf(this.baseID) + ", samlMessageStore=" + String.valueOf(this.samlMessageStore) + ")";
    }
}

