/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.metadata;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import lombok.Generated;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.metadata.BaseSAML2MetadataGenerator;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;

public class SAML2FileSystemMetadataGenerator
extends BaseSAML2MetadataGenerator {
    private final Resource metadataResource;

    @Override
    protected AbstractMetadataResolver createMetadataResolver() throws Exception {
        return new FilesystemMetadataResolver(this.metadataResource.getFile());
    }

    @Override
    public boolean storeMetadata(String metadata, boolean force) throws Exception {
        if (this.metadataResource == null || CommonHelper.isBlank((String)metadata)) {
            this.logger.info("No metadata or resource is provided");
            return false;
        }
        if (!(this.metadataResource instanceof WritableResource)) {
            this.logger.warn("Unable to store metadata, as resource is not writable");
            return false;
        }
        if (this.metadataResource.exists() && !force) {
            this.logger.info("Metadata file already exists at {}.", (Object)this.metadataResource.getFile());
        } else {
            this.logger.info("Writing metadata to {}", (Object)this.metadataResource.getFilename());
            File parent = this.metadataResource.getFile().getParentFile();
            if (parent != null) {
                this.logger.debug("Attempting to create directory structure for: {}", (Object)parent.getCanonicalPath());
                if (!parent.exists() && !parent.mkdirs()) {
                    this.logger.warn("Could not construct the directory structure for metadata: {}", (Object)parent.getCanonicalPath());
                }
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            StreamResult result = new StreamResult(new StringWriter());
            StreamSource source = new StreamSource(new StringReader(metadata));
            transformer.transform(source, result);
            WritableResource destination = (WritableResource)WritableResource.class.cast(this.metadataResource);
            try (OutputStream spMetadataOutputStream = destination.getOutputStream();){
                spMetadataOutputStream.write(result.getWriter().toString().getBytes(StandardCharsets.UTF_8));
            }
            if (destination.exists()) {
                if (this.isSignMetadata()) {
                    this.getMetadataSigner().sign(this.metadataResource.getFile());
                }
                return true;
            }
        }
        return false;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2FileSystemMetadataGenerator(Resource metadataResource) {
        this.metadataResource = metadataResource;
    }
}

