/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.transport;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import lombok.Generated;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.net.URLBuilder;
import net.shibboleth.shared.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.AbstractMessageEncoder;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.binding.BindingException;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.SAMLMessageSecuritySupport;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.crypto.XMLSigningUtil;
import org.pac4j.saml.transport.Pac4jSAMLResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Pac4jHTTPRedirectDeflateEncoder
extends AbstractMessageEncoder {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Pac4jHTTPRedirectDeflateEncoder.class);
    private final Pac4jSAMLResponse responseAdapter;
    private final boolean isAuthnRequestSigned;

    public Pac4jHTTPRedirectDeflateEncoder(Pac4jSAMLResponse responseAdapter, boolean isAuthnRequestSigned) {
        this.responseAdapter = responseAdapter;
        this.isAuthnRequestSigned = isAuthnRequestSigned;
    }

    protected void doEncode() throws MessageEncodingException {
        MessageContext messageContext = this.getMessageContext();
        SAMLObject outboundMessage = (SAMLObject)messageContext.getMessage();
        String endpointURL = this.getEndpointURL(messageContext).toString();
        this.removeSignature(outboundMessage);
        String encodedMessage = this.deflateAndBase64Encode(outboundMessage);
        String redirectURL = this.buildRedirectURL(messageContext, endpointURL, encodedMessage);
        this.responseAdapter.init();
        this.responseAdapter.setRedirectUrl(redirectURL);
    }

    protected void doInitialize() throws ComponentInitializationException {
        LOGGER.debug("Initialized {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
    }

    protected URI getEndpointURL(MessageContext messageContext) throws MessageEncodingException {
        try {
            return SAMLBindingSupport.getEndpointURL((MessageContext)messageContext);
        }
        catch (BindingException e) {
            throw new MessageEncodingException("Could not obtain message endpoint URL", (Exception)((Object)e));
        }
    }

    protected void removeSignature(SAMLObject message) {
        SignableSAMLObject signableMessage;
        if (message instanceof SignableSAMLObject && (signableMessage = (SignableSAMLObject)message).isSigned()) {
            LOGGER.debug("Removing SAML protocol message signature");
            signableMessage.setSignature(null);
        }
    }

    String deflateAndBase64Encode(SAMLObject message) throws MessageEncodingException {
        LOGGER.debug("Deflating and Base64 encoding SAML message");
        try {
            String messageStr = SerializeSupport.nodeToString((Node)this.marshallMessage((XMLObject)message));
            LOGGER.trace("Output XML message: {}", (Object)messageStr);
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            Deflater deflater = new Deflater(8, true);
            DeflaterOutputStream deflaterStream = new DeflaterOutputStream((OutputStream)bytesOut, deflater);
            deflaterStream.write(messageStr.getBytes(StandardCharsets.UTF_8));
            deflaterStream.finish();
            return Base64Support.encode((byte[])bytesOut.toByteArray(), (boolean)false);
        }
        catch (Exception e) {
            throw new MessageEncodingException("Unable to DEFLATE and Base64 encode SAML message", e);
        }
    }

    protected Element marshallMessage(XMLObject message) throws MessageEncodingException {
        LOGGER.debug("Marshalling message");
        try {
            return XMLObjectSupport.marshall((XMLObject)message);
        }
        catch (MarshallingException e) {
            throw new MessageEncodingException("Error marshalling message", (Exception)((Object)e));
        }
    }

    protected String buildRedirectURL(MessageContext messageContext, String endpoint, String message) throws MessageEncodingException {
        URLBuilder urlBuilder;
        LOGGER.debug("Building URL to redirect client to");
        try {
            urlBuilder = new URLBuilder(endpoint);
        }
        catch (MalformedURLException e) {
            throw new MessageEncodingException("Endpoint URL " + endpoint + " is not a valid URL", (Exception)e);
        }
        List queryParams = urlBuilder.getQueryParams();
        queryParams.removeIf(p -> ((String)p.getFirst()).equals("SAMLRequest") || ((String)p.getFirst()).equals("SAMLResponse") || ((String)p.getFirst()).equals("RelayState") || ((String)p.getFirst()).equals("SigAlg") || ((String)p.getFirst()).equals("Signature"));
        SAMLObject outboundMessage = (SAMLObject)messageContext.getMessage();
        if (outboundMessage instanceof RequestAbstractType) {
            queryParams.add(new Pair((Object)"SAMLRequest", (Object)message));
        } else if (outboundMessage instanceof StatusResponseType) {
            queryParams.add(new Pair((Object)"SAMLResponse", (Object)message));
        } else {
            throw new MessageEncodingException("SAML message is neither a SAML RequestAbstractType or StatusResponseType");
        }
        String relayState = SAMLBindingSupport.getRelayState((MessageContext)messageContext);
        if (SAMLBindingSupport.checkRelayState((String)relayState)) {
            queryParams.add(new Pair((Object)"RelayState", (Object)relayState));
        }
        if (this.isAuthnRequestSigned) {
            SignatureSigningParameters signingParameters = SAMLMessageSecuritySupport.getContextSigningParameters((MessageContext)messageContext);
            if (signingParameters != null && signingParameters.getSigningCredential() != null) {
                String sigAlgURI = this.getSignatureAlgorithmURI(signingParameters);
                Pair sigAlg = new Pair((Object)"SigAlg", (Object)sigAlgURI);
                queryParams.add(sigAlg);
                String sigMaterial = urlBuilder.buildQueryString();
                queryParams.add(new Pair((Object)"Signature", (Object)this.generateSignature(signingParameters.getSigningCredential(), sigAlgURI, sigMaterial)));
            } else {
                LOGGER.debug("No signing credential was supplied, skipping HTTP-Redirect DEFLATE signing");
            }
        }
        return urlBuilder.buildURL();
    }

    protected String getSignatureAlgorithmURI(SignatureSigningParameters signingParameters) throws MessageEncodingException {
        if (signingParameters.getSignatureAlgorithm() != null) {
            return signingParameters.getSignatureAlgorithm();
        }
        throw new MessageEncodingException("The signing algorithm URI could not be determined");
    }

    protected String generateSignature(Credential signingCredential, String algorithmURI, String queryString) throws MessageEncodingException {
        String b64Signature;
        LOGGER.debug(String.format("Generating signature with key type '%s', algorithm URI '%s' over query string '%s'", CredentialSupport.extractSigningKey((Credential)signingCredential).getAlgorithm(), algorithmURI, queryString));
        try {
            byte[] rawSignature = XMLSigningUtil.signWithURI((Credential)signingCredential, (String)algorithmURI, (byte[])queryString.getBytes(StandardCharsets.UTF_8));
            b64Signature = Base64Support.encode((byte[])rawSignature, (boolean)false);
            LOGGER.debug("Generated digital signature value (base64-encoded) {}", (Object)b64Signature);
        }
        catch (Exception e) {
            throw new MessageEncodingException("Unable to sign URL query string", e);
        }
        return b64Signature;
    }
}

