/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.config;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URL;
import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import lombok.Generated;
import net.shibboleth.shared.net.URIComparator;
import net.shibboleth.shared.net.impl.BasicURLComparator;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.HttpClient;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.impl.BasicSignatureSigningConfiguration;
import org.pac4j.core.client.config.BaseClientConfiguration;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.logout.handler.DefaultSessionLogoutHandler;
import org.pac4j.core.logout.handler.SessionLogoutHandler;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.resource.SpringResourceHelper;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.crypto.CredentialProvider;
import org.pac4j.saml.crypto.KeyStoreCredentialProvider;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.metadata.BaseSAML2MetadataGenerator;
import org.pac4j.saml.metadata.SAML2FileSystemMetadataGenerator;
import org.pac4j.saml.metadata.SAML2HttpUrlMetadataGenerator;
import org.pac4j.saml.metadata.SAML2IdentityProviderMetadataResolver;
import org.pac4j.saml.metadata.SAML2MetadataContactPerson;
import org.pac4j.saml.metadata.SAML2MetadataGenerator;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.pac4j.saml.metadata.SAML2MetadataSigner;
import org.pac4j.saml.metadata.SAML2MetadataUIInfo;
import org.pac4j.saml.metadata.SAML2ServiceProviderRequestedAttribute;
import org.pac4j.saml.metadata.keystore.SAML2FileSystemKeystoreGenerator;
import org.pac4j.saml.metadata.keystore.SAML2HttpUrlKeystoreGenerator;
import org.pac4j.saml.metadata.keystore.SAML2KeystoreGenerator;
import org.pac4j.saml.profile.converter.SimpleSAML2AttributeConverter;
import org.pac4j.saml.sso.impl.SAML2ScopingIdentityProvider;
import org.pac4j.saml.store.EmptyStoreFactory;
import org.pac4j.saml.store.SAMLMessageStoreFactory;
import org.pac4j.saml.util.SAML2HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class SAML2Configuration
extends BaseClientConfiguration {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SAML2Configuration.class);
    protected static final String DEFAULT_PROVIDER_NAME = "pac4j-saml";
    private final List<SAML2ScopingIdentityProvider> scopingIdentityProviders = new ArrayList<SAML2ScopingIdentityProvider>();
    private final List<SAML2ServiceProviderRequestedAttribute> requestedServiceProviderAttributes = new ArrayList<SAML2ServiceProviderRequestedAttribute>();
    private HostnameVerifier hostnameVerifier;
    private SSLSocketFactory sslSocketFactory;
    private SAML2MetadataSigner metadataSigner;
    private String singleSignOutServiceUrl;
    private String nameIdAttribute;
    private String callbackUrl;
    private String requestInitiatorUrl;
    private String assertionConsumerServiceUrl;
    private Resource keystoreResource;
    private String keystorePassword;
    private String privateKeyPassword;
    private String certificateNameToAppend;
    private Resource identityProviderMetadataResource;
    private String identityProviderEntityId;
    private String serviceProviderEntityId;
    private long maximumAuthenticationLifetime = 3600L;
    private long acceptedSkew = 300L;
    private boolean forceAuth = false;
    private boolean passive = false;
    private String comparisonType = null;
    private boolean isPartialLogoutTreatedAsSuccess = true;
    private String authnRequestBindingType = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    private String responseBindingType = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    private String spLogoutRequestBindingType = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    private String spLogoutResponseBindingType = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    private List<String> authnContextClassRefs = new ArrayList<String>();
    private String nameIdPolicyFormat = null;
    private boolean useNameQualifier = false;
    private boolean signMetadata;
    private Resource serviceProviderMetadataResource;
    private boolean forceServiceProviderMetadataGeneration;
    private boolean forceKeystoreGeneration;
    private SAMLMessageStoreFactory samlMessageStoreFactory = new EmptyStoreFactory();
    private SAML2KeystoreGenerator keystoreGenerator;
    private SAML2MetadataGenerator metadataGenerator;
    private boolean authnRequestSigned;
    private boolean spLogoutRequestSigned;
    private Collection<String> blackListedSignatureSigningAlgorithms;
    private List<String> signatureAlgorithms;
    private List<String> signatureReferenceDigestMethods;
    private String signatureCanonicalizationAlgorithm;
    private boolean wantsAssertionsSigned = false;
    private boolean wantsResponsesSigned = false;
    private boolean allSignatureValidationDisabled = false;
    private boolean responseDestinationAttributeMandatory = true;
    private String keyStoreAlias;
    private String keyStoreType;
    private int assertionConsumerServiceIndex = -1;
    private int attributeConsumingServiceIndex = -1;
    private String providerName;
    private Supplier<List<XSAny>> authnRequestExtensions;
    private String attributeAsId;
    private Map<String, String> mappedAttributes = new LinkedHashMap<String, String>();
    private URIComparator uriComparator = new BasicURLComparator();
    private SessionLogoutHandler sessionLogoutHandler;
    private String postLogoutURL;
    private Period certificateExpirationPeriod = Period.ofYears(20);
    private String certificateSignatureAlg = "SHA1WithRSA";
    private int privateKeySize = 2048;
    private List<SAML2MetadataContactPerson> contactPersons = new ArrayList<SAML2MetadataContactPerson>();
    private List<SAML2MetadataUIInfo> metadataUIInfos = new ArrayList<SAML2MetadataUIInfo>();
    private String issuerFormat = "urn:oasis:names:tc:SAML:2.0:nameid-format:entity";
    private HttpClient httpClient;
    private AttributeConverter samlAttributeConverter = new SimpleSAML2AttributeConverter();
    private Boolean nameIdPolicyAllowCreate = Boolean.TRUE;
    private List<String> supportedProtocols = new ArrayList<String>(Arrays.asList("urn:oasis:names:tc:SAML:2.0:protocol", "urn:oasis:names:tc:SAML:1.0:protocol", "urn:oasis:names:tc:SAML:1.1:protocol"));
    private SAML2MetadataResolver identityProviderMetadataResolver;
    private int identityProviderMetadataConnectTimeout = 2500;
    private int identityProviderMetadataReadTimeout = 2500;

    public SAML2Configuration(String keystorePath, String keystorePassword, String privateKeyPassword, String identityProviderMetadataPath) {
        this(null, null, SpringResourceHelper.buildResourceFromPath((String)keystorePath), keystorePassword, privateKeyPassword, SpringResourceHelper.buildResourceFromPath((String)identityProviderMetadataPath), null, null, DEFAULT_PROVIDER_NAME, null, null);
    }

    public SAML2Configuration(Resource keystoreResource, String keystorePassword, String privateKeyPassword, Resource identityProviderMetadataResource) {
        this(null, null, keystoreResource, keystorePassword, privateKeyPassword, identityProviderMetadataResource, null, null, DEFAULT_PROVIDER_NAME, null, null);
    }

    public SAML2Configuration(Resource keystoreResource, String keyStoreAlias, String keyStoreType, String keystorePassword, String privateKeyPassword, Resource identityProviderMetadataResource) {
        this(keyStoreAlias, keyStoreType, keystoreResource, keystorePassword, privateKeyPassword, identityProviderMetadataResource, null, null, DEFAULT_PROVIDER_NAME, null, null);
    }

    protected SAML2Configuration(String keyStoreAlias, String keyStoreType, Resource keystoreResource, String keystorePassword, String privateKeyPassword, Resource identityProviderMetadataResource, String identityProviderEntityId, String serviceProviderEntityId, String providerName, Supplier<List<XSAny>> authnRequestExtensions, String attributeAsId) {
        this.keyStoreAlias = keyStoreAlias;
        this.keyStoreType = keyStoreType;
        this.keystoreResource = keystoreResource;
        this.keystorePassword = keystorePassword;
        this.privateKeyPassword = privateKeyPassword;
        this.identityProviderMetadataResource = identityProviderMetadataResource;
        this.identityProviderEntityId = identityProviderEntityId;
        this.serviceProviderEntityId = serviceProviderEntityId;
        this.providerName = providerName;
        this.authnRequestExtensions = authnRequestExtensions;
        this.attributeAsId = attributeAsId;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        try {
            if (CommonHelper.isBlank((String)this.getServiceProviderEntityId())) {
                URL url = new URL(callbackUrl);
                if (url.getQuery() != null) {
                    this.setServiceProviderEntityId(url.toString().replace("?" + url.getQuery(), ""));
                } else {
                    this.setServiceProviderEntityId(url.toString());
                }
            }
            LOGGER.info("Using service provider entity ID {}", (Object)this.getServiceProviderEntityId());
        }
        catch (Exception e) {
            throw new SAMLException(e);
        }
    }

    protected void internalInit(boolean forceReinit) {
        SAML2KeystoreGenerator keystoreGenerator = this.getKeystoreGenerator();
        if (keystoreGenerator.shouldGenerate()) {
            LOGGER.warn("Generating keystore one for/via: {}", (Object)this.keystoreResource);
            keystoreGenerator.generate();
        }
        if (this.sessionLogoutHandler == null) {
            this.sessionLogoutHandler = new DefaultSessionLogoutHandler();
        }
        this.initSignatureSigningConfiguration();
    }

    public SAML2KeystoreGenerator getKeystoreGenerator() {
        if (this.keystoreGenerator == null) {
            if (this.keystoreResource instanceof UrlResource) {
                return new SAML2HttpUrlKeystoreGenerator(this);
            }
            return new SAML2FileSystemKeystoreGenerator(this);
        }
        return this.keystoreGenerator;
    }

    public void setIdentityProviderMetadataResourceFilepath(String path) {
        this.identityProviderMetadataResource = new FileSystemResource(path);
    }

    public void setIdentityProviderMetadataResourceClasspath(String path) {
        this.identityProviderMetadataResource = new ClassPathResource(path);
    }

    public void setIdentityProviderMetadataResourceUrl(String url) {
        this.identityProviderMetadataResource = SpringResourceHelper.newUrlResource((String)url);
    }

    public void setIdentityProviderMetadataPath(String path) {
        this.identityProviderMetadataResource = SpringResourceHelper.buildResourceFromPath((String)path);
    }

    public void setKeystoreResourceFilepath(String path) {
        this.keystoreResource = new FileSystemResource(path);
    }

    public void setKeystoreResourceClasspath(String path) {
        this.keystoreResource = new ClassPathResource(path);
    }

    public void setKeystoreResourceUrl(String url) {
        this.keystoreResource = SpringResourceHelper.buildResourceFromPath((String)url);
    }

    public void setKeystorePath(String path) {
        this.keystoreResource = SpringResourceHelper.buildResourceFromPath((String)path);
    }

    public void setPrivateKeyPassword(String privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
    }

    public String getCertificateNameToAppend() {
        return this.certificateNameToAppend;
    }

    public void setCertificateNameToAppend(String certificateNameToAppend) {
        this.certificateNameToAppend = certificateNameToAppend;
    }

    public void setServiceProviderMetadataResourceFilepath(String path) {
        this.serviceProviderMetadataResource = new FileSystemResource(path);
    }

    public void setServiceProviderMetadataPath(String path) {
        this.serviceProviderMetadataResource = SpringResourceHelper.buildResourceFromPath((String)path);
    }

    public SessionLogoutHandler findSessionLogoutHandler() {
        this.init();
        return this.sessionLogoutHandler;
    }

    private void initSignatureSigningConfiguration() {
        BasicSignatureSigningConfiguration config = DefaultSecurityConfigurationBootstrap.buildDefaultSignatureSigningConfiguration();
        if (this.blackListedSignatureSigningAlgorithms == null) {
            this.blackListedSignatureSigningAlgorithms = new ArrayList<String>(config.getExcludedAlgorithms());
            LOGGER.info("Bootstrapped Blacklisted Algorithms");
        }
        if (this.signatureAlgorithms == null) {
            this.signatureAlgorithms = new ArrayList<String>(config.getSignatureAlgorithms());
            LOGGER.info("Bootstrapped Signature Algorithms");
        }
        if (this.signatureReferenceDigestMethods == null) {
            this.signatureReferenceDigestMethods = new ArrayList<String>(config.getSignatureReferenceDigestMethods());
            this.signatureReferenceDigestMethods.remove("http://www.w3.org/2001/04/xmlenc#sha512");
            LOGGER.info("Bootstrapped Signature Reference Digest Methods");
        }
        if (this.signatureCanonicalizationAlgorithm == null) {
            this.signatureCanonicalizationAlgorithm = config.getSignatureCanonicalizationAlgorithm();
            LOGGER.info("Bootstrapped Canonicalization Algorithm");
        }
    }

    public HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = new SAML2HttpClientBuilder().build();
        }
        return this.httpClient;
    }

    public CredentialProvider getCredentialProvider() {
        return new KeyStoreCredentialProvider(this);
    }

    public SAML2MetadataGenerator toMetadataGenerator() {
        try {
            SAML2MetadataGenerator instance = this.getMetadataGenerator();
            if (instance instanceof BaseSAML2MetadataGenerator) {
                BaseSAML2MetadataGenerator generator = (BaseSAML2MetadataGenerator)instance;
                generator.setWantAssertionSigned(this.isWantsAssertionsSigned());
                generator.setAuthnRequestSigned(this.isAuthnRequestSigned());
                generator.setSignMetadata(this.isSignMetadata());
                generator.setNameIdPolicyFormat(this.getNameIdPolicyFormat());
                generator.setRequestedAttributes(this.getRequestedServiceProviderAttributes());
                generator.setCredentialProvider(this.getCredentialProvider());
                generator.setMetadataSigner(this.getMetadataSigner());
                generator.setEntityId(this.getServiceProviderEntityId());
                generator.setRequestInitiatorLocation(StringUtils.defaultString((String)this.requestInitiatorUrl, (String)this.callbackUrl));
                generator.setAssertionConsumerServiceUrl(StringUtils.defaultString((String)this.assertionConsumerServiceUrl, (String)this.callbackUrl));
                generator.setResponseBindingType(this.getResponseBindingType());
                this.determineSingleSignOutServiceUrl(generator);
                if (this.getBlackListedSignatureSigningAlgorithms() != null) {
                    generator.setBlackListedSignatureSigningAlgorithms(new ArrayList<String>(this.getBlackListedSignatureSigningAlgorithms()));
                }
                generator.setSignatureAlgorithms(this.getSignatureAlgorithms());
                generator.setSignatureReferenceDigestMethods(this.getSignatureReferenceDigestMethods());
                generator.setSupportedProtocols(this.getSupportedProtocols());
                generator.setContactPersons(this.getContactPersons());
                generator.setMetadataUIInfos(this.getMetadataUIInfos());
            }
            return instance;
        }
        catch (Exception e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    protected void determineSingleSignOutServiceUrl(BaseSAML2MetadataGenerator generator) {
        String logoutUrl = CommonHelper.ifBlank((String)this.singleSignOutServiceUrl, (String)this.callbackUrl);
        generator.setSingleLogoutServiceUrl(logoutUrl);
    }

    public SAML2MetadataGenerator getMetadataGenerator() {
        return Objects.requireNonNullElseGet(this.metadataGenerator, () -> ServiceLoader.load(SAML2MetadataGenerator.class).stream().findFirst().map(ServiceLoader.Provider::get).orElseGet(() -> {
            try {
                return this.serviceProviderMetadataResource instanceof UrlResource ? new SAML2HttpUrlMetadataGenerator(this.serviceProviderMetadataResource.getURL(), this.getHttpClient()) : new SAML2FileSystemMetadataGenerator(this.serviceProviderMetadataResource);
            }
            catch (Exception e) {
                throw new TechnicalException((Throwable)e);
            }
        }));
    }

    public SAML2MetadataResolver getIdentityProviderMetadataResolver() {
        if (this.identityProviderMetadataResolver == null) {
            return new SAML2IdentityProviderMetadataResolver(this);
        }
        return this.identityProviderMetadataResolver;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<SAML2ScopingIdentityProvider> getScopingIdentityProviders() {
        return this.scopingIdentityProviders;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<SAML2ServiceProviderRequestedAttribute> getRequestedServiceProviderAttributes() {
        return this.requestedServiceProviderAttributes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2MetadataSigner getMetadataSigner() {
        return this.metadataSigner;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getSingleSignOutServiceUrl() {
        return this.singleSignOutServiceUrl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getNameIdAttribute() {
        return this.nameIdAttribute;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getRequestInitiatorUrl() {
        return this.requestInitiatorUrl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getAssertionConsumerServiceUrl() {
        return this.assertionConsumerServiceUrl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Resource getKeystoreResource() {
        return this.keystoreResource;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Resource getIdentityProviderMetadataResource() {
        return this.identityProviderMetadataResource;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getIdentityProviderEntityId() {
        return this.identityProviderEntityId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getServiceProviderEntityId() {
        return this.serviceProviderEntityId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getMaximumAuthenticationLifetime() {
        return this.maximumAuthenticationLifetime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getAcceptedSkew() {
        return this.acceptedSkew;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isForceAuth() {
        return this.forceAuth;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isPassive() {
        return this.passive;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getComparisonType() {
        return this.comparisonType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isPartialLogoutTreatedAsSuccess() {
        return this.isPartialLogoutTreatedAsSuccess;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getAuthnRequestBindingType() {
        return this.authnRequestBindingType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getResponseBindingType() {
        return this.responseBindingType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getSpLogoutRequestBindingType() {
        return this.spLogoutRequestBindingType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getSpLogoutResponseBindingType() {
        return this.spLogoutResponseBindingType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<String> getAuthnContextClassRefs() {
        return this.authnContextClassRefs;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getNameIdPolicyFormat() {
        return this.nameIdPolicyFormat;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isUseNameQualifier() {
        return this.useNameQualifier;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isSignMetadata() {
        return this.signMetadata;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Resource getServiceProviderMetadataResource() {
        return this.serviceProviderMetadataResource;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isForceServiceProviderMetadataGeneration() {
        return this.forceServiceProviderMetadataGeneration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isForceKeystoreGeneration() {
        return this.forceKeystoreGeneration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAMLMessageStoreFactory getSamlMessageStoreFactory() {
        return this.samlMessageStoreFactory;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isAuthnRequestSigned() {
        return this.authnRequestSigned;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isSpLogoutRequestSigned() {
        return this.spLogoutRequestSigned;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Collection<String> getBlackListedSignatureSigningAlgorithms() {
        return this.blackListedSignatureSigningAlgorithms;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<String> getSignatureAlgorithms() {
        return this.signatureAlgorithms;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<String> getSignatureReferenceDigestMethods() {
        return this.signatureReferenceDigestMethods;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getSignatureCanonicalizationAlgorithm() {
        return this.signatureCanonicalizationAlgorithm;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isWantsAssertionsSigned() {
        return this.wantsAssertionsSigned;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isWantsResponsesSigned() {
        return this.wantsResponsesSigned;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isAllSignatureValidationDisabled() {
        return this.allSignatureValidationDisabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isResponseDestinationAttributeMandatory() {
        return this.responseDestinationAttributeMandatory;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getKeyStoreAlias() {
        return this.keyStoreAlias;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getAssertionConsumerServiceIndex() {
        return this.assertionConsumerServiceIndex;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getAttributeConsumingServiceIndex() {
        return this.attributeConsumingServiceIndex;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getProviderName() {
        return this.providerName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Supplier<List<XSAny>> getAuthnRequestExtensions() {
        return this.authnRequestExtensions;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getAttributeAsId() {
        return this.attributeAsId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, String> getMappedAttributes() {
        return this.mappedAttributes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public URIComparator getUriComparator() {
        return this.uriComparator;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SessionLogoutHandler getSessionLogoutHandler() {
        return this.sessionLogoutHandler;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPostLogoutURL() {
        return this.postLogoutURL;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Period getCertificateExpirationPeriod() {
        return this.certificateExpirationPeriod;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCertificateSignatureAlg() {
        return this.certificateSignatureAlg;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getPrivateKeySize() {
        return this.privateKeySize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<SAML2MetadataContactPerson> getContactPersons() {
        return this.contactPersons;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<SAML2MetadataUIInfo> getMetadataUIInfos() {
        return this.metadataUIInfos;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getIssuerFormat() {
        return this.issuerFormat;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AttributeConverter getSamlAttributeConverter() {
        return this.samlAttributeConverter;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Boolean getNameIdPolicyAllowCreate() {
        return this.nameIdPolicyAllowCreate;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<String> getSupportedProtocols() {
        return this.supportedProtocols;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getIdentityProviderMetadataConnectTimeout() {
        return this.identityProviderMetadataConnectTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getIdentityProviderMetadataReadTimeout() {
        return this.identityProviderMetadataReadTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setMetadataSigner(SAML2MetadataSigner metadataSigner) {
        this.metadataSigner = metadataSigner;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setSingleSignOutServiceUrl(String singleSignOutServiceUrl) {
        this.singleSignOutServiceUrl = singleSignOutServiceUrl;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setNameIdAttribute(String nameIdAttribute) {
        this.nameIdAttribute = nameIdAttribute;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setRequestInitiatorUrl(String requestInitiatorUrl) {
        this.requestInitiatorUrl = requestInitiatorUrl;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setAssertionConsumerServiceUrl(String assertionConsumerServiceUrl) {
        this.assertionConsumerServiceUrl = assertionConsumerServiceUrl;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setKeystoreResource(Resource keystoreResource) {
        this.keystoreResource = keystoreResource;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setIdentityProviderMetadataResource(Resource identityProviderMetadataResource) {
        this.identityProviderMetadataResource = identityProviderMetadataResource;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setIdentityProviderEntityId(String identityProviderEntityId) {
        this.identityProviderEntityId = identityProviderEntityId;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setServiceProviderEntityId(String serviceProviderEntityId) {
        this.serviceProviderEntityId = serviceProviderEntityId;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setMaximumAuthenticationLifetime(long maximumAuthenticationLifetime) {
        this.maximumAuthenticationLifetime = maximumAuthenticationLifetime;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setAcceptedSkew(long acceptedSkew) {
        this.acceptedSkew = acceptedSkew;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setForceAuth(boolean forceAuth) {
        this.forceAuth = forceAuth;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setPassive(boolean passive) {
        this.passive = passive;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setComparisonType(String comparisonType) {
        this.comparisonType = comparisonType;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setPartialLogoutTreatedAsSuccess(boolean isPartialLogoutTreatedAsSuccess) {
        this.isPartialLogoutTreatedAsSuccess = isPartialLogoutTreatedAsSuccess;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setAuthnRequestBindingType(String authnRequestBindingType) {
        this.authnRequestBindingType = authnRequestBindingType;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setResponseBindingType(String responseBindingType) {
        this.responseBindingType = responseBindingType;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setSpLogoutRequestBindingType(String spLogoutRequestBindingType) {
        this.spLogoutRequestBindingType = spLogoutRequestBindingType;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setSpLogoutResponseBindingType(String spLogoutResponseBindingType) {
        this.spLogoutResponseBindingType = spLogoutResponseBindingType;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setAuthnContextClassRefs(List<String> authnContextClassRefs) {
        this.authnContextClassRefs = authnContextClassRefs;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setNameIdPolicyFormat(String nameIdPolicyFormat) {
        this.nameIdPolicyFormat = nameIdPolicyFormat;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setUseNameQualifier(boolean useNameQualifier) {
        this.useNameQualifier = useNameQualifier;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setSignMetadata(boolean signMetadata) {
        this.signMetadata = signMetadata;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setServiceProviderMetadataResource(Resource serviceProviderMetadataResource) {
        this.serviceProviderMetadataResource = serviceProviderMetadataResource;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setForceServiceProviderMetadataGeneration(boolean forceServiceProviderMetadataGeneration) {
        this.forceServiceProviderMetadataGeneration = forceServiceProviderMetadataGeneration;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setForceKeystoreGeneration(boolean forceKeystoreGeneration) {
        this.forceKeystoreGeneration = forceKeystoreGeneration;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setSamlMessageStoreFactory(SAMLMessageStoreFactory samlMessageStoreFactory) {
        this.samlMessageStoreFactory = samlMessageStoreFactory;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setKeystoreGenerator(SAML2KeystoreGenerator keystoreGenerator) {
        this.keystoreGenerator = keystoreGenerator;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setMetadataGenerator(SAML2MetadataGenerator metadataGenerator) {
        this.metadataGenerator = metadataGenerator;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setAuthnRequestSigned(boolean authnRequestSigned) {
        this.authnRequestSigned = authnRequestSigned;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setSpLogoutRequestSigned(boolean spLogoutRequestSigned) {
        this.spLogoutRequestSigned = spLogoutRequestSigned;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setBlackListedSignatureSigningAlgorithms(Collection<String> blackListedSignatureSigningAlgorithms) {
        this.blackListedSignatureSigningAlgorithms = blackListedSignatureSigningAlgorithms;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setSignatureAlgorithms(List<String> signatureAlgorithms) {
        this.signatureAlgorithms = signatureAlgorithms;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setSignatureReferenceDigestMethods(List<String> signatureReferenceDigestMethods) {
        this.signatureReferenceDigestMethods = signatureReferenceDigestMethods;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setSignatureCanonicalizationAlgorithm(String signatureCanonicalizationAlgorithm) {
        this.signatureCanonicalizationAlgorithm = signatureCanonicalizationAlgorithm;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setWantsAssertionsSigned(boolean wantsAssertionsSigned) {
        this.wantsAssertionsSigned = wantsAssertionsSigned;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setWantsResponsesSigned(boolean wantsResponsesSigned) {
        this.wantsResponsesSigned = wantsResponsesSigned;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setAllSignatureValidationDisabled(boolean allSignatureValidationDisabled) {
        this.allSignatureValidationDisabled = allSignatureValidationDisabled;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setResponseDestinationAttributeMandatory(boolean responseDestinationAttributeMandatory) {
        this.responseDestinationAttributeMandatory = responseDestinationAttributeMandatory;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setKeyStoreAlias(String keyStoreAlias) {
        this.keyStoreAlias = keyStoreAlias;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setAssertionConsumerServiceIndex(int assertionConsumerServiceIndex) {
        this.assertionConsumerServiceIndex = assertionConsumerServiceIndex;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setAttributeConsumingServiceIndex(int attributeConsumingServiceIndex) {
        this.attributeConsumingServiceIndex = attributeConsumingServiceIndex;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setProviderName(String providerName) {
        this.providerName = providerName;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setAuthnRequestExtensions(Supplier<List<XSAny>> authnRequestExtensions) {
        this.authnRequestExtensions = authnRequestExtensions;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setAttributeAsId(String attributeAsId) {
        this.attributeAsId = attributeAsId;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setMappedAttributes(Map<String, String> mappedAttributes) {
        this.mappedAttributes = mappedAttributes;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setUriComparator(URIComparator uriComparator) {
        this.uriComparator = uriComparator;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setSessionLogoutHandler(SessionLogoutHandler sessionLogoutHandler) {
        this.sessionLogoutHandler = sessionLogoutHandler;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setPostLogoutURL(String postLogoutURL) {
        this.postLogoutURL = postLogoutURL;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setCertificateExpirationPeriod(Period certificateExpirationPeriod) {
        this.certificateExpirationPeriod = certificateExpirationPeriod;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setCertificateSignatureAlg(String certificateSignatureAlg) {
        this.certificateSignatureAlg = certificateSignatureAlg;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setPrivateKeySize(int privateKeySize) {
        this.privateKeySize = privateKeySize;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setContactPersons(List<SAML2MetadataContactPerson> contactPersons) {
        this.contactPersons = contactPersons;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setMetadataUIInfos(List<SAML2MetadataUIInfo> metadataUIInfos) {
        this.metadataUIInfos = metadataUIInfos;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setIssuerFormat(String issuerFormat) {
        this.issuerFormat = issuerFormat;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setSamlAttributeConverter(AttributeConverter samlAttributeConverter) {
        this.samlAttributeConverter = samlAttributeConverter;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setNameIdPolicyAllowCreate(Boolean nameIdPolicyAllowCreate) {
        this.nameIdPolicyAllowCreate = nameIdPolicyAllowCreate;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setSupportedProtocols(List<String> supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setIdentityProviderMetadataResolver(SAML2MetadataResolver identityProviderMetadataResolver) {
        this.identityProviderMetadataResolver = identityProviderMetadataResolver;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setIdentityProviderMetadataConnectTimeout(int identityProviderMetadataConnectTimeout) {
        this.identityProviderMetadataConnectTimeout = identityProviderMetadataConnectTimeout;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration setIdentityProviderMetadataReadTimeout(int identityProviderMetadataReadTimeout) {
        this.identityProviderMetadataReadTimeout = identityProviderMetadataReadTimeout;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "SAML2Configuration(identityProviderMetadataResource=" + this.identityProviderMetadataResource + ", serviceProviderEntityId=" + this.serviceProviderEntityId + ", serviceProviderMetadataResource=" + this.serviceProviderMetadataResource + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withHostnameVerifier(HostnameVerifier hostnameVerifier) {
        return this.hostnameVerifier == hostnameVerifier ? this : new SAML2Configuration(hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        return this.sslSocketFactory == sslSocketFactory ? this : new SAML2Configuration(this.hostnameVerifier, sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withMetadataSigner(SAML2MetadataSigner metadataSigner) {
        return this.metadataSigner == metadataSigner ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withSingleSignOutServiceUrl(String singleSignOutServiceUrl) {
        return this.singleSignOutServiceUrl == singleSignOutServiceUrl ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withNameIdAttribute(String nameIdAttribute) {
        return this.nameIdAttribute == nameIdAttribute ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withCallbackUrl(String callbackUrl) {
        return this.callbackUrl == callbackUrl ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withRequestInitiatorUrl(String requestInitiatorUrl) {
        return this.requestInitiatorUrl == requestInitiatorUrl ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withAssertionConsumerServiceUrl(String assertionConsumerServiceUrl) {
        return this.assertionConsumerServiceUrl == assertionConsumerServiceUrl ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withKeystoreResource(Resource keystoreResource) {
        return this.keystoreResource == keystoreResource ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withKeystorePassword(String keystorePassword) {
        return this.keystorePassword == keystorePassword ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withPrivateKeyPassword(String privateKeyPassword) {
        return this.privateKeyPassword == privateKeyPassword ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withCertificateNameToAppend(String certificateNameToAppend) {
        return this.certificateNameToAppend == certificateNameToAppend ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withIdentityProviderMetadataResource(Resource identityProviderMetadataResource) {
        return this.identityProviderMetadataResource == identityProviderMetadataResource ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withIdentityProviderEntityId(String identityProviderEntityId) {
        return this.identityProviderEntityId == identityProviderEntityId ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withServiceProviderEntityId(String serviceProviderEntityId) {
        return this.serviceProviderEntityId == serviceProviderEntityId ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withMaximumAuthenticationLifetime(long maximumAuthenticationLifetime) {
        return this.maximumAuthenticationLifetime == maximumAuthenticationLifetime ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withAcceptedSkew(long acceptedSkew) {
        return this.acceptedSkew == acceptedSkew ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withForceAuth(boolean forceAuth) {
        return this.forceAuth == forceAuth ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withPassive(boolean passive) {
        return this.passive == passive ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withComparisonType(String comparisonType) {
        return this.comparisonType == comparisonType ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withPartialLogoutTreatedAsSuccess(boolean isPartialLogoutTreatedAsSuccess) {
        return this.isPartialLogoutTreatedAsSuccess == isPartialLogoutTreatedAsSuccess ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withAuthnRequestBindingType(String authnRequestBindingType) {
        return this.authnRequestBindingType == authnRequestBindingType ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withResponseBindingType(String responseBindingType) {
        return this.responseBindingType == responseBindingType ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withSpLogoutRequestBindingType(String spLogoutRequestBindingType) {
        return this.spLogoutRequestBindingType == spLogoutRequestBindingType ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withSpLogoutResponseBindingType(String spLogoutResponseBindingType) {
        return this.spLogoutResponseBindingType == spLogoutResponseBindingType ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withAuthnContextClassRefs(List<String> authnContextClassRefs) {
        return this.authnContextClassRefs == authnContextClassRefs ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withNameIdPolicyFormat(String nameIdPolicyFormat) {
        return this.nameIdPolicyFormat == nameIdPolicyFormat ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withUseNameQualifier(boolean useNameQualifier) {
        return this.useNameQualifier == useNameQualifier ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withSignMetadata(boolean signMetadata) {
        return this.signMetadata == signMetadata ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withServiceProviderMetadataResource(Resource serviceProviderMetadataResource) {
        return this.serviceProviderMetadataResource == serviceProviderMetadataResource ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withForceServiceProviderMetadataGeneration(boolean forceServiceProviderMetadataGeneration) {
        return this.forceServiceProviderMetadataGeneration == forceServiceProviderMetadataGeneration ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withForceKeystoreGeneration(boolean forceKeystoreGeneration) {
        return this.forceKeystoreGeneration == forceKeystoreGeneration ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withSamlMessageStoreFactory(SAMLMessageStoreFactory samlMessageStoreFactory) {
        return this.samlMessageStoreFactory == samlMessageStoreFactory ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withKeystoreGenerator(SAML2KeystoreGenerator keystoreGenerator) {
        return this.keystoreGenerator == keystoreGenerator ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withMetadataGenerator(SAML2MetadataGenerator metadataGenerator) {
        return this.metadataGenerator == metadataGenerator ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withAuthnRequestSigned(boolean authnRequestSigned) {
        return this.authnRequestSigned == authnRequestSigned ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withSpLogoutRequestSigned(boolean spLogoutRequestSigned) {
        return this.spLogoutRequestSigned == spLogoutRequestSigned ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withBlackListedSignatureSigningAlgorithms(Collection<String> blackListedSignatureSigningAlgorithms) {
        return this.blackListedSignatureSigningAlgorithms == blackListedSignatureSigningAlgorithms ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withSignatureAlgorithms(List<String> signatureAlgorithms) {
        return this.signatureAlgorithms == signatureAlgorithms ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withSignatureReferenceDigestMethods(List<String> signatureReferenceDigestMethods) {
        return this.signatureReferenceDigestMethods == signatureReferenceDigestMethods ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withSignatureCanonicalizationAlgorithm(String signatureCanonicalizationAlgorithm) {
        return this.signatureCanonicalizationAlgorithm == signatureCanonicalizationAlgorithm ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withWantsAssertionsSigned(boolean wantsAssertionsSigned) {
        return this.wantsAssertionsSigned == wantsAssertionsSigned ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withWantsResponsesSigned(boolean wantsResponsesSigned) {
        return this.wantsResponsesSigned == wantsResponsesSigned ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withAllSignatureValidationDisabled(boolean allSignatureValidationDisabled) {
        return this.allSignatureValidationDisabled == allSignatureValidationDisabled ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withResponseDestinationAttributeMandatory(boolean responseDestinationAttributeMandatory) {
        return this.responseDestinationAttributeMandatory == responseDestinationAttributeMandatory ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withKeyStoreAlias(String keyStoreAlias) {
        return this.keyStoreAlias == keyStoreAlias ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withKeyStoreType(String keyStoreType) {
        return this.keyStoreType == keyStoreType ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withAssertionConsumerServiceIndex(int assertionConsumerServiceIndex) {
        return this.assertionConsumerServiceIndex == assertionConsumerServiceIndex ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withAttributeConsumingServiceIndex(int attributeConsumingServiceIndex) {
        return this.attributeConsumingServiceIndex == attributeConsumingServiceIndex ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withProviderName(String providerName) {
        return this.providerName == providerName ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withAuthnRequestExtensions(Supplier<List<XSAny>> authnRequestExtensions) {
        return this.authnRequestExtensions == authnRequestExtensions ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withAttributeAsId(String attributeAsId) {
        return this.attributeAsId == attributeAsId ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withMappedAttributes(Map<String, String> mappedAttributes) {
        return this.mappedAttributes == mappedAttributes ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withUriComparator(URIComparator uriComparator) {
        return this.uriComparator == uriComparator ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withSessionLogoutHandler(SessionLogoutHandler sessionLogoutHandler) {
        return this.sessionLogoutHandler == sessionLogoutHandler ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withPostLogoutURL(String postLogoutURL) {
        return this.postLogoutURL == postLogoutURL ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withCertificateExpirationPeriod(Period certificateExpirationPeriod) {
        return this.certificateExpirationPeriod == certificateExpirationPeriod ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withCertificateSignatureAlg(String certificateSignatureAlg) {
        return this.certificateSignatureAlg == certificateSignatureAlg ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withPrivateKeySize(int privateKeySize) {
        return this.privateKeySize == privateKeySize ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withContactPersons(List<SAML2MetadataContactPerson> contactPersons) {
        return this.contactPersons == contactPersons ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withMetadataUIInfos(List<SAML2MetadataUIInfo> metadataUIInfos) {
        return this.metadataUIInfos == metadataUIInfos ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withIssuerFormat(String issuerFormat) {
        return this.issuerFormat == issuerFormat ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withHttpClient(HttpClient httpClient) {
        return this.httpClient == httpClient ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withSamlAttributeConverter(AttributeConverter samlAttributeConverter) {
        return this.samlAttributeConverter == samlAttributeConverter ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withNameIdPolicyAllowCreate(Boolean nameIdPolicyAllowCreate) {
        return this.nameIdPolicyAllowCreate == nameIdPolicyAllowCreate ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withSupportedProtocols(List<String> supportedProtocols) {
        return this.supportedProtocols == supportedProtocols ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withIdentityProviderMetadataResolver(SAML2MetadataResolver identityProviderMetadataResolver) {
        return this.identityProviderMetadataResolver == identityProviderMetadataResolver ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withIdentityProviderMetadataConnectTimeout(int identityProviderMetadataConnectTimeout) {
        return this.identityProviderMetadataConnectTimeout == identityProviderMetadataConnectTimeout ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, identityProviderMetadataConnectTimeout, this.identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration withIdentityProviderMetadataReadTimeout(int identityProviderMetadataReadTimeout) {
        return this.identityProviderMetadataReadTimeout == identityProviderMetadataReadTimeout ? this : new SAML2Configuration(this.hostnameVerifier, this.sslSocketFactory, this.metadataSigner, this.singleSignOutServiceUrl, this.nameIdAttribute, this.callbackUrl, this.requestInitiatorUrl, this.assertionConsumerServiceUrl, this.keystoreResource, this.keystorePassword, this.privateKeyPassword, this.certificateNameToAppend, this.identityProviderMetadataResource, this.identityProviderEntityId, this.serviceProviderEntityId, this.maximumAuthenticationLifetime, this.acceptedSkew, this.forceAuth, this.passive, this.comparisonType, this.isPartialLogoutTreatedAsSuccess, this.authnRequestBindingType, this.responseBindingType, this.spLogoutRequestBindingType, this.spLogoutResponseBindingType, this.authnContextClassRefs, this.nameIdPolicyFormat, this.useNameQualifier, this.signMetadata, this.serviceProviderMetadataResource, this.forceServiceProviderMetadataGeneration, this.forceKeystoreGeneration, this.samlMessageStoreFactory, this.keystoreGenerator, this.metadataGenerator, this.authnRequestSigned, this.spLogoutRequestSigned, this.blackListedSignatureSigningAlgorithms, this.signatureAlgorithms, this.signatureReferenceDigestMethods, this.signatureCanonicalizationAlgorithm, this.wantsAssertionsSigned, this.wantsResponsesSigned, this.allSignatureValidationDisabled, this.responseDestinationAttributeMandatory, this.keyStoreAlias, this.keyStoreType, this.assertionConsumerServiceIndex, this.attributeConsumingServiceIndex, this.providerName, this.authnRequestExtensions, this.attributeAsId, this.mappedAttributes, this.uriComparator, this.sessionLogoutHandler, this.postLogoutURL, this.certificateExpirationPeriod, this.certificateSignatureAlg, this.privateKeySize, this.contactPersons, this.metadataUIInfos, this.issuerFormat, this.httpClient, this.samlAttributeConverter, this.nameIdPolicyAllowCreate, this.supportedProtocols, this.identityProviderMetadataResolver, this.identityProviderMetadataConnectTimeout, identityProviderMetadataReadTimeout);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration(HostnameVerifier hostnameVerifier, SSLSocketFactory sslSocketFactory, SAML2MetadataSigner metadataSigner, String singleSignOutServiceUrl, String nameIdAttribute, String callbackUrl, String requestInitiatorUrl, String assertionConsumerServiceUrl, Resource keystoreResource, String keystorePassword, String privateKeyPassword, String certificateNameToAppend, Resource identityProviderMetadataResource, String identityProviderEntityId, String serviceProviderEntityId, long maximumAuthenticationLifetime, long acceptedSkew, boolean forceAuth, boolean passive, String comparisonType, boolean isPartialLogoutTreatedAsSuccess, String authnRequestBindingType, String responseBindingType, String spLogoutRequestBindingType, String spLogoutResponseBindingType, List<String> authnContextClassRefs, String nameIdPolicyFormat, boolean useNameQualifier, boolean signMetadata, Resource serviceProviderMetadataResource, boolean forceServiceProviderMetadataGeneration, boolean forceKeystoreGeneration, SAMLMessageStoreFactory samlMessageStoreFactory, SAML2KeystoreGenerator keystoreGenerator, SAML2MetadataGenerator metadataGenerator, boolean authnRequestSigned, boolean spLogoutRequestSigned, Collection<String> blackListedSignatureSigningAlgorithms, List<String> signatureAlgorithms, List<String> signatureReferenceDigestMethods, String signatureCanonicalizationAlgorithm, boolean wantsAssertionsSigned, boolean wantsResponsesSigned, boolean allSignatureValidationDisabled, boolean responseDestinationAttributeMandatory, String keyStoreAlias, String keyStoreType, int assertionConsumerServiceIndex, int attributeConsumingServiceIndex, String providerName, Supplier<List<XSAny>> authnRequestExtensions, String attributeAsId, Map<String, String> mappedAttributes, URIComparator uriComparator, SessionLogoutHandler sessionLogoutHandler, String postLogoutURL, Period certificateExpirationPeriod, String certificateSignatureAlg, int privateKeySize, List<SAML2MetadataContactPerson> contactPersons, List<SAML2MetadataUIInfo> metadataUIInfos, String issuerFormat, HttpClient httpClient, AttributeConverter samlAttributeConverter, Boolean nameIdPolicyAllowCreate, List<String> supportedProtocols, SAML2MetadataResolver identityProviderMetadataResolver, int identityProviderMetadataConnectTimeout, int identityProviderMetadataReadTimeout) {
        this.hostnameVerifier = hostnameVerifier;
        this.sslSocketFactory = sslSocketFactory;
        this.metadataSigner = metadataSigner;
        this.singleSignOutServiceUrl = singleSignOutServiceUrl;
        this.nameIdAttribute = nameIdAttribute;
        this.callbackUrl = callbackUrl;
        this.requestInitiatorUrl = requestInitiatorUrl;
        this.assertionConsumerServiceUrl = assertionConsumerServiceUrl;
        this.keystoreResource = keystoreResource;
        this.keystorePassword = keystorePassword;
        this.privateKeyPassword = privateKeyPassword;
        this.certificateNameToAppend = certificateNameToAppend;
        this.identityProviderMetadataResource = identityProviderMetadataResource;
        this.identityProviderEntityId = identityProviderEntityId;
        this.serviceProviderEntityId = serviceProviderEntityId;
        this.maximumAuthenticationLifetime = maximumAuthenticationLifetime;
        this.acceptedSkew = acceptedSkew;
        this.forceAuth = forceAuth;
        this.passive = passive;
        this.comparisonType = comparisonType;
        this.isPartialLogoutTreatedAsSuccess = isPartialLogoutTreatedAsSuccess;
        this.authnRequestBindingType = authnRequestBindingType;
        this.responseBindingType = responseBindingType;
        this.spLogoutRequestBindingType = spLogoutRequestBindingType;
        this.spLogoutResponseBindingType = spLogoutResponseBindingType;
        this.authnContextClassRefs = authnContextClassRefs;
        this.nameIdPolicyFormat = nameIdPolicyFormat;
        this.useNameQualifier = useNameQualifier;
        this.signMetadata = signMetadata;
        this.serviceProviderMetadataResource = serviceProviderMetadataResource;
        this.forceServiceProviderMetadataGeneration = forceServiceProviderMetadataGeneration;
        this.forceKeystoreGeneration = forceKeystoreGeneration;
        this.samlMessageStoreFactory = samlMessageStoreFactory;
        this.keystoreGenerator = keystoreGenerator;
        this.metadataGenerator = metadataGenerator;
        this.authnRequestSigned = authnRequestSigned;
        this.spLogoutRequestSigned = spLogoutRequestSigned;
        this.blackListedSignatureSigningAlgorithms = blackListedSignatureSigningAlgorithms;
        this.signatureAlgorithms = signatureAlgorithms;
        this.signatureReferenceDigestMethods = signatureReferenceDigestMethods;
        this.signatureCanonicalizationAlgorithm = signatureCanonicalizationAlgorithm;
        this.wantsAssertionsSigned = wantsAssertionsSigned;
        this.wantsResponsesSigned = wantsResponsesSigned;
        this.allSignatureValidationDisabled = allSignatureValidationDisabled;
        this.responseDestinationAttributeMandatory = responseDestinationAttributeMandatory;
        this.keyStoreAlias = keyStoreAlias;
        this.keyStoreType = keyStoreType;
        this.assertionConsumerServiceIndex = assertionConsumerServiceIndex;
        this.attributeConsumingServiceIndex = attributeConsumingServiceIndex;
        this.providerName = providerName;
        this.authnRequestExtensions = authnRequestExtensions;
        this.attributeAsId = attributeAsId;
        this.mappedAttributes = mappedAttributes;
        this.uriComparator = uriComparator;
        this.sessionLogoutHandler = sessionLogoutHandler;
        this.postLogoutURL = postLogoutURL;
        this.certificateExpirationPeriod = certificateExpirationPeriod;
        this.certificateSignatureAlg = certificateSignatureAlg;
        this.privateKeySize = privateKeySize;
        this.contactPersons = contactPersons;
        this.metadataUIInfos = metadataUIInfos;
        this.issuerFormat = issuerFormat;
        this.httpClient = httpClient;
        this.samlAttributeConverter = samlAttributeConverter;
        this.nameIdPolicyAllowCreate = nameIdPolicyAllowCreate;
        this.supportedProtocols = supportedProtocols;
        this.identityProviderMetadataResolver = identityProviderMetadataResolver;
        this.identityProviderMetadataConnectTimeout = identityProviderMetadataConnectTimeout;
        this.identityProviderMetadataReadTimeout = identityProviderMetadataReadTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SAML2Configuration() {
    }
}

