/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.paypal;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.model.Token;
import java.util.Arrays;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.config.OAuthConfiguration;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.converter.JsonConverter;
import org.pac4j.oauth.profile.definition.OAuthProfileDefinition;
import org.pac4j.oauth.profile.paypal.PayPalAddress;
import org.pac4j.oauth.profile.paypal.PayPalProfile;

public class PayPalProfileDefinition
extends OAuthProfileDefinition {
    public static final String ADDRESS = "address";
    public static final String LANGUAGE = "language";
    public static final String ZONEINFO = "zoneinfo";
    public static final String NAME = "name";
    public static final String GIVEN_NAME = "given_name";

    public PayPalProfileDefinition() {
        super(x -> new PayPalProfile());
        Arrays.stream(new String[]{ZONEINFO, NAME, GIVEN_NAME}).forEach(a -> this.primary((String)a, Converters.STRING));
        this.primary(ADDRESS, new JsonConverter(PayPalAddress.class));
        this.primary(LANGUAGE, Converters.LOCALE);
    }

    @Override
    public String getProfileUrl(Token accessToken, OAuthConfiguration configuration) {
        return "https://api.paypal.com/v1/identity/openidconnect/userinfo?schema=openid";
    }

    @Override
    public PayPalProfile extractUserProfile(String body) {
        PayPalProfile profile = (PayPalProfile)this.newProfile(new Object[0]);
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            String userId = (String)JsonHelper.getElement(json, "user_id");
            profile.setId(CommonHelper.substringAfter((String)userId, (String)"/user/"));
            for (String attribute : this.getPrimaryAttributes()) {
                this.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, attribute, JsonHelper.getElement(json, attribute));
            }
        } else {
            this.raiseProfileExtractionJsonError(body);
        }
        return profile;
    }
}

