/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.github.scribejava.core.model.Verb;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;
import org.pac4j.core.logout.CasLogoutActionBuilder;
import org.pac4j.core.logout.LogoutActionBuilder;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.profile.casoauthwrapper.CasOAuthWrapperProfileDefinition;
import org.pac4j.scribe.builder.api.CasOAuthWrapperApi20;

public class CasOAuthWrapperClient
extends OAuth20Client {
    private String casOAuthUrl;
    private String casLogoutUrl;
    private boolean isJsonTokenExtractor = true;
    private Verb accessTokenVerb = Verb.POST;
    private boolean implicitFlow = false;

    public CasOAuthWrapperClient() {
    }

    public CasOAuthWrapperClient(String key, String secret, String casOAuthUrl) {
        this.setKey(key);
        this.setSecret(secret);
        this.setCasOAuthUrl(casOAuthUrl);
    }

    @Override
    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertNotBlank((String)"casOAuthUrl", (String)this.casOAuthUrl);
        this.configuration.setApi((Object)new CasOAuthWrapperApi20(this.casOAuthUrl, this.isJsonTokenExtractor, this.accessTokenVerb));
        this.configuration.setProfileDefinition(new CasOAuthWrapperProfileDefinition());
        if (this.implicitFlow) {
            this.configuration.setResponseType("token");
        } else {
            this.configuration.setResponseType("code");
        }
        this.setLogoutActionBuilderIfUndefined((LogoutActionBuilder)new CasLogoutActionBuilder(this.casLogoutUrl, "service"));
        super.internalInit(forceReinit);
    }

    public void setCasOAuthUrl(String casOAuthUrl) {
        CommonHelper.assertNotBlank((String)"casOAuthUrl", (String)casOAuthUrl);
        this.casOAuthUrl = casOAuthUrl.endsWith("/") ? casOAuthUrl.substring(0, casOAuthUrl.length() - 1) : casOAuthUrl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCasOAuthUrl() {
        return this.casOAuthUrl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCasLogoutUrl() {
        return this.casLogoutUrl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isJsonTokenExtractor() {
        return this.isJsonTokenExtractor;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Verb getAccessTokenVerb() {
        return this.accessTokenVerb;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isImplicitFlow() {
        return this.implicitFlow;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCasLogoutUrl(String casLogoutUrl) {
        this.casLogoutUrl = casLogoutUrl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setJsonTokenExtractor(boolean isJsonTokenExtractor) {
        this.isJsonTokenExtractor = isJsonTokenExtractor;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAccessTokenVerb(Verb accessTokenVerb) {
        this.accessTokenVerb = accessTokenVerb;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setImplicitFlow(boolean implicitFlow) {
        this.implicitFlow = implicitFlow;
    }
}

