/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.github.scribejava.core.model.Verb;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.pac4j.core.profile.converter.AbstractAttributeConverter;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.profile.generic.GenericOAuth20ProfileDefinition;
import org.pac4j.scribe.builder.api.GenericApi20;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericOAuth20Client
extends OAuth20Client {
    private static final Logger LOG = LoggerFactory.getLogger(GenericOAuth20Client.class);
    private String authUrl;
    private String tokenUrl;
    private String profileUrl;
    private String profilePath;
    private String profileId;
    private String scope;
    private boolean withState;
    private String clientAuthenticationMethod;
    private Verb profileVerb;
    private Map<String, String> profileAttrs;
    private Map<String, String> customParams;
    private List<Class<? extends AbstractAttributeConverter>> converterClasses;

    private static List<Class<? extends AbstractAttributeConverter>> findAttributeConverterClasses() {
        try {
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)AttributeConverter.class.getPackageName(), (ClassLoader[])new ClassLoader[0])));
            Set subTypes = reflections.getSubTypesOf(AbstractAttributeConverter.class);
            return subTypes.stream().filter(c -> !Modifier.isAbstract(c.getModifiers())).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOG.warn(e.toString());
            return new ArrayList<Class<? extends AbstractAttributeConverter>>(0);
        }
    }

    @Override
    protected void internalInit(boolean forceReinit) {
        this.converterClasses = GenericOAuth20Client.findAttributeConverterClasses();
        GenericApi20 genApi = new GenericApi20(this.authUrl, this.tokenUrl);
        this.configuration.setApi((Object)genApi);
        if (this.clientAuthenticationMethod != null) {
            genApi.setClientAuthenticationMethod(this.clientAuthenticationMethod);
        }
        this.configuration.setCustomParams(this.customParams);
        GenericOAuth20ProfileDefinition profileDefinition = new GenericOAuth20ProfileDefinition();
        profileDefinition.setFirstNodePath(this.profilePath);
        profileDefinition.setProfileVerb(this.profileVerb);
        profileDefinition.setProfileUrl(this.profileUrl);
        profileDefinition.setProfileId(Objects.requireNonNullElse(this.profileId, "id"));
        if (this.profileAttrs != null) {
            for (Map.Entry<String, String> entry : this.profileAttrs.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                String[] tokens = value.split("\\|");
                if (tokens.length == 2) {
                    profileDefinition.profileAttribute(key, tokens[1], (AttributeConverter)this.getConverter(tokens[0]));
                    continue;
                }
                if (tokens.length == 1) {
                    profileDefinition.profileAttribute(key, value, null);
                    continue;
                }
                LOG.warn("Ignored incorrect attribute value expressions: {}", (Object)value);
            }
        }
        this.configuration.setProfileDefinition(profileDefinition);
        this.configuration.setScope(this.scope);
        this.configuration.setWithState(this.withState);
        super.internalInit(forceReinit);
    }

    AbstractAttributeConverter getConverter(String typeName) {
        try {
            Stream<Class> acceptableConverters = this.converterClasses.stream().filter(x -> {
                try {
                    AbstractAttributeConverter converter = (AbstractAttributeConverter)x.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Method accept = AbstractAttributeConverter.class.getDeclaredMethod("accept", String.class);
                    return (Boolean)accept.invoke((Object)converter, typeName);
                }
                catch (ReflectiveOperationException e) {
                    LOG.warn("Ignore type which no parameterless constructor:" + x.getName());
                    return false;
                }
            });
            Class converterClazz = acceptableConverters.findFirst().orElse(null);
            if (converterClazz != null) {
                return (AbstractAttributeConverter)converterClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            LOG.warn(e.toString());
        }
        return null;
    }

    public void setAuthUrl(String authUrl) {
        this.authUrl = authUrl;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public void setProfileUrl(String profileUrl) {
        this.profileUrl = profileUrl;
    }

    public void setProfileNodePath(String profilePath) {
        this.profilePath = profilePath;
    }

    public void setProfileVerb(Verb profileVerb) {
        this.profileVerb = profileVerb;
    }

    public void setProfileAttrs(Map<String, String> profileAttrsMap) {
        this.profileAttrs = profileAttrsMap;
    }

    public void setCustomParams(Map<String, String> customParamsMap) {
        this.customParams = customParamsMap;
    }

    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean isWithState() {
        return this.withState;
    }

    public void setWithState(boolean withState) {
        this.withState = withState;
    }

    public String getClientAuthenticationMethod() {
        return this.clientAuthenticationMethod;
    }

    public void setClientAuthenticationMethod(String clientAuthenticationMethod) {
        this.clientAuthenticationMethod = clientAuthenticationMethod;
    }

    public List<Class<? extends AbstractAttributeConverter>> getConverters() {
        return List.copyOf(this.converterClasses);
    }

    public void addAttributeConverter(Class<AbstractAttributeConverter> converter) {
        this.converterClasses.add(converter);
    }
}

