/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.facebook;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Token;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.github.scribejava.core.oauth.OAuthService;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.HttpCommunicationException;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.pac4j.oauth.profile.creator.OAuth20ProfileCreator;
import org.pac4j.oauth.profile.definition.OAuthProfileDefinition;
import org.pac4j.oauth.profile.facebook.FacebookConfiguration;
import org.pac4j.oauth.profile.facebook.FacebookProfile;
import org.pac4j.oauth.profile.facebook.FacebookProfileDefinition;

public class FacebookProfileCreator
extends OAuth20ProfileCreator {
    private static final String EXCHANGE_TOKEN_URL = "https://graph.facebook.com/v2.8/oauth/access_token?grant_type=fb_exchange_token";
    private static final String EXCHANGE_TOKEN_PARAMETER = "fb_exchange_token";

    public FacebookProfileCreator(OAuth20Configuration configuration, IndirectClient client) {
        super(configuration, client);
    }

    @Override
    protected Optional<UserProfile> retrieveUserProfileFromToken(WebContext context, Token accessToken) {
        OAuthProfileDefinition profileDefinition = this.configuration.getProfileDefinition();
        FacebookConfiguration facebookConfiguration = (FacebookConfiguration)this.configuration;
        String profileUrl = profileDefinition.getProfileUrl(accessToken, this.configuration);
        OAuth20Service service = (OAuth20Service)this.configuration.buildService(context, this.client);
        String body = this.sendRequestForData((OAuthService)service, accessToken, profileUrl, Verb.GET);
        if (body == null) {
            throw new HttpCommunicationException("Not data found for accessToken: " + accessToken);
        }
        FacebookProfile profile = (FacebookProfile)profileDefinition.extractUserProfile(body);
        this.addAccessTokenToProfile((UserProfile)profile, accessToken);
        if (profile != null && facebookConfiguration.isRequiresExtendedToken()) {
            int code;
            Response response;
            String url = CommonHelper.addParameter((String)EXCHANGE_TOKEN_URL, (String)"client_id", (String)this.configuration.getKey());
            url = CommonHelper.addParameter((String)url, (String)"client_secret", (String)this.configuration.getSecret());
            url = this.addExchangeToken(url, (OAuth2AccessToken)accessToken);
            OAuthRequest request = this.createOAuthRequest(url, Verb.GET);
            long t0 = System.currentTimeMillis();
            try {
                response = service.execute(request);
                body = response.getBody();
                code = response.getCode();
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw new HttpCommunicationException("Error getting body:" + e.getMessage());
            }
            long t1 = System.currentTimeMillis();
            this.logger.debug("Request took: " + (t1 - t0) + " ms for: " + url);
            this.logger.debug("response code: {} / response body: {}", (Object)code, (Object)body);
            if (code == 200) {
                OAuth2AccessToken extendedAccessToken;
                this.logger.debug("Retrieve extended token from  {}", (Object)body);
                try {
                    extendedAccessToken = (OAuth2AccessToken)((DefaultApi20)this.configuration.getApi()).getAccessTokenExtractor().extract(response);
                }
                catch (OAuthException | IOException ex) {
                    throw new HttpCommunicationException("Error extracting token: " + ex.getMessage());
                }
                this.logger.debug("Extended token: {}", (Object)extendedAccessToken);
                this.addAccessTokenToProfile((UserProfile)profile, (Token)extendedAccessToken);
            } else {
                this.logger.error("Cannot get extended token: {} / {}", (Object)code, (Object)body);
            }
        }
        return Optional.of(profile);
    }

    protected String addExchangeToken(String url, OAuth2AccessToken accessToken) {
        FacebookProfileDefinition profileDefinition = (FacebookProfileDefinition)this.configuration.getProfileDefinition();
        FacebookConfiguration facebookConfiguration = (FacebookConfiguration)this.configuration;
        String computedUrl = url;
        if (facebookConfiguration.isUseAppsecretProof()) {
            computedUrl = profileDefinition.computeAppSecretProof(computedUrl, accessToken, facebookConfiguration);
        }
        return CommonHelper.addParameter((String)computedUrl, (String)EXCHANGE_TOKEN_PARAMETER, (String)accessToken.getAccessToken());
    }
}

