/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.github.scribejava.apis.TwitterApi;
import com.github.scribejava.core.builder.api.DefaultApi10a;
import java.util.Optional;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.HttpActionHelper;
import org.pac4j.oauth.client.OAuth10Client;
import org.pac4j.oauth.profile.twitter.TwitterProfileDefinition;

public class TwitterClient
extends OAuth10Client {
    private boolean alwaysConfirmAuthorization = false;
    private boolean includeEmail = false;

    public TwitterClient() {
    }

    public TwitterClient(String key, String secret) {
        this(key, secret, false);
    }

    public TwitterClient(String key, String secret, boolean includeEmail) {
        this.setKey(key);
        this.setSecret(secret);
        this.includeEmail = includeEmail;
    }

    @Override
    protected void internalInit() {
        this.configuration.setApi(this.getApi());
        this.configuration.setProfileDefinition(new TwitterProfileDefinition(this.includeEmail));
        this.configuration.setHasBeenCancelledFactory(ctx -> {
            Optional denied = ctx.getRequestParameter("denied");
            if (denied.isPresent()) {
                return true;
            }
            return false;
        });
        this.defaultLogoutActionBuilder((ctx, session, profile, targetUrl) -> Optional.of(HttpActionHelper.buildRedirectUrlAction((WebContext)ctx, (String)"https://twitter.com/logout")));
        super.internalInit();
    }

    protected DefaultApi10a getApi() {
        Object api = !this.alwaysConfirmAuthorization ? TwitterApi.Authenticate.instance() : TwitterApi.instance();
        return api;
    }

    public boolean isAlwaysConfirmAuthorization() {
        return this.alwaysConfirmAuthorization;
    }

    public void setAlwaysConfirmAuthorization(boolean alwaysConfirmAuthorization) {
        this.alwaysConfirmAuthorization = alwaysConfirmAuthorization;
    }

    public boolean isIncludeEmail() {
        return this.includeEmail;
    }

    public void setIncludeEmail(boolean includeEmail) {
        this.includeEmail = includeEmail;
    }
}

