/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.scribe.builder.api;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.extractors.TokenExtractor;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.utils.OAuthEncoder;
import java.util.Map;
import org.pac4j.scribe.extractors.OrcidJsonExtractor;

public class OrcidApi20
extends DefaultApi20 {
    private static final String AUTH_URL = "http://www.orcid.org/oauth/authorize";
    private static final String TOKEN_URL = "https://orcid.org/oauth/token";

    public String getAccessTokenEndpoint() {
        return TOKEN_URL;
    }

    public String getAuthorizationUrl(OAuthConfig oAuthConfig, Map<String, String> additionalParams) {
        return String.format("http://www.orcid.org/oauth/authorize?client_id=%s&scope=%s&response_type=%s&redirect_uri=%s#show_login", oAuthConfig.getApiKey(), oAuthConfig.getScope() != null ? OAuthEncoder.encode((String)oAuthConfig.getScope()) : "", "code", OAuthEncoder.encode((String)oAuthConfig.getCallback()));
    }

    protected String getAuthorizationBaseUrl() {
        return AUTH_URL;
    }

    public TokenExtractor<OAuth2AccessToken> getAccessTokenExtractor() {
        return OrcidJsonExtractor.instance();
    }

    public Verb getAccessTokenVerb() {
        return Verb.POST;
    }
}

