/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.google2;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.model.OAuth2AccessToken;
import java.util.List;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.core.profile.converter.DateConverter;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.converter.JsonConverter;
import org.pac4j.oauth.profile.definition.OAuth20ProfileDefinition;
import org.pac4j.oauth.profile.google2.Google2Email;
import org.pac4j.oauth.profile.google2.Google2Profile;

public class Google2ProfileDefinition
extends OAuth20ProfileDefinition<Google2Profile, OAuth20Configuration> {
    public static final String DISPLAY_NAME = "displayName";
    public static final String GIVEN_NAME = "name.givenName";
    public static final String FAMILY_NAME = "name.familyName";
    public static final String URL = "url";
    public static final String PICTURE = "image.url";
    public static final String LANGUAGE = "language";
    public static final String BIRTHDAY = "birthday";
    public static final String EMAILS = "emails";

    public Google2ProfileDefinition() {
        super(x -> new Google2Profile());
        this.primary(DISPLAY_NAME, (AttributeConverter)Converters.STRING);
        this.primary(GIVEN_NAME, (AttributeConverter)Converters.STRING);
        this.primary(FAMILY_NAME, (AttributeConverter)Converters.STRING);
        this.primary(URL, (AttributeConverter)Converters.URL);
        this.primary(PICTURE, (AttributeConverter)Converters.URL);
        this.primary(LANGUAGE, (AttributeConverter)Converters.LOCALE);
        this.primary(BIRTHDAY, (AttributeConverter)new DateConverter("yyyy-MM-dd"));
        this.primary(EMAILS, new JsonConverter<List<Google2Email>>(List.class, new TypeReference<List<Google2Email>>(){}));
    }

    @Override
    public String getProfileUrl(OAuth2AccessToken accessToken, OAuth20Configuration configuration) {
        return "https://www.googleapis.com/plus/v1/people/me";
    }

    @Override
    public Google2Profile extractUserProfile(String body) {
        Google2Profile profile = (Google2Profile)this.newProfile(new Object[0]);
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            profile.setId(ProfileHelper.sanitizeIdentifier((UserProfile)profile, (Object)JsonHelper.getElement(json, "id")));
            for (String attribute : this.getPrimaryAttributes()) {
                this.convertAndAdd(profile, AttributeLocation.PROFILE_ATTRIBUTE, attribute, JsonHelper.getElement(json, attribute));
            }
        }
        return profile;
    }
}

