/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.bitbucket;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.model.OAuth1Token;
import java.util.Arrays;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.oauth.config.OAuth10Configuration;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.bitbucket.BitbucketProfile;
import org.pac4j.oauth.profile.definition.OAuth10ProfileDefinition;

public class BitbucketProfileDefinition
extends OAuth10ProfileDefinition<BitbucketProfile> {
    public static final String LAST_NAME = "last_name";
    public static final String IS_TEAM = "is_team";
    public static final String AVATAR = "avatar";
    public static final String RESOURCE_URI = "resource_uri";

    public BitbucketProfileDefinition() {
        super(x -> new BitbucketProfile());
        Arrays.stream(new String[]{"username", LAST_NAME}).forEach(a -> this.primary((String)a, (AttributeConverter)Converters.STRING));
        this.primary(IS_TEAM, (AttributeConverter)Converters.BOOLEAN);
        this.primary(AVATAR, (AttributeConverter)Converters.URL);
        this.primary(RESOURCE_URI, (AttributeConverter)Converters.URL);
    }

    @Override
    public String getProfileUrl(OAuth1Token token, OAuth10Configuration configuration) {
        return "https://bitbucket.org/api/1.0/user/";
    }

    @Override
    public BitbucketProfile extractUserProfile(String body) {
        BitbucketProfile profile = (BitbucketProfile)this.newProfile(new Object[0]);
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null && (json = (JsonNode)JsonHelper.getElement(json, "user")) != null) {
            profile.setId(ProfileHelper.sanitizeIdentifier((UserProfile)profile, (Object)JsonHelper.getElement(json, "username")));
            for (String attribute : this.getPrimaryAttributes()) {
                this.convertAndAdd(profile, AttributeLocation.PROFILE_ATTRIBUTE, attribute, JsonHelper.getElement(json, attribute));
            }
        }
        return profile;
    }
}

