/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.linkedin2;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.pac4j.core.profile.AttributesDefinition;
import org.pac4j.oauth.profile.OAuth20Profile;
import org.pac4j.oauth.profile.OAuthAttributesDefinitions;
import org.pac4j.oauth.profile.linkedin2.LinkedIn2Location;
import org.pac4j.oauth.profile.linkedin2.LinkedIn2Position;

public class LinkedIn2Profile
extends OAuth20Profile {
    private static final long serialVersionUID = -2652388591255880018L;

    public String getOAuth10Id() {
        String url = this.getSiteStandardProfileRequest();
        return StringUtils.substringBetween((String)url, (String)"id=", (String)"&amp;authType=");
    }

    protected AttributesDefinition getAttributesDefinition() {
        return OAuthAttributesDefinitions.linkedin2Definition;
    }

    public String getFirstName() {
        return (String)this.getAttribute("first-name");
    }

    public String getFamilyName() {
        return (String)this.getAttribute("last-name");
    }

    public String getDisplayName() {
        return (String)this.getAttribute("formatted-name");
    }

    public String getLocation() {
        LinkedIn2Location location = (LinkedIn2Location)((Object)this.getAttribute("location"));
        return location.getName();
    }

    public String getEmail() {
        return (String)this.getAttribute("email-address");
    }

    public String getPictureUrl() {
        return (String)this.getAttribute("picture-url");
    }

    public String getProfileUrl() {
        return (String)this.getAttribute("public-profile-url");
    }

    public LinkedIn2Location getCompleteLocation() {
        return (LinkedIn2Location)((Object)this.getAttribute("location"));
    }

    public String getMaidenName() {
        return (String)this.getAttribute("maiden-name");
    }

    public String getHeadline() {
        return (String)this.getAttribute("headline");
    }

    public String getIndustry() {
        return (String)this.getAttribute("industry");
    }

    public Integer getNumConnections() {
        return (Integer)this.getAttribute("num-connections");
    }

    public String getSummary() {
        return (String)this.getAttribute("summary");
    }

    public String getSpecialties() {
        return (String)this.getAttribute("specialties");
    }

    public List<LinkedIn2Position> getPositions() {
        return (List)this.getAttribute("positions");
    }

    public String getSiteStandardProfileRequest() {
        return (String)this.getAttribute("site-standard-profile-request");
    }
}

