/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.ldap.test.tools;

import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import org.pac4j.core.util.TestsConstants;

public final class LdapServer
implements TestsConstants {
    public static final String BASE_DN = "dc=example,dc=com";
    public static final String BASE_PEOPLE_DN = "ou=people,dc=example,dc=com";
    public static final int PORT = 33389;
    public static final String CN = "cn";
    public static final String SN = "sn";
    public static final String ROLE = "role";
    public static final String ROLE1 = "role1";
    public static final String ROLE2 = "role2";
    private InMemoryDirectoryServer ds;

    public void start() {
        try {
            InMemoryDirectoryServerConfig dsConfig = new InMemoryDirectoryServerConfig(new String[]{BASE_DN});
            dsConfig.setSchema(null);
            dsConfig.setEnforceAttributeSyntaxCompliance(false);
            dsConfig.setEnforceSingleStructuralObjectClass(false);
            dsConfig.setListenerConfigs(new InMemoryListenerConfig[]{new InMemoryListenerConfig("myListener", null, 33389, null, null, null)});
            dsConfig.addAdditionalBindCredentials("cn=jle,ou=people,dc=example,dc=com", "password");
            dsConfig.addAdditionalBindCredentials("cn=jleleu,ou=people,dc=example,dc=com", "password");
            this.ds = new InMemoryDirectoryServer(dsConfig);
            this.ds.add(new String[]{"dn: dc=example,dc=com", "objectClass: organizationalUnit", "objectClass: top"});
            this.ds.add(new String[]{"dn: ou=people,dc=example,dc=com", "objectClass: organizationalUnit"});
            this.ds.add(new String[]{"dn: cn=jle,ou=people,dc=example,dc=com", "cn: jle", "sn: Jerome", "objectClass: person"});
            this.ds.add(new String[]{"dn: cn=jleleu,ou=people,dc=example,dc=com", "role: role1", "role: role2", "objectClass: person"});
            this.ds.startListening();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        this.ds.shutDown(true);
    }
}

