/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.ldap.test.tools;

import java.time.Duration;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.auth.AuthenticationHandler;
import org.ldaptive.auth.Authenticator;
import org.ldaptive.auth.DnResolver;
import org.ldaptive.auth.FormatDnResolver;
import org.ldaptive.auth.PooledBindAuthenticationHandler;
import org.ldaptive.pool.BlockingConnectionPool;
import org.ldaptive.pool.ConnectionPool;
import org.ldaptive.pool.IdlePruneStrategy;
import org.ldaptive.pool.PoolConfig;
import org.ldaptive.pool.PooledConnectionFactory;
import org.ldaptive.pool.PruneStrategy;
import org.ldaptive.pool.SearchValidator;
import org.ldaptive.pool.Validator;

public final class LdapClient {
    private final ConnectionFactory connectionFactory;
    private final Authenticator authenticator;

    public LdapClient() {
        FormatDnResolver dnResolver = new FormatDnResolver();
        dnResolver.setFormat("cn=%s,ou=people,dc=example,dc=com");
        ConnectionConfig connectionConfig = new ConnectionConfig();
        connectionConfig.setConnectTimeout(Duration.ofMillis(500L));
        connectionConfig.setResponseTimeout(Duration.ofMillis(1000L));
        connectionConfig.setLdapUrl("ldap://localhost:33389");
        this.connectionFactory = new DefaultConnectionFactory();
        ((DefaultConnectionFactory)this.connectionFactory).setConnectionConfig(connectionConfig);
        PoolConfig poolConfig = new PoolConfig();
        poolConfig.setMinPoolSize(1);
        poolConfig.setMaxPoolSize(2);
        poolConfig.setValidateOnCheckOut(true);
        poolConfig.setValidateOnCheckIn(true);
        poolConfig.setValidatePeriodically(false);
        SearchValidator searchValidator = new SearchValidator();
        IdlePruneStrategy pruneStrategy = new IdlePruneStrategy();
        BlockingConnectionPool connectionPool = new BlockingConnectionPool();
        connectionPool.setPoolConfig(poolConfig);
        connectionPool.setBlockWaitTime(Duration.ofMillis(1000L));
        connectionPool.setValidator((Validator)searchValidator);
        connectionPool.setPruneStrategy((PruneStrategy)pruneStrategy);
        connectionPool.setConnectionFactory((DefaultConnectionFactory)this.connectionFactory);
        connectionPool.initialize();
        PooledConnectionFactory pooledConnectionFactory = new PooledConnectionFactory();
        pooledConnectionFactory.setConnectionPool((ConnectionPool)connectionPool);
        PooledBindAuthenticationHandler handler = new PooledBindAuthenticationHandler();
        handler.setConnectionFactory(pooledConnectionFactory);
        this.authenticator = new Authenticator();
        this.authenticator.setDnResolver((DnResolver)dnResolver);
        this.authenticator.setAuthenticationHandler((AuthenticationHandler)handler);
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }
}

