/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.ldap.profile.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.auth.Authenticator;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.exception.BadCredentialsException;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.TestsConstants;
import org.pac4j.core.util.TestsHelper;
import org.pac4j.ldap.profile.LdapProfile;
import org.pac4j.ldap.profile.service.LdapProfileService;
import org.pac4j.ldap.test.tools.LdapClient;
import org.pac4j.ldap.test.tools.LdapServer;

public final class LdapProfileServiceTests
implements TestsConstants {
    private static final String LDAP_ID = "ldapid";
    private static final String LDAP_LINKED_ID = "ldapLinkedId";
    private static final String LDAP_PASS = "ldapPass";
    private static final String LDAP_PASS2 = "ldapPass2";
    private static final String LDAP_USER = "ldapUser";
    private static final String LDAP_USER2 = "ldapUser2";
    private LdapServer ldapServer;
    private Authenticator authenticator;
    private ConnectionFactory connectionFactory;

    @Before
    public void setUp() {
        this.ldapServer = new LdapServer();
        this.ldapServer.start();
        LdapClient client = new LdapClient();
        this.authenticator = client.getAuthenticator();
        this.connectionFactory = client.getConnectionFactory();
    }

    @After
    public void tearDown() {
        this.ldapServer.stop();
    }

    @Test
    public void testNullAuthenticator() {
        LdapProfileService ldapProfileService = new LdapProfileService(this.connectionFactory, null, "ou=people,dc=example,dc=com");
        TestsHelper.expectException(() -> ldapProfileService.init(), TechnicalException.class, (String)"ldapAuthenticator cannot be null");
    }

    @Test
    public void testNullConnectionFactory() {
        LdapProfileService ldapProfileService = new LdapProfileService(null, this.authenticator, "ou=people,dc=example,dc=com");
        TestsHelper.expectException(() -> ldapProfileService.init(), TechnicalException.class, (String)"connectionFactory cannot be null");
    }

    @Test
    public void testBlankUsersDn() {
        LdapProfileService ldapProfileService = new LdapProfileService(this.connectionFactory, this.authenticator, "");
        TestsHelper.expectException(() -> ldapProfileService.init(), TechnicalException.class, (String)"usersDn cannot be blank");
    }

    @Test(expected=BadCredentialsException.class)
    public void authentFailed() {
        LdapProfileService ldapProfileService = new LdapProfileService(this.connectionFactory, this.authenticator, "ou=people,dc=example,dc=com");
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("michael", "password");
        ldapProfileService.validate(credentials, null);
    }

    @Test
    public void authentSuccessNoAttribute() {
        LdapProfileService ldapProfileService = new LdapProfileService(this.connectionFactory, this.authenticator, "", "ou=people,dc=example,dc=com");
        ldapProfileService.setUsernameAttribute("cn");
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("jle", "password");
        ldapProfileService.validate(credentials, null);
        CommonProfile profile = credentials.getUserProfile();
        Assert.assertNotNull((Object)profile);
        Assert.assertTrue((boolean)(profile instanceof LdapProfile));
        LdapProfile ldapProfile = (LdapProfile)profile;
        Assert.assertEquals((Object)"jle", (Object)ldapProfile.getId());
        Assert.assertEquals((long)0L, (long)ldapProfile.getAttributes().size());
    }

    @Test
    public void authentSuccessSingleAttribute() {
        LdapProfileService ldapProfileService = new LdapProfileService(this.connectionFactory, this.authenticator, "sn", "ou=people,dc=example,dc=com");
        ldapProfileService.setUsernameAttribute("cn");
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("jle", "password");
        ldapProfileService.validate(credentials, null);
        CommonProfile profile = credentials.getUserProfile();
        Assert.assertNotNull((Object)profile);
        Assert.assertTrue((boolean)(profile instanceof LdapProfile));
        LdapProfile ldapProfile = (LdapProfile)profile;
        Assert.assertEquals((Object)"jle", (Object)ldapProfile.getId());
        Assert.assertEquals((long)1L, (long)ldapProfile.getAttributes().size());
        Assert.assertEquals((Object)"Jerome", (Object)ldapProfile.getAttribute("sn"));
    }

    @Test
    public void authentSuccessMultiAttribute() {
        LdapProfileService ldapProfileService = new LdapProfileService(this.connectionFactory, this.authenticator, "sn,role", "ou=people,dc=example,dc=com");
        ldapProfileService.setUsernameAttribute("cn");
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("jleleu", "password");
        ldapProfileService.validate(credentials, null);
        CommonProfile profile = credentials.getUserProfile();
        Assert.assertNotNull((Object)profile);
        Assert.assertTrue((boolean)(profile instanceof LdapProfile));
        LdapProfile ldapProfile = (LdapProfile)profile;
        Assert.assertEquals((Object)"jleleu", (Object)ldapProfile.getId());
        Assert.assertEquals((long)1L, (long)ldapProfile.getAttributes().size());
        Assert.assertNull((Object)ldapProfile.getAttribute("sn"));
        Collection attributes = (Collection)ldapProfile.getAttribute("role");
        Assert.assertEquals((long)2L, (long)attributes.size());
        Assert.assertTrue((boolean)attributes.contains("role1"));
        Assert.assertTrue((boolean)attributes.contains("role2"));
    }

    @Test
    public void testCreateUpdateFindDelete() {
        LdapProfile profile = new LdapProfile();
        profile.setId(LDAP_ID);
        profile.setLinkedId(LDAP_LINKED_ID);
        profile.addAttribute("username", (Object)LDAP_USER);
        LdapProfileService ldapProfileService = new LdapProfileService(this.connectionFactory, this.authenticator, "ou=people,dc=example,dc=com");
        ldapProfileService.setIdAttribute("cn");
        ldapProfileService.setUsernameAttribute("sn");
        ldapProfileService.setPasswordAttribute("userPassword");
        ldapProfileService.create((CommonProfile)profile, LDAP_PASS);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(LDAP_ID, LDAP_PASS);
        ldapProfileService.validate(credentials, null);
        CommonProfile profile1 = credentials.getUserProfile();
        Assert.assertNotNull((Object)profile1);
        List<Map<String, Object>> results = this.getData(ldapProfileService, LDAP_ID);
        Assert.assertEquals((long)1L, (long)results.size());
        Map<String, Object> result = results.get(0);
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertEquals((Object)LDAP_ID, (Object)result.get("cn"));
        Assert.assertEquals((Object)LDAP_LINKED_ID, (Object)result.get("linkedid"));
        Assert.assertNotNull((Object)result.get("serializedprofile"));
        Assert.assertEquals((Object)LDAP_USER, (Object)result.get("sn"));
        LdapProfile profile2 = (LdapProfile)ldapProfileService.findById(LDAP_ID);
        Assert.assertEquals((Object)LDAP_ID, (Object)profile2.getId());
        Assert.assertEquals((Object)LDAP_LINKED_ID, (Object)profile2.getLinkedId());
        Assert.assertEquals((Object)LDAP_USER, (Object)profile2.getUsername());
        Assert.assertEquals((long)1L, (long)profile2.getAttributes().size());
        profile.addAttribute("username", (Object)LDAP_USER2);
        ldapProfileService.update((CommonProfile)profile, LDAP_PASS2);
        List<Map<String, Object>> results2 = this.getData(ldapProfileService, LDAP_ID);
        Assert.assertEquals((long)1L, (long)results2.size());
        Map<String, Object> result2 = results2.get(0);
        Assert.assertEquals((long)4L, (long)result2.size());
        Assert.assertEquals((Object)LDAP_ID, (Object)result2.get("cn"));
        Assert.assertEquals((Object)LDAP_LINKED_ID, (Object)result2.get("linkedid"));
        Assert.assertNotNull((Object)result2.get("serializedprofile"));
        Assert.assertEquals((Object)LDAP_USER2, (Object)result2.get("sn"));
        UsernamePasswordCredentials credentials2 = new UsernamePasswordCredentials(LDAP_ID, LDAP_PASS2);
        ldapProfileService.validate(credentials2, null);
        CommonProfile profile3 = credentials.getUserProfile();
        Assert.assertNotNull((Object)profile3);
        ldapProfileService.remove((CommonProfile)profile);
        List<Map<String, Object>> results3 = this.getData(ldapProfileService, LDAP_ID);
        Assert.assertEquals((long)0L, (long)results3.size());
    }

    private List<Map<String, Object>> getData(LdapProfileService ldapProfileService, String id) {
        return ldapProfileService.read(Arrays.asList("cn", "sn", "id", "username", "linkedid", "password", "serializedprofile"), "cn", id);
    }
}

