/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.kerberos.credentials;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import lombok.Generated;
import org.pac4j.core.credentials.Credentials;

public class KerberosCredentials
extends Credentials {
    private byte[] kerberosTicket;
    private static final long serialVersionUID = -4264156105410684508L;

    public KerberosCredentials(byte[] kerberosTicket) {
        this.kerberosTicket = (byte[])kerberosTicket.clone();
    }

    public String getKerberosTicketAsString() {
        return this.getTicketAsString(this.kerberosTicket);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        KerberosCredentials that = (KerberosCredentials)((Object)o);
        return !(this.kerberosTicket == null ? that.kerberosTicket != null : !this.getTicketAsString(this.kerberosTicket).equals(this.getTicketAsString(that.kerberosTicket)));
    }

    public int hashCode() {
        return this.kerberosTicket != null ? this.getTicketAsString(this.kerberosTicket).hashCode() : 0;
    }

    private String getTicketAsString(byte[] kerberosTicket) {
        return new String(kerberosTicket, StandardCharsets.UTF_8);
    }

    public byte[] getKerberosTicket() {
        return (byte[])this.kerberosTicket.clone();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "KerberosCredentials(kerberosTicket=" + Arrays.toString(this.kerberosTicket) + ")";
    }
}

