/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.kerberos.client.indirect;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import lombok.Generated;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpActionHelper;
import org.pac4j.kerberos.credentials.extractor.KerberosExtractor;

public class IndirectKerberosClient
extends IndirectClient {
    public IndirectKerberosClient() {
    }

    public IndirectKerberosClient(Authenticator authenticator) {
        this.setAuthenticatorIfUndefined(authenticator);
    }

    public IndirectKerberosClient(Authenticator authenticator, ProfileCreator profileCreator) {
        this.setAuthenticatorIfUndefined(authenticator);
        this.setProfileCreatorIfUndefined(profileCreator);
    }

    protected void internalInit(boolean forceReinit) {
        this.setRedirectionActionBuilderIfUndefined(ctx -> {
            WebContext webContext = ctx.webContext();
            return Optional.of(HttpActionHelper.buildRedirectUrlAction((WebContext)webContext, (String)this.computeFinalCallbackUrl(webContext)));
        });
        this.setCredentialsExtractorIfUndefined(new KerberosExtractor());
    }

    public Optional<Credentials> getCredentials(CallContext ctx) {
        this.init();
        CommonHelper.assertNotNull((String)"credentialsExtractor", (Object)this.getCredentialsExtractor());
        WebContext webContext = ctx.webContext();
        webContext.setResponseHeader("WWW-Authenticate", "Negotiate");
        try {
            Optional credentials = this.getCredentialsExtractor().extract(ctx);
            this.logger.debug("kerberos credentials : {}", (Object)credentials);
            if (credentials.isEmpty()) {
                throw HttpActionHelper.buildUnauthenticatedAction((WebContext)webContext);
            }
            return credentials;
        }
        catch (CredentialsException e) {
            throw HttpActionHelper.buildUnauthenticatedAction((WebContext)webContext);
        }
    }

    protected Optional<Credentials> internalValidateCredentials(CallContext ctx, Credentials credentials) {
        CommonHelper.assertNotNull((String)"authenticator", (Object)this.getAuthenticator());
        WebContext webContext = ctx.webContext();
        webContext.setResponseHeader("WWW-Authenticate", "Negotiate");
        try {
            return this.getAuthenticator().validate(ctx, credentials);
        }
        catch (CredentialsException e) {
            throw HttpActionHelper.buildUnauthenticatedAction((WebContext)webContext);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "IndirectKerberosClient(super=" + super.toString() + ")";
    }
}

