/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.kerberos.credentials.extractor;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.kerberos.credentials.KerberosCredentials;

public class KerberosExtractor
implements CredentialsExtractor<KerberosCredentials> {
    public KerberosCredentials extract(WebContext context) {
        String header = context.getRequestHeader("Authorization");
        if (header == null) {
            return null;
        }
        if (!header.startsWith("Negotiate ") && !header.startsWith("Kerberos ")) {
            return null;
        }
        byte[] base64Token = header.substring(header.indexOf(" ") + 1).getBytes(StandardCharsets.UTF_8);
        byte[] kerberosTicket = Base64.getDecoder().decode(base64Token);
        return new KerberosCredentials(kerberosTicket);
    }
}

