/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.kerberos.client.indirect;

import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.redirect.RedirectAction;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.kerberos.credentials.KerberosCredentials;
import org.pac4j.kerberos.credentials.extractor.KerberosExtractor;
import org.pac4j.kerberos.profile.KerberosProfile;

public class IndirectKerberosClient
extends IndirectClient<KerberosCredentials, KerberosProfile> {
    public IndirectKerberosClient() {
    }

    public IndirectKerberosClient(Authenticator authenticator) {
        this.defaultAuthenticator(authenticator);
    }

    public IndirectKerberosClient(Authenticator authenticator, ProfileCreator<KerberosCredentials, KerberosProfile> profileCreator) {
        this.defaultAuthenticator(authenticator);
        this.defaultProfileCreator(profileCreator);
    }

    protected void clientInit() {
        this.defaultRedirectActionBuilder(webContext -> RedirectAction.redirect((String)this.computeFinalCallbackUrl(webContext)));
        this.defaultCredentialsExtractor(new KerberosExtractor());
    }

    protected KerberosCredentials retrieveCredentials(WebContext context) {
        KerberosCredentials credentials;
        CommonHelper.assertNotNull((String)"credentialsExtractor", (Object)this.getCredentialsExtractor());
        CommonHelper.assertNotNull((String)"authenticator", (Object)this.getAuthenticator());
        context.setResponseHeader("WWW-Authenticate", "Negotiate");
        try {
            credentials = (KerberosCredentials)this.getCredentialsExtractor().extract(context);
            this.logger.debug("kerberos credentials : {}", (Object)credentials);
            if (credentials == null) {
                throw HttpAction.unauthorized((WebContext)context);
            }
            this.getAuthenticator().validate((Credentials)credentials, context);
        }
        catch (CredentialsException e) {
            throw HttpAction.unauthorized((WebContext)context);
        }
        return credentials;
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"callbackUrl", this.callbackUrl, "name", this.getName(), "extractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator()});
    }
}

