/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.client.direct;

import org.pac4j.core.client.DirectClient;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.credentials.extractor.FormExtractor;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.util.CommonHelper;

public class DirectFormClient
extends DirectClient {
    private String usernameParameter = "username";
    private String passwordParameter = "password";

    public DirectFormClient() {
    }

    public DirectFormClient(Authenticator usernamePasswordAuthenticator) {
        this.defaultAuthenticator(usernamePasswordAuthenticator);
    }

    public DirectFormClient(String usernameParameter, String passwordParameter, Authenticator usernamePasswordAuthenticator) {
        this.usernameParameter = usernameParameter;
        this.passwordParameter = passwordParameter;
        this.defaultAuthenticator(usernamePasswordAuthenticator);
    }

    public DirectFormClient(Authenticator usernamePasswordAuthenticator, ProfileCreator profileCreator) {
        this.defaultAuthenticator(usernamePasswordAuthenticator);
        this.defaultProfileCreator(profileCreator);
    }

    protected void internalInit() {
        CommonHelper.assertNotBlank((String)"usernameParameter", (String)this.usernameParameter);
        CommonHelper.assertNotBlank((String)"passwordParameter", (String)this.passwordParameter);
        this.defaultCredentialsExtractor((CredentialsExtractor)new FormExtractor(this.usernameParameter, this.passwordParameter));
    }

    public String getUsernameParameter() {
        return this.usernameParameter;
    }

    public void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    public String getPasswordParameter() {
        return this.passwordParameter;
    }

    public void setPasswordParameter(String passwordParameter) {
        this.passwordParameter = passwordParameter;
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"name", this.getName(), "usernameParameter", this.usernameParameter, "passwordParameter", this.passwordParameter, "extractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator()});
    }
}

