/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials.extractor;

import org.pac4j.core.context.WebContext;
import org.pac4j.http.credentials.UsernamePasswordCredentials;
import org.pac4j.http.credentials.extractor.Extractor;

public class FormExtractor
implements Extractor<UsernamePasswordCredentials> {
    private final String usernameParameter;
    private final String passwordParameter;
    private final String clientName;

    public FormExtractor(String usernameParameter, String passwordParameter, String clientName) {
        this.usernameParameter = usernameParameter;
        this.passwordParameter = passwordParameter;
        this.clientName = clientName;
    }

    @Override
    public UsernamePasswordCredentials extract(WebContext context) {
        String username = context.getRequestParameter(this.usernameParameter);
        String password = context.getRequestParameter(this.passwordParameter);
        if (username == null || password == null) {
            return null;
        }
        return new UsernamePasswordCredentials(username, password, this.clientName);
    }

    public String getUsernameParameter() {
        return this.usernameParameter;
    }

    public String getPasswordParameter() {
        return this.passwordParameter;
    }
}

