/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials.authenticator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.http.credentials.HttpCredentials;
import org.pac4j.http.credentials.authenticator.Authenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalCachingAuthenticator<T extends HttpCredentials>
implements Authenticator<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LoadingCache<T, UserProfile> cache;
    private final UserProfileCacheLoader<T> cacheLoader;

    public LocalCachingAuthenticator(Authenticator<T> delegate, long cacheSize, long timeout, TimeUnit timeUnit) {
        this.cacheLoader = new UserProfileCacheLoader<T>(delegate);
        this.cache = CacheBuilder.newBuilder().maximumSize(cacheSize).expireAfterWrite(timeout, timeUnit).build(this.cacheLoader);
    }

    @Override
    public void validate(T credentials) {
        try {
            UserProfile profile = (UserProfile)this.cache.get(credentials);
            ((HttpCredentials)((Object)credentials)).setUserProfile(profile);
            this.logger.debug("Found cached credential. Using cached profile {}...", (Object)profile);
        }
        catch (Exception e) {
            throw new CredentialsException((Throwable)e);
        }
    }

    public void setDelegate(Authenticator<T> delegate) {
        this.cacheLoader.setDelegate(delegate);
    }

    public Authenticator<T> getDelegate() {
        return this.cacheLoader.getDelegate();
    }

    public void removeFromCache(T credentials) {
        this.cache.invalidate(credentials);
    }

    public boolean isCached(T credentials) {
        return this.cache.getIfPresent(credentials) != null;
    }

    public boolean clearCache() {
        this.cache.invalidateAll();
        return this.cache.asMap().isEmpty();
    }

    private static class UserProfileCacheLoader<T extends HttpCredentials>
    extends CacheLoader<T, UserProfile> {
        private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        private Authenticator<T> delegate;

        public UserProfileCacheLoader(Authenticator<T> delegate) {
            this.delegate = delegate;
        }

        public UserProfile load(T credentials) throws Exception {
            this.logger.debug("Delegating authentication to {}...", this.delegate);
            this.delegate.validate(credentials);
            UserProfile profile = ((HttpCredentials)((Object)credentials)).getUserProfile();
            this.logger.debug("Cached authentication result");
            return profile;
        }

        public Authenticator<T> getDelegate() {
            return this.delegate;
        }

        public void setDelegate(Authenticator<T> delegate) {
            this.delegate = delegate;
        }
    }
}

