/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.client.direct;

import org.pac4j.core.client.ClientType;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.client.direct.DirectHttpClient;
import org.pac4j.http.credentials.TokenCredentials;
import org.pac4j.http.credentials.authenticator.TokenAuthenticator;
import org.pac4j.http.credentials.extractor.HeaderExtractor;
import org.pac4j.http.profile.creator.ProfileCreator;

public class HeaderClient
extends DirectHttpClient<TokenCredentials> {
    private String headerName = "";
    private String prefixHeader = "";

    public HeaderClient() {
    }

    public HeaderClient(TokenAuthenticator tokenAuthenticator) {
        this.setAuthenticator(tokenAuthenticator);
    }

    public HeaderClient(TokenAuthenticator tokenAuthenticator, ProfileCreator profileCreator) {
        this.setAuthenticator(tokenAuthenticator);
        this.setProfileCreator(profileCreator);
    }

    @Override
    protected void internalInit(WebContext context) {
        this.extractor = new HeaderExtractor(this.headerName, this.prefixHeader, this.getName());
        super.internalInit(context);
        CommonHelper.assertNotBlank((String)"headerName", (String)this.headerName);
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public String getPrefixHeader() {
        return this.prefixHeader;
    }

    public void setPrefixHeader(String prefixHeader) {
        this.prefixHeader = prefixHeader;
    }

    protected HeaderClient newClient() {
        HeaderClient newClient = new HeaderClient();
        newClient.setHeaderName(this.headerName);
        newClient.setPrefixHeader(this.prefixHeader);
        return newClient;
    }

    public ClientType getClientType() {
        return ClientType.HEADER_BASED;
    }
}

