package org.pac4j.config.client;

/**
 * Properties constants for the {@link PropertiesConfigFactory}.
 *
 * @author Jerome Leleu
 * @since 2.0.0
 */
public interface PropertiesConstants {
    /** Constant <code>CLIENT_NAME="client.name"</code> */
    String CLIENT_NAME = "client.name";

    /** Constant <code>FACEBOOK_ID="facebook.id"</code> */
    String FACEBOOK_ID = "facebook.id";
    /** Constant <code>FACEBOOK_SECRET="facebook.secret"</code> */
    String FACEBOOK_SECRET = "facebook.secret";
    /** Constant <code>FACEBOOK_SCOPE="facebook.scope"</code> */
    String FACEBOOK_SCOPE = "facebook.scope";
    /** Constant <code>FACEBOOK_FIELDS="facebook.fields"</code> */
    String FACEBOOK_FIELDS = "facebook.fields";

    /** Constant <code>TWITTER_ID="twitter.id"</code> */
    String TWITTER_ID = "twitter.id";
    /** Constant <code>TWITTER_SECRET="twitter.secret"</code> */
    String TWITTER_SECRET = "twitter.secret";

    /** Constant <code>GITHUB_ID="github.id"</code> */
    String GITHUB_ID = "github.id";
    /** Constant <code>GITHUB_SECRET="github.secret"</code> */
    String GITHUB_SECRET = "github.secret";

    /** Constant <code>DROPBOX_ID="dropbox.id"</code> */
    String DROPBOX_ID = "dropbox.id";
    /** Constant <code>DROPBOX_SECRET="dropbox.secret"</code> */
    String DROPBOX_SECRET = "dropbox.secret";

    /** Constant <code>WINDOWSLIVE_ID="windowslive.id"</code> */
    String WINDOWSLIVE_ID = "windowslive.id";
    /** Constant <code>WINDOWSLIVE_SECRET="windowslive.secret"</code> */
    String WINDOWSLIVE_SECRET = "windowslive.secret";

    /** Constant <code>YAHOO_ID="yahoo.id"</code> */
    String YAHOO_ID = "yahoo.id";
    /** Constant <code>YAHOO_SECRET="yahoo.secret"</code> */
    String YAHOO_SECRET = "yahoo.secret";

    /** Constant <code>LINKEDIN_ID="linkedin.id"</code> */
    String LINKEDIN_ID = "linkedin.id";
    /** Constant <code>LINKEDIN_SECRET="linkedin.secret"</code> */
    String LINKEDIN_SECRET = "linkedin.secret";
    /** Constant <code>LINKEDIN_FIELDS="linkedin.fields"</code> */
    String LINKEDIN_FIELDS = "linkedin.fields";
    /** Constant <code>LINKEDIN_SCOPE="linkedin.scope"</code> */
    String LINKEDIN_SCOPE = "linkedin.scope";

    /** Constant <code>FOURSQUARE_ID="foursquare.id"</code> */
    String FOURSQUARE_ID = "foursquare.id";
    /** Constant <code>FOURSQUARE_SECRET="foursquare.secret"</code> */
    String FOURSQUARE_SECRET = "foursquare.secret";

    /** Constant <code>GOOGLE_ID="google.id"</code> */
    String GOOGLE_ID = "google.id";
    /** Constant <code>GOOGLE_SECRET="google.secret"</code> */
    String GOOGLE_SECRET = "google.secret";
    /** Constant <code>GOOGLE_SCOPE="google.scope"</code> */
    String GOOGLE_SCOPE = "google.scope";

    /** Constant <code>OAUTH2_ID="oauth2.id"</code> */
    String OAUTH2_ID = "oauth2.id";
    /** Constant <code>OAUTH2_SECRET="oauth2.secret"</code> */
    String OAUTH2_SECRET = "oauth2.secret";
    /** Constant <code>OAUTH2_AUTH_URL="oauth2.authUrl"</code> */
    String OAUTH2_AUTH_URL = "oauth2.authUrl";
    /** Constant <code>OAUTH2_TOKEN_URL="oauth2.tokenUrl"</code> */
    String OAUTH2_TOKEN_URL = "oauth2.tokenUrl";
    /** Constant <code>OAUTH2_PROFILE_URL="oauth2.profileUrl"</code> */
    String OAUTH2_PROFILE_URL = "oauth2.profileUrl";
    /** Constant <code>OAUTH2_PROFILE_PATH="oauth2.profilePath"</code> */
    String OAUTH2_PROFILE_PATH = "oauth2.profilePath";
    /** Constant <code>OAUTH2_PROFILE_ID="oauth2.profileId"</code> */
    String OAUTH2_PROFILE_ID = "oauth2.profileId";
    /** Constant <code>OAUTH2_SCOPE="oauth2.scope"</code> */
    String OAUTH2_SCOPE = "oauth2.scope";
    /** Constant <code>OAUTH2_WITH_STATE="oauth2.withState"</code> */
    String OAUTH2_WITH_STATE = "oauth2.withState";
    /** Constant <code>OAUTH2_CLIENT_AUTHENTICATION_METHOD="oauth2.clientAuthenticationMethod"</code> */
    String OAUTH2_CLIENT_AUTHENTICATION_METHOD = "oauth2.clientAuthenticationMethod";

    /** Constant <code>AUTHENTICATOR_TEST_TOKEN="testToken"</code> */
    String AUTHENTICATOR_TEST_TOKEN = "testToken";
    /** Constant <code>AUTHENTICATOR_TEST_USERNAME_PASSWORD="testUsernamePassword"</code> */
    String AUTHENTICATOR_TEST_USERNAME_PASSWORD = "testUsernamePassword";

    /** Constant <code>SAML_KEYSTORE_PASSWORD="saml.keystorePassword"</code> */
    String SAML_KEYSTORE_PASSWORD = "saml.keystorePassword";
    /** Constant <code>SAML_PRIVATE_KEY_PASSWORD="saml.privateKeyPassword"</code> */
    String SAML_PRIVATE_KEY_PASSWORD = "saml.privateKeyPassword";
    /** Constant <code>SAML_KEYSTORE_PATH="saml.keystorePath"</code> */
    String SAML_KEYSTORE_PATH = "saml.keystorePath";
    /** Constant <code>SAML_IDENTITY_PROVIDER_METADATA_PATH="saml.identityProviderMetadataPath"</code> */
    String SAML_IDENTITY_PROVIDER_METADATA_PATH = "saml.identityProviderMetadataPath";
    /** Constant <code>SAML_MAXIMUM_AUTHENTICATION_LIFETIME="saml.maximumAuthenticationLifetime"</code> */
    String SAML_MAXIMUM_AUTHENTICATION_LIFETIME = "saml.maximumAuthenticationLifetime";
    /** Constant <code>SAML_SERVICE_PROVIDER_ENTITY_ID="saml.serviceProviderEntityId"</code> */
    String SAML_SERVICE_PROVIDER_ENTITY_ID = "saml.serviceProviderEntityId";
    /** Constant <code>SAML_SERVICE_PROVIDER_METADATA_PATH="saml.serviceProviderMetadataPath"</code> */
    String SAML_SERVICE_PROVIDER_METADATA_PATH = "saml.serviceProviderMetadataPath";
    /** Constant <code>SAML_AUTHN_REQUEST_BINDING_TYPE="saml.authnRequestBindingType"</code> */
    String SAML_AUTHN_REQUEST_BINDING_TYPE = "saml.authnRequestBindingType";
    /** Constant <code>SAML_KEYSTORE_ALIAS="saml.keystoreAlias"</code> */
    String SAML_KEYSTORE_ALIAS = "saml.keystoreAlias";
    /** Constant <code>SAML_ACCEPTED_SKEW="saml.acceptedSkew"</code> */
    String SAML_ACCEPTED_SKEW = "saml.acceptedSkew";
    /** Constant <code>SAML_ASSERTION_CONSUMER_SERVICE_INDEX="saml.assertionConsumerServiceIndex"</code> */
    String SAML_ASSERTION_CONSUMER_SERVICE_INDEX = "saml.assertionConsumerServiceIndex";
    /** Constant <code>SAML_FORCE_AUTH="saml.forceAuth"</code> */
    String SAML_FORCE_AUTH = "saml.forceAuth";
    /** Constant <code>SAML_ATTRIBUTE_AS_ID="saml.attributeAsId"</code> */
    String SAML_ATTRIBUTE_AS_ID = "saml.attributeAsId";
    /** Constant <code>SAML_AUTHN_CONTEXT_CLASS_REFS="saml.authnContextClassRefs"</code> */
    String SAML_AUTHN_CONTEXT_CLASS_REFS = "saml.authnContextClassRefs";
    /** Constant <code>SAML_COMPARISON_TYPE="saml.comparisonType"</code> */
    String SAML_COMPARISON_TYPE = "saml.comparisonType";
    /** Constant <code>SAML_ISSUER_FORMAT="saml.issuerFormat"</code> */
    String SAML_ISSUER_FORMAT = "saml.issuerFormat";
    /** Constant <code>SAML_AUTHN_REQUEST_SIGNED="saml.authnRequestSigned"</code> */
    String SAML_AUTHN_REQUEST_SIGNED = "saml.authnRequestSigned";
    /** Constant <code>SAML_MAPPED_ATTRIBUTES="saml.mappedAttributes"</code> */
    String SAML_MAPPED_ATTRIBUTES = "saml.mappedAttributes";
    /** Constant <code>SAML_NAMEID_ATTRIBUTE="saml.nameIdAttribute"</code> */
    String SAML_NAMEID_ATTRIBUTE = "saml.nameIdAttribute";
    /** Constant <code>SAML_PASSIVE="saml.passive"</code> */
    String SAML_PASSIVE = "saml.passive";
    /** Constant <code>SAML_RESPONSE_BINDING_TYPE="saml.responseBindingType"</code> */
    String SAML_RESPONSE_BINDING_TYPE = "saml.responseBindingType";
    /** Constant <code>SAML_WANTS_ASSERTIONS_SIGNED="saml.wantsAssertionsSigned"</code> */
    String SAML_WANTS_ASSERTIONS_SIGNED = "saml.wantsAssertionsSigned";
    /** Constant <code>SAML_WANTS_RESPONSES_SIGNED="saml.wantsResponsesSigned"</code> */
    String SAML_WANTS_RESPONSES_SIGNED = "saml.wantsResponsesSigned";

    /** Constant <code>CAS_LOGIN_URL="cas.loginUrl"</code> */
    String CAS_LOGIN_URL = "cas.loginUrl";
    /** Constant <code>CAS_PROTOCOL="cas.protocol"</code> */
    String CAS_PROTOCOL = "cas.protocol";

    /** Constant <code>OIDC_TYPE="oidc.type"</code> */
    String OIDC_TYPE = "oidc.type";
    /** Constant <code>OIDC_GOOGLE_TYPE="google"</code> */
    String OIDC_GOOGLE_TYPE = "google";
    /** Constant <code>OIDC_AZURE_TYPE="azure"</code> */
    String OIDC_AZURE_TYPE = "azure";
    /** Constant <code>OIDC_AZURE_TENANT="oidc.azure.tenant"</code> */
    String OIDC_AZURE_TENANT = "oidc.azure.tenant";
    /** Constant <code>OIDC_ID="oidc.id"</code> */
    String OIDC_ID = "oidc.id";
    /** Constant <code>OIDC_SECRET="oidc.secret"</code> */
    String OIDC_SECRET = "oidc.secret";
    /** Constant <code>OIDC_SCOPE="oidc.scope"</code> */
    String OIDC_SCOPE = "oidc.scope";
    /** Constant <code>OIDC_DISCOVERY_URI="oidc.discoveryUri"</code> */
    String OIDC_DISCOVERY_URI = "oidc.discoveryUri";
    /** Constant <code>OIDC_USE_NONCE="oidc.useNonce"</code> */
    String OIDC_USE_NONCE = "oidc.useNonce";
    /** Constant <code>OIDC_PREFERRED_JWS_ALGORITHM="oidc.preferredJwsAlgorithm"</code> */
    String OIDC_PREFERRED_JWS_ALGORITHM = "oidc.preferredJwsAlgorithm";
    /** Constant <code>OIDC_MAX_CLOCK_SKEW="oidc.maxClockSkew"</code> */
    String OIDC_MAX_CLOCK_SKEW = "oidc.maxClockSkew";
    /** Constant <code>OIDC_CLIENT_AUTHENTICATION_METHOD="oidc.clientAuthenticationMethod"</code> */
    String OIDC_CLIENT_AUTHENTICATION_METHOD = "oidc.clientAuthenticationMethod";
    /** Constant <code>OIDC_CUSTOM_PARAM_KEY="oidc.customParamKey"</code> */
    String OIDC_CUSTOM_PARAM_KEY = "oidc.customParamKey";
    /** Constant <code>OIDC_CUSTOM_PARAM_VALUE="oidc.customParamValue"</code> */
    String OIDC_CUSTOM_PARAM_VALUE = "oidc.customParamValue";
    /** Constant <code>OIDC_RESPONSE_TYPE="oidc.responseType"</code> */
    String OIDC_RESPONSE_TYPE = "oidc.responseType";
    /** Constant <code>OIDC_RESPONSE_MODE="oidc.responseMode"</code> */
    String OIDC_RESPONSE_MODE = "oidc.responseMode";

    /** Constant <code>FORMCLIENT_AUTHENTICATOR="formClient.authenticator"</code> */
    String FORMCLIENT_AUTHENTICATOR = "formClient.authenticator";
    /** Constant <code>FORMCLIENT_LOGIN_URL="formClient.loginUrl"</code> */
    String FORMCLIENT_LOGIN_URL = "formClient.loginUrl";
    /** Constant <code>FORMCLIENT_USERNAME_PARAMETER="formClient.usernameParameter"</code> */
    String FORMCLIENT_USERNAME_PARAMETER = "formClient.usernameParameter";
    /** Constant <code>FORMCLIENT_PASSWORD_PARAMETER="formClient.passwordParameter"</code> */
    String FORMCLIENT_PASSWORD_PARAMETER = "formClient.passwordParameter";

    /** Constant <code>INDIRECTBASICAUTH_AUTHENTICATOR="indirectBasicAuth.authenticator"</code> */
    String INDIRECTBASICAUTH_AUTHENTICATOR = "indirectBasicAuth.authenticator";
    /** Constant <code>INDIRECTBASICAUTH_REALM_NAME="indirectBasicAuth.realName"</code> */
    String INDIRECTBASICAUTH_REALM_NAME = "indirectBasicAuth.realName";

    /** Constant <code>ANONYMOUS="anonymous"</code> */
    String ANONYMOUS = "anonymous";

    /** Constant <code>DIRECTBASICAUTH_AUTHENTICATOR="directBasicAuth.authenticator"</code> */
    String DIRECTBASICAUTH_AUTHENTICATOR = "directBasicAuth.authenticator";

    /** Constant <code>LDAP_TYPE="ldap.type"</code> */
    String LDAP_TYPE = "ldap.type";
    /** Constant <code>LDAP_DN_FORMAT="ldap.dnFormat"</code> */
    String LDAP_DN_FORMAT = "ldap.dnFormat";
    /** Constant <code>LDAP_ATTRIBUTES="ldap.principalAttributes"</code> */
    String LDAP_ATTRIBUTES = "ldap.principalAttributes";
    /** Constant <code>LDAP_PRINCIPAL_ATTRIBUTE_ID="ldap.principalAttributeId"</code> */
    String LDAP_PRINCIPAL_ATTRIBUTE_ID = "ldap.principalAttributeId";
    /** Constant <code>LDAP_PRINCIPAL_ATTRIBUTE_PASSWORD="ldap.principalAttributePassword"</code> */
    String LDAP_PRINCIPAL_ATTRIBUTE_PASSWORD = "ldap.principalAttributePassword";
    /** Constant <code>LDAP_SUBTREE_SEARCH="ldap.subtreeSearch"</code> */
    String LDAP_SUBTREE_SEARCH = "ldap.subtreeSearch";
    /** Constant <code>LDAP_USERS_DN="ldap.usersDn"</code> */
    String LDAP_USERS_DN = "ldap.usersDn";
    /** Constant <code>LDAP_USER_FILTER="ldap.userFilter"</code> */
    String LDAP_USER_FILTER = "ldap.userFilter";
    /** Constant <code>LDAP_ENHANCE_WITH_ENTRY_RESOLVER="ldap.enhanceWithEntryResolver"</code> */
    String LDAP_ENHANCE_WITH_ENTRY_RESOLVER = "ldap.enhanceWithEntryResolver";
    /** Constant <code>LDAP_ENABLE_PASSWORD_POLICY="ldap.enablePasswordPolicy"</code> */
    String LDAP_ENABLE_PASSWORD_POLICY = "ldap.enablePasswordPolicy";
    /** Constant <code>LDAP_TRUST_CERTIFICATES="ldap.trustCertificates"</code> */
    String LDAP_TRUST_CERTIFICATES = "ldap.trustCertificates";
    /** Constant <code>LDAP_KEYSTORE="ldap.keystore"</code> */
    String LDAP_KEYSTORE = "ldap.keystore";
    /** Constant <code>LDAP_KEYSTORE_PASSWORD="ldap.keystorePassword"</code> */
    String LDAP_KEYSTORE_PASSWORD = "ldap.keystorePassword";
    /** Constant <code>LDAP_KEYSTORE_TYPE="ldap.keystoreType"</code> */
    String LDAP_KEYSTORE_TYPE = "ldap.keystoreType";
    /** Constant <code>LDAP_MIN_POOL_SIZE="ldap.minPoolSize"</code> */
    String LDAP_MIN_POOL_SIZE = "ldap.minPoolSize";
    /** Constant <code>LDAP_MAX_POOL_SIZE="ldap.maxPoolSize"</code> */
    String LDAP_MAX_POOL_SIZE = "ldap.maxPoolSize";
    /** Constant <code>LDAP_POOL_PASSIVATOR="ldap.poolPassivator"</code> */
    String LDAP_POOL_PASSIVATOR = "ldap.poolPassivator";
    /** Constant <code>LDAP_VALIDATE_ON_CHECKOUT="ldap.validateOnCheckout"</code> */
    String LDAP_VALIDATE_ON_CHECKOUT = "ldap.validateOnCheckout";
    /** Constant <code>LDAP_VALIDATE_PERIODICALLY="ldap.validatePeriodically"</code> */
    String LDAP_VALIDATE_PERIODICALLY = "ldap.validatePeriodically";
    /** Constant <code>LDAP_VALIDATE_PERIOD="ldap.validatePeriod"</code> */
    String LDAP_VALIDATE_PERIOD = "ldap.validatePeriod";
    /** Constant <code>LDAP_FAIL_FAST="ldap.failFast"</code> */
    String LDAP_FAIL_FAST = "ldap.failFast";
    /** Constant <code>LDAP_IDLE_TIME="ldap.idleTime"</code> */
    String LDAP_IDLE_TIME = "ldap.idleTime";
    /** Constant <code>LDAP_PRUNE_PERIOD="ldap.prunePeriod"</code> */
    String LDAP_PRUNE_PERIOD = "ldap.prunePeriod";
    /** Constant <code>LDAP_BLOCK_WAIT_TIME="ldap.blockWaitTime"</code> */
    String LDAP_BLOCK_WAIT_TIME = "ldap.blockWaitTime";
    /** Constant <code>LDAP_URL="ldap.url"</code> */
    String LDAP_URL = "ldap.url";
    /** Constant <code>LDAP_USE_START_TLS="ldap.useStartTls"</code> */
    String LDAP_USE_START_TLS = "ldap.useStartTls";
    /** Constant <code>LDAP_CONNECT_TIMEOUT="ldap.connectTimeout"</code> */
    String LDAP_CONNECT_TIMEOUT = "ldap.connectTimeout";
    /** Constant <code>LDAP_ALLOW_MULTIPLE_DNS="ldap.allowMultipleDns"</code> */
    String LDAP_ALLOW_MULTIPLE_DNS = "ldap.allowMultipleDns";
    /** Constant <code>LDAP_BIND_DN="ldap.bindDn"</code> */
    String LDAP_BIND_DN = "ldap.bindDn";
    /** Constant <code>LDAP_BIND_CREDENTIAL="ldap.bindCredential"</code> */
    String LDAP_BIND_CREDENTIAL = "ldap.bindCredential";
    /** Constant <code>LDAP_SASL_REALM="ldap.saslRealm"</code> */
    String LDAP_SASL_REALM = "ldap.saslRealm";
    /** Constant <code>LDAP_SASL_MECHANISM="ldap.saslMechanism"</code> */
    String LDAP_SASL_MECHANISM = "ldap.saslMechanism";
    /** Constant <code>LDAP_SASL_AUTHORIZATION_ID="ldap.saslAuthorizationId"</code> */
    String LDAP_SASL_AUTHORIZATION_ID = "ldap.saslAuthorizationId";
    /** Constant <code>LDAP_SASL_SECURITY_STRENGTH="ldap.saslSecurityStrength"</code> */
    String LDAP_SASL_SECURITY_STRENGTH = "ldap.saslSecurityStrength";
    /** Constant <code>LDAP_SASL_QUALITY_OF_PROTECTION="ldap.saslQualityOfProtection"</code> */
    String LDAP_SASL_QUALITY_OF_PROTECTION = "ldap.saslQualityOfProtection";

    /** Constant <code>DB_DATASOURCE_CLASS_NAME="db.dataSourceClassName"</code> */
    String DB_DATASOURCE_CLASS_NAME = "db.dataSourceClassName";
    /** Constant <code>DB_JDBC_URL="db.jdbcUrl"</code> */
    String DB_JDBC_URL = "db.jdbcUrl";
    /** Constant <code>DB_ATTRIBUTES="db.userAttributes"</code> */
    String DB_ATTRIBUTES = "db.userAttributes";
    /** Constant <code>DB_USER_ID_ATTRIBUTE="db.userIdAttribute"</code> */
    String DB_USER_ID_ATTRIBUTE = "db.userIdAttribute";
    /** Constant <code>DB_USERNAME_ATTRIBUTE="db.usernameAttribute"</code> */
    String DB_USERNAME_ATTRIBUTE = "db.usernameAttribute";
    /** Constant <code>DB_USER_PASSWORD_ATTRIBUTE="db.userPasswordAttribute"</code> */
    String DB_USER_PASSWORD_ATTRIBUTE = "db.userPasswordAttribute";
    /** Constant <code>DB_USERS_TABLE="db.usersTable"</code> */
    String DB_USERS_TABLE = "db.usersTable";
    /** Constant <code>DB_USERNAME="db.username"</code> */
    String DB_USERNAME = "db.username";
    /** Constant <code>DB_PASSWORD="db.password"</code> */
    String DB_PASSWORD = "db.password";
    /** Constant <code>DB_AUTO_COMMIT="db.autoCommit"</code> */
    String DB_AUTO_COMMIT = "db.autoCommit";
    /** Constant <code>DB_CONNECTION_TIMEOUT="db.connectionTimeout"</code> */
    String DB_CONNECTION_TIMEOUT = "db.connectionTimeout";
    /** Constant <code>DB_IDLE_TIMEOUT="db.idleTimeout"</code> */
    String DB_IDLE_TIMEOUT = "db.idleTimeout";
    /** Constant <code>DB_MAX_LIFETIME="db.maxLifetime"</code> */
    String DB_MAX_LIFETIME = "db.maxLifetime";
    /** Constant <code>DB_CONNECTION_TEST_QUERY="db.connectionTestQuery"</code> */
    String DB_CONNECTION_TEST_QUERY = "db.connectionTestQuery";
    /** Constant <code>DB_MINIMUM_IDLE="db.minimumIdle"</code> */
    String DB_MINIMUM_IDLE = "db.minimumIdle";
    /** Constant <code>DB_MAXIMUM_POOL_SIZE="db.maximumPoolSize"</code> */
    String DB_MAXIMUM_POOL_SIZE = "db.maximumPoolSize";
    /** Constant <code>DB_POOL_NAME="db.poolName"</code> */
    String DB_POOL_NAME = "db.poolName";
    /** Constant <code>DB_INITIALIZATION_FAIL_TIMEOUT="db.initializationFailTimeout"</code> */
    String DB_INITIALIZATION_FAIL_TIMEOUT = "db.initializationFailTimeout";
    /** Constant <code>DB_ISOLATE_INTERNAL_QUERIES="db.isolateInternalQueries"</code> */
    String DB_ISOLATE_INTERNAL_QUERIES = "db.isolateInternalQueries";
    /** Constant <code>DB_ALLOW_POOL_SUSPENSION="db.allowPoolSuspension"</code> */
    String DB_ALLOW_POOL_SUSPENSION = "db.allowPoolSuspension";
    /** Constant <code>DB_READ_ONLY="db.readOnly"</code> */
    String DB_READ_ONLY = "db.readOnly";
    /** Constant <code>DB_REGISTER_MBEANS="db.registerMbeans"</code> */
    String DB_REGISTER_MBEANS = "db.registerMbeans";
    /** Constant <code>DB_CATALOG="db.catalog"</code> */
    String DB_CATALOG = "db.catalog";
    /** Constant <code>DB_CONNECTION_INIT_SQL="db.connectionInitSql"</code> */
    String DB_CONNECTION_INIT_SQL = "db.connectionInitSql";
    /** Constant <code>DB_DRIVER_CLASS_NAME="db.driverClassName"</code> */
    String DB_DRIVER_CLASS_NAME = "db.driverClassName";
    /** Constant <code>DB_TRANSACTION_ISOLATION="db.transactionIsolation"</code> */
    String DB_TRANSACTION_ISOLATION = "db.transactionIsolation";
    /** Constant <code>DB_VALIDATION_TIMEOUT="db.validationTimeout"</code> */
    String DB_VALIDATION_TIMEOUT = "db.validationTimeout";
    /** Constant <code>DB_LEAK_DETECTION_THRESHOLD="db.leakDetectionThreshold"</code> */
    String DB_LEAK_DETECTION_THRESHOLD = "db.leakDetectionThreshold";
    /** Constant <code>DB_CUSTOM_PARAM_KEY="db.customParamKey"</code> */
    String DB_CUSTOM_PARAM_KEY = "db.customParamKey";
    /** Constant <code>DB_CUSTOM_PARAM_VALUE="db.customParamValue"</code> */
    String DB_CUSTOM_PARAM_VALUE = "db.customParamValue";
    /** Constant <code>DB_LOGIN_TIMEOUT="db.loginTimeout"</code> */
    String DB_LOGIN_TIMEOUT = "db.loginTimeout";
    /** Constant <code>DB_DATASOURCE_JNDI="db.dataSourceJndi"</code> */
    String DB_DATASOURCE_JNDI = "db.dataSourceJndi";
    /** Constant <code>DB_PASSWORD_ENCODER="db.passwordEncoder"</code> */
    String DB_PASSWORD_ENCODER = "db.passwordEncoder";

    /** Constant <code>REST_URL="rest.url"</code> */
    String REST_URL = "rest.url";

    /** Constant <code>SPRING_ENCODER="encoder.spring"</code> */
    String SPRING_ENCODER = "encoder.spring";
    /** Constant <code>SPRING_ENCODER_TYPE="encoder.spring.type"</code> */
    String SPRING_ENCODER_TYPE = "encoder.spring.type";
    enum SpringEncoderType {BCRYPT, NOOP, PBKDF2, SCRYPT, STANDARD}
    /** Constant <code>SPRING_ENCODER_BCRYPT_LENGTH="encoder.spring.bcrypt.length"</code> */
    String SPRING_ENCODER_BCRYPT_LENGTH = "encoder.spring.bcrypt.length";
    /** Constant <code>SPRING_ENCODER_PBKDF2_SECRET="encoder.spring.pbkdf2.secret"</code> */
    String SPRING_ENCODER_PBKDF2_SECRET = "encoder.spring.pbkdf2.secret";
    /** Constant <code>SPRING_ENCODER_PBKDF2_ITERATIONS="encoder.spring.pbkdf2.iterations"</code> */
    String SPRING_ENCODER_PBKDF2_ITERATIONS = "encoder.spring.pbkdf2.iterations";
    /** Constant <code>SPRING_ENCODER_PBKDF2_HASH_WIDTH="encoder.spring.pbkdf2.hashWidth"</code> */
    String SPRING_ENCODER_PBKDF2_HASH_WIDTH = "encoder.spring.pbkdf2.hashWidth";
    /** Constant <code>SPRING_ENCODER_SCRYPT_CPU_COST="encoder.spring.scrypt.cpuCost"</code> */
    String SPRING_ENCODER_SCRYPT_CPU_COST = "encoder.spring.scrypt.cpuCost";
    /** Constant <code>SPRING_ENCODER_SCRYPT_MEMORY_COST="encoder.spring.scrypt.memoryCost"</code> */
    String SPRING_ENCODER_SCRYPT_MEMORY_COST = "encoder.spring.scrypt.memoryCost";
    /** Constant <code>SPRING_ENCODER_SCRYPT_PARALLELIZATION="encoder.spring.scrypt.parallelization"</code> */
    String SPRING_ENCODER_SCRYPT_PARALLELIZATION = "encoder.spring.scrypt.parallelization";
    /** Constant <code>SPRING_ENCODER_SCRYPT_KEY_LENGTH="encoder.spring.scrypt.keyLength"</code> */
    String SPRING_ENCODER_SCRYPT_KEY_LENGTH = "encoder.spring.scrypt.keyLength";
    /** Constant <code>SPRING_ENCODER_SCRYPT_SALT_LENGTH="encoder.spring.scrypt.saltLength"</code> */
    String SPRING_ENCODER_SCRYPT_SALT_LENGTH = "encoder.spring.scrypt.saltLength";
    /** Constant <code>SPRING_ENCODER_STANDARD_SECRET="encoder.spring.standard.secret"</code> */
    String SPRING_ENCODER_STANDARD_SECRET = "encoder.spring.standard.secret";

    /** Constant <code>SHIRO_ENCODER="encoder.shiro"</code> */
    String SHIRO_ENCODER = "encoder.shiro";
    /** Constant <code>SHIRO_ENCODER_GENERATE_PUBLIC_SALT="encoder.shiro.generatePublicSalt"</code> */
    String SHIRO_ENCODER_GENERATE_PUBLIC_SALT = "encoder.shiro.generatePublicSalt";
    /** Constant <code>SHIRO_ENCODER_HASH_ALGORITHM_NAME="encoder.shiro.hashAlgorithmName"</code> */
    String SHIRO_ENCODER_HASH_ALGORITHM_NAME = "encoder.shiro.hashAlgorithmName";
    /** Constant <code>SHIRO_ENCODER_HASH_ITERATIONS="encoder.shiro.hashIterations"</code> */
    String SHIRO_ENCODER_HASH_ITERATIONS = "encoder.shiro.hashIterations";
    /** Constant <code>SHIRO_ENCODER_PRIVATE_SALT="encoder.shiro.privateSalt"</code> */
    String SHIRO_ENCODER_PRIVATE_SALT = "encoder.shiro.privateSalt";
}
