/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.config.ldaptive;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.Arrays;
import java.util.stream.Collectors;
import lombok.Generated;
import org.ldaptive.BindConnectionInitializer;
import org.ldaptive.BindRequest;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.ConnectionInitializer;
import org.ldaptive.ConnectionValidator;
import org.ldaptive.Credential;
import org.ldaptive.FilterTemplate;
import org.ldaptive.PooledConnectionFactory;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.SearchConnectionValidator;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchScope;
import org.ldaptive.SimpleBindRequest;
import org.ldaptive.ad.extended.FastBindConnectionInitializer;
import org.ldaptive.auth.AuthenticationHandler;
import org.ldaptive.auth.Authenticator;
import org.ldaptive.auth.CompareAuthenticationHandler;
import org.ldaptive.auth.DnResolver;
import org.ldaptive.auth.EntryResolver;
import org.ldaptive.auth.FormatDnResolver;
import org.ldaptive.auth.SearchDnResolver;
import org.ldaptive.auth.SearchEntryResolver;
import org.ldaptive.auth.SimpleBindAuthenticationHandler;
import org.ldaptive.control.PasswordPolicyControl;
import org.ldaptive.control.RequestControl;
import org.ldaptive.pool.BindConnectionPassivator;
import org.ldaptive.pool.ConnectionPassivator;
import org.ldaptive.pool.IdlePruneStrategy;
import org.ldaptive.pool.PruneStrategy;
import org.ldaptive.sasl.Mechanism;
import org.ldaptive.sasl.QualityOfProtection;
import org.ldaptive.sasl.SaslConfig;
import org.ldaptive.sasl.SecurityStrength;
import org.ldaptive.ssl.CredentialConfig;
import org.ldaptive.ssl.KeyStoreCredentialConfig;
import org.ldaptive.ssl.SslConfig;
import org.ldaptive.ssl.X509CredentialConfig;
import org.pac4j.config.ldaptive.AbstractLdapProperties;
import org.pac4j.config.ldaptive.LdapAuthenticationProperties;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdaptiveAuthenticatorBuilder {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdaptiveAuthenticatorBuilder.class);

    protected LdaptiveAuthenticatorBuilder() {
    }

    public static Authenticator getAuthenticator(LdapAuthenticationProperties l) {
        if (l.getType() == LdapAuthenticationProperties.AuthenticationTypes.AD) {
            LOGGER.debug("Creating active directory authenticator for {}", (Object)l.getLdapUrl());
            return LdaptiveAuthenticatorBuilder.getActiveDirectoryAuthenticator(l);
        }
        if (l.getType() == LdapAuthenticationProperties.AuthenticationTypes.DIRECT) {
            LOGGER.debug("Creating direct-bind authenticator for {}", (Object)l.getLdapUrl());
            return LdaptiveAuthenticatorBuilder.getDirectBindAuthenticator(l);
        }
        if (l.getType() == LdapAuthenticationProperties.AuthenticationTypes.SASL) {
            LOGGER.debug("Creating SASL authenticator for {}", (Object)l.getLdapUrl());
            return LdaptiveAuthenticatorBuilder.getSaslAuthenticator(l);
        }
        if (l.getType() == LdapAuthenticationProperties.AuthenticationTypes.AUTHENTICATED) {
            LOGGER.debug("Creating authenticated authenticator for {}", (Object)l.getLdapUrl());
            return LdaptiveAuthenticatorBuilder.getAuthenticatedOrAnonSearchAuthenticator(l);
        }
        LOGGER.debug("Creating anonymous authenticator for {}", (Object)l.getLdapUrl());
        return LdaptiveAuthenticatorBuilder.getAuthenticatedOrAnonSearchAuthenticator(l);
    }

    private static Authenticator getSaslAuthenticator(LdapAuthenticationProperties l) {
        SearchDnResolver resolver = new SearchDnResolver();
        resolver.setBaseDn(l.getBaseDn());
        resolver.setSubtreeSearch(l.isSubtreeSearch());
        resolver.setAllowMultipleDns(l.isAllowMultipleDns());
        resolver.setConnectionFactory((ConnectionFactory)LdaptiveAuthenticatorBuilder.newPooledConnectionFactory(l));
        resolver.setUserFilter(l.getUserFilter());
        return new Authenticator((DnResolver)resolver, (AuthenticationHandler)LdaptiveAuthenticatorBuilder.getPooledBindAuthenticationHandler(l));
    }

    private static Authenticator getAuthenticatedOrAnonSearchAuthenticator(LdapAuthenticationProperties l) {
        SearchDnResolver resolver = new SearchDnResolver();
        resolver.setBaseDn(l.getBaseDn());
        resolver.setSubtreeSearch(l.isSubtreeSearch());
        resolver.setAllowMultipleDns(l.isAllowMultipleDns());
        resolver.setConnectionFactory((ConnectionFactory)LdaptiveAuthenticatorBuilder.newPooledConnectionFactory(l));
        resolver.setUserFilter(l.getUserFilter());
        Authenticator auth = CommonHelper.isBlank((String)l.getPrincipalAttributePassword()) ? new Authenticator((DnResolver)resolver, (AuthenticationHandler)LdaptiveAuthenticatorBuilder.getPooledBindAuthenticationHandler(l)) : new Authenticator((DnResolver)resolver, (AuthenticationHandler)LdaptiveAuthenticatorBuilder.getPooledCompareAuthenticationHandler(l));
        if (l.isEnhanceWithEntryResolver()) {
            auth.setEntryResolver(LdaptiveAuthenticatorBuilder.newSearchEntryResolver(l));
        }
        return auth;
    }

    private static Authenticator getDirectBindAuthenticator(LdapAuthenticationProperties l) {
        if (CommonHelper.isBlank((String)l.getDnFormat())) {
            throw new IllegalArgumentException("Dn format cannot be empty/blank for direct bind authentication");
        }
        FormatDnResolver resolver = new FormatDnResolver(l.getDnFormat());
        Authenticator authenticator = new Authenticator((DnResolver)resolver, (AuthenticationHandler)LdaptiveAuthenticatorBuilder.getPooledBindAuthenticationHandler(l));
        if (l.isEnhanceWithEntryResolver()) {
            authenticator.setEntryResolver(LdaptiveAuthenticatorBuilder.newSearchEntryResolver(l));
        }
        return authenticator;
    }

    private static Authenticator getActiveDirectoryAuthenticator(LdapAuthenticationProperties l) {
        if (CommonHelper.isBlank((String)l.getDnFormat())) {
            throw new IllegalArgumentException("Dn format cannot be empty/blank for active directory authentication");
        }
        FormatDnResolver resolver = new FormatDnResolver(l.getDnFormat());
        Authenticator authn = new Authenticator((DnResolver)resolver, (AuthenticationHandler)LdaptiveAuthenticatorBuilder.getPooledBindAuthenticationHandler(l));
        if (l.isEnhanceWithEntryResolver()) {
            authn.setEntryResolver(LdaptiveAuthenticatorBuilder.newSearchEntryResolver(l));
        }
        return authn;
    }

    private static SimpleBindAuthenticationHandler getPooledBindAuthenticationHandler(LdapAuthenticationProperties l) {
        SimpleBindAuthenticationHandler handler = new SimpleBindAuthenticationHandler((ConnectionFactory)LdaptiveAuthenticatorBuilder.newPooledConnectionFactory(l));
        handler.setAuthenticationControls(new RequestControl[]{new PasswordPolicyControl()});
        return handler;
    }

    private static CompareAuthenticationHandler getPooledCompareAuthenticationHandler(LdapAuthenticationProperties l) {
        CompareAuthenticationHandler handler = new CompareAuthenticationHandler((ConnectionFactory)LdaptiveAuthenticatorBuilder.newPooledConnectionFactory(l));
        handler.setPasswordAttribute(l.getPrincipalAttributePassword());
        return handler;
    }

    public static EntryResolver newSearchEntryResolver(LdapAuthenticationProperties l) {
        SearchEntryResolver entryResolver = new SearchEntryResolver();
        entryResolver.setBaseDn(l.getBaseDn());
        entryResolver.setUserFilter(l.getUserFilter());
        entryResolver.setSubtreeSearch(l.isSubtreeSearch());
        entryResolver.setConnectionFactory((ConnectionFactory)LdaptiveAuthenticatorBuilder.newPooledConnectionFactory(l));
        return entryResolver;
    }

    public static ConnectionConfig newConnectionConfig(AbstractLdapProperties l) {
        ConnectionConfig cc = new ConnectionConfig();
        String urls = Arrays.stream(l.getLdapUrl().split(",")).collect(Collectors.joining(" "));
        LOGGER.debug("Transformed LDAP urls from [{}] to [{}]", (Object)l.getLdapUrl(), (Object)urls);
        cc.setLdapUrl(urls);
        cc.setUseStartTLS(l.isUseStartTls());
        cc.setConnectTimeout(LdaptiveAuthenticatorBuilder.newDuration(l.getConnectTimeout()));
        if (l.getTrustCertificates() != null) {
            cfg = new X509CredentialConfig();
            cfg.setTrustCertificates(l.getTrustCertificates());
            cc.setSslConfig(new SslConfig((CredentialConfig)cfg));
        } else if (l.getKeystore() != null) {
            cfg = new KeyStoreCredentialConfig();
            cfg.setKeyStore(l.getKeystore());
            cfg.setKeyStorePassword(l.getKeystorePassword());
            cfg.setKeyStoreType(l.getKeystoreType());
            cc.setSslConfig(new SslConfig((CredentialConfig)cfg));
        } else {
            cc.setSslConfig(new SslConfig());
        }
        if (l.getSaslMechanism() != null) {
            BindConnectionInitializer bc = new BindConnectionInitializer();
            SaslConfig sc = switch (l.getSaslMechanism()) {
                case Mechanism.DIGEST_MD5 -> SaslConfig.builder().mechanism(Mechanism.DIGEST_MD5).realm(l.getSaslRealm()).build();
                case Mechanism.CRAM_MD5 -> SaslConfig.builder().mechanism(Mechanism.CRAM_MD5).build();
                case Mechanism.EXTERNAL -> SaslConfig.builder().mechanism(Mechanism.EXTERNAL).build();
                case Mechanism.GSSAPI -> SaslConfig.builder().mechanism(Mechanism.GSSAPI).realm(l.getSaslRealm()).build();
                default -> throw new IllegalArgumentException("Unknown SASL mechanism " + l.getSaslMechanism().name());
            };
            sc.setAuthorizationId(l.getSaslAuthorizationId());
            sc.setMutualAuthentication(l.getSaslMutualAuth());
            sc.setQualityOfProtection(new QualityOfProtection[]{l.getSaslQualityOfProtection()});
            sc.setSecurityStrength(new SecurityStrength[]{l.getSaslSecurityStrength()});
            bc.setBindSaslConfig(sc);
            cc.setConnectionInitializers(new ConnectionInitializer[]{bc});
        } else if (CommonHelper.areEquals((String)l.getBindCredential(), (String)"*") && CommonHelper.areEquals((String)l.getBindDn(), (String)"*")) {
            cc.setConnectionInitializers(new ConnectionInitializer[]{new FastBindConnectionInitializer()});
        } else if (CommonHelper.isNotBlank((String)l.getBindDn()) && CommonHelper.isNotBlank((String)l.getBindCredential())) {
            cc.setConnectionInitializers(new ConnectionInitializer[]{new BindConnectionInitializer(l.getBindDn(), new Credential(l.getBindCredential()))});
        }
        return cc;
    }

    public static PooledConnectionFactory newPooledConnectionFactory(AbstractLdapProperties l) {
        ConnectionConfig cc = LdaptiveAuthenticatorBuilder.newConnectionConfig(l);
        PooledConnectionFactory cf = new PooledConnectionFactory(cc);
        cf.setBlockWaitTime(LdaptiveAuthenticatorBuilder.newDuration(l.getBlockWaitTime()));
        cf.setMinPoolSize(l.getMinPoolSize());
        cf.setMaxPoolSize(l.getMaxPoolSize());
        cf.setValidateOnCheckOut(l.isValidateOnCheckout());
        cf.setValidatePeriodically(l.isValidatePeriodically());
        IdlePruneStrategy strategy = new IdlePruneStrategy();
        strategy.setIdleTime(LdaptiveAuthenticatorBuilder.newDuration(l.getIdleTime()));
        strategy.setPrunePeriod(LdaptiveAuthenticatorBuilder.newDuration(l.getPrunePeriod()));
        cf.setPruneStrategy((PruneStrategy)strategy);
        cf.setFailFastInitialize(l.isFailFast());
        SearchConnectionValidator validator = new SearchConnectionValidator();
        validator.setValidatePeriod(LdaptiveAuthenticatorBuilder.newDuration(l.getValidatePeriod()));
        cf.setValidator((ConnectionValidator)validator);
        if (CommonHelper.isNotBlank((String)l.getPoolPassivator())) {
            AbstractLdapProperties.LdapConnectionPoolPassivator pass = AbstractLdapProperties.LdapConnectionPoolPassivator.valueOf(l.getPoolPassivator().toUpperCase());
            switch (pass) {
                case CLOSE: {
                    cf.setPassivator(conn -> {
                        conn.close();
                        return true;
                    });
                    break;
                }
                case BIND: {
                    LOGGER.debug("Creating a bind passivator instance for the connection pool");
                    SimpleBindRequest bindRequest = new SimpleBindRequest(l.getBindDn(), new Credential(l.getBindCredential()));
                    cf.setPassivator((ConnectionPassivator)new BindConnectionPassivator((BindRequest)bindRequest));
                    break;
                }
            }
        }
        LOGGER.debug("Initializing ldap connection pool for {} and bindDn {}", (Object)l.getLdapUrl(), (Object)l.getBindDn());
        cf.initialize();
        return cf;
    }

    public static Duration newDuration(long length) {
        return Duration.ofSeconds(length);
    }

    public static SearchRequest newSearchRequest(String baseDn, FilterTemplate filter) {
        SearchRequest sr = new SearchRequest(baseDn, filter, new String[0]);
        sr.setReturnAttributes(ReturnAttributes.ALL_USER.value());
        sr.setSearchScope(SearchScope.SUBTREE);
        return sr;
    }

    public static FilterTemplate newSearchFilter(String filterQuery, String ... params) {
        FilterTemplate filter = new FilterTemplate();
        filter.setFilter(filterQuery);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (filter.getFilter().contains("{" + i + "}")) {
                    filter.setParameter(i, (Object)params[i]);
                    continue;
                }
                filter.setParameter("user", (Object)params[i]);
            }
        }
        LOGGER.debug("Constructed LDAP search filter [{}]", (Object)filter.format());
        return filter;
    }

    public static SearchOperation newSearchOperation(String baseDn, String filterQuery, String ... params) {
        SearchOperation operation = new SearchOperation();
        operation.setRequest((SearchRequest)SearchRequest.builder().dn(baseDn).filter(LdaptiveAuthenticatorBuilder.newSearchFilter(filterQuery, params)).returnAttributes(ReturnAttributes.ALL.value()).scope(SearchScope.SUBTREE).build());
        return operation;
    }
}

