/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.client;

import java.util.concurrent.TimeUnit;
import org.jasig.cas.client.util.CommonUtils;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.store.GuavaStore;
import org.pac4j.core.store.Store;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CasProxyReceptor
extends IndirectClient<TokenCredentials, CommonProfile> {
    private static final Logger logger = LoggerFactory.getLogger(CasProxyReceptor.class);
    private Store<String, String> store = new GuavaStore(1000, 1, TimeUnit.MINUTES);
    public static final String PARAM_PROXY_GRANTING_TICKET_IOU = "pgtIou";
    public static final String PARAM_PROXY_GRANTING_TICKET = "pgtId";

    protected void clientInit(WebContext context) {
        CommonHelper.assertNotNull((String)"store", this.store);
        this.defaultRedirectActionBuilder(ctx -> {
            throw new TechnicalException("Not supported by the CAS proxy receptor");
        });
        this.defaultCredentialsExtractor(ctx -> {
            String proxyGrantingTicketIou = ctx.getRequestParameter(PARAM_PROXY_GRANTING_TICKET_IOU);
            logger.debug("proxyGrantingTicketIou: {}", (Object)proxyGrantingTicketIou);
            String proxyGrantingTicket = ctx.getRequestParameter(PARAM_PROXY_GRANTING_TICKET);
            logger.debug("proxyGrantingTicket: {}", (Object)proxyGrantingTicket);
            if (CommonUtils.isBlank((String)proxyGrantingTicket) || CommonUtils.isBlank((String)proxyGrantingTicketIou)) {
                String message = "Missing proxyGrantingTicket or proxyGrantingTicketIou";
                throw HttpAction.ok((String)"Missing proxyGrantingTicket or proxyGrantingTicketIou", (WebContext)ctx, (String)"");
            }
            this.store.set((Object)proxyGrantingTicketIou, (Object)proxyGrantingTicket);
            ctx.writeResponseContent("<?xml version=\"1.0\"?>");
            ctx.writeResponseContent("<casClient:proxySuccess xmlns:casClient=\"http://www.yale.edu/tp/casClient\" />");
            String message = "No credential for CAS proxy receptor -> returns ok";
            logger.debug("No credential for CAS proxy receptor -> returns ok");
            throw HttpAction.ok((String)"No credential for CAS proxy receptor -> returns ok", (WebContext)ctx, (String)"");
        });
        this.defaultAuthenticator((credentials, ctx) -> {
            throw new TechnicalException("Not supported by the CAS proxy receptor");
        });
    }

    public Store<String, String> getStore() {
        return this.store;
    }

    public void setStore(Store<String, String> store) {
        this.store = store;
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"callbackUrl", this.callbackUrl, "store", this.store});
    }
}

