/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.gradle;

import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.util.GradleVersion;
import org.owasp.dependencycheck.gradle.extension.DependencyCheckExtension;
import org.owasp.dependencycheck.gradle.tasks.Aggregate;
import org.owasp.dependencycheck.gradle.tasks.Analyze;
import org.owasp.dependencycheck.gradle.tasks.Purge;
import org.owasp.dependencycheck.gradle.tasks.Update;

public class DependencyCheckPlugin
implements Plugin<Project>,
GroovyObject {
    private static final GradleVersion MINIMUM_GRADLE_VERSION;
    private static final GradleVersion REGISTER_TASK_GRADLE_VERSION;
    public static final String ANALYZE_TASK = "dependencyCheckAnalyze";
    public static final String AGGREGATE_TASK = "dependencyCheckAggregate";
    public static final String UPDATE_TASK = "dependencyCheckUpdate";
    public static final String PURGE_TASK = "dependencyCheckPurge";
    private static final String CHECK_EXTENSION_NAME = "dependencyCheck";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public DependencyCheckPlugin() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void apply(Project project) {
        this.checkGradleVersion(project);
        this.initializeConfigurations(project);
        this.registerTasks(project);
    }

    public void initializeConfigurations(Project project) {
        project.getExtensions().create(CHECK_EXTENSION_NAME, DependencyCheckExtension.class, new Object[]{project});
    }

    public void registerTasks(Project project) {
        if (REGISTER_TASK_GRADLE_VERSION.compareTo(GradleVersion.current()) <= 0) {
            project.getTasks().register(PURGE_TASK, Purge.class);
            project.getTasks().register(UPDATE_TASK, Update.class);
            project.getTasks().register(ANALYZE_TASK, Analyze.class);
            project.getTasks().register(AGGREGATE_TASK, Aggregate.class);
        } else {
            project.task(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"type", Purge.class}), PURGE_TASK);
            project.task(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"type", Update.class}), UPDATE_TASK);
            project.task(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"type", Analyze.class}), ANALYZE_TASK);
            project.task(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"type", Aggregate.class}), AGGREGATE_TASK);
        }
    }

    public void checkGradleVersion(Project project) {
        if (project != null && MINIMUM_GRADLE_VERSION.compareTo(GradleVersion.current()) > 0) {
            if (project.getPlugins().contains("com.android.build.gradle.AppPlugin")) {
                throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{GradleVersion.current()}, new String[]{"Detected ", "; the dependency-check-gradle "}).plus((GString)new GStringImpl(new Object[]{MINIMUM_GRADLE_VERSION}, new String[]{"plugin requires ", " or higher when analyzing Android projects."}))));
            }
            project.getLogger().warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{GradleVersion.current()}, new String[]{"Detected ", "; while the dependency-check-gradle "}).plus((GString)new GStringImpl(new Object[]{MINIMUM_GRADLE_VERSION}, new String[]{"plugin will work it is recommended that you upgrade to ", " or higher."}))));
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DependencyCheckPlugin.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        GradleVersion gradleVersion;
        GradleVersion gradleVersion2;
        MINIMUM_GRADLE_VERSION = gradleVersion2 = GradleVersion.version((String)"4.0");
        REGISTER_TASK_GRADLE_VERSION = gradleVersion = GradleVersion.version((String)"4.9");
    }

    @Generated
    public static GradleVersion getMINIMUM_GRADLE_VERSION() {
        return MINIMUM_GRADLE_VERSION;
    }

    @Generated
    public static GradleVersion getREGISTER_TASK_GRADLE_VERSION() {
        return REGISTER_TASK_GRADLE_VERSION;
    }
}

