/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.config;

import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.IntPredicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.owasp.csrfguard.action.IAction;
import org.owasp.csrfguard.config.ConfigurationProvider;
import org.owasp.csrfguard.config.properties.ConfigParameters;
import org.owasp.csrfguard.config.properties.HttpMethod;
import org.owasp.csrfguard.config.properties.PropertyUtils;
import org.owasp.csrfguard.config.properties.javascript.JavaScriptConfigParameters;
import org.owasp.csrfguard.config.properties.javascript.JsConfigParameter;
import org.owasp.csrfguard.servlet.JavaScriptServlet;
import org.owasp.csrfguard.token.storage.LogicalSessionExtractor;
import org.owasp.csrfguard.token.storage.TokenHolder;
import org.owasp.csrfguard.util.CsrfGuardUtils;
import org.owasp.csrfguard.util.RegexValidationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesConfigurationProvider
implements ConfigurationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesConfigurationProvider.class);
    private final Set<String> protectedPages;
    private final Set<String> unprotectedPages;
    private final Set<String> protectedMethods;
    private final Set<String> unprotectedMethods;
    private final Set<String> bannedUserAgentProperties;
    private final List<IAction> actions;
    private final Properties propertiesCache;
    private final boolean enabled;
    private String tokenName;
    private int tokenLength;
    private boolean rotate;
    private boolean tokenPerPage;
    private boolean tokenPerPagePrecreate;
    private boolean printConfig;
    private SecureRandom prng;
    private String newTokenLandingPage;
    private boolean useNewTokenLandingPage;
    private boolean ajax;
    private boolean protect;
    private boolean forceSynchronousAjax;
    private String domainOrigin;
    private Duration pageTokenSynchronizationTolerance;
    private boolean validationWhenNoSessionExists;
    private boolean javascriptParamsInitialized = false;
    private String javascriptTemplateCode;
    private boolean javascriptDomainStrict;
    private String javascriptCacheControl;
    private String javascriptTaggedCacheControl;
    private Pattern javascriptRefererPattern;
    private boolean javascriptInjectIntoForms;
    private boolean javascriptRefererMatchProtocol;
    private boolean javascriptInjectIntoAttributes;
    private boolean isJavascriptInjectIntoDynamicallyCreatedNodes;
    private String javascriptDynamicNodeCreationEventName;
    private String javascriptXrequestedWith;
    private boolean javascriptInjectGetForms;
    private boolean javascriptRefererMatchDomain;
    private boolean javascriptInjectFormAttributes;
    private String javascriptUnprotectedExtensions;
    private LogicalSessionExtractor logicalSessionExtractor;
    private TokenHolder tokenHolder;

    public PropertiesConfigurationProvider(Properties properties) {
        try {
            this.propertiesCache = properties;
            this.actions = new ArrayList<IAction>();
            this.protectedPages = new HashSet<String>();
            this.unprotectedPages = new HashSet<String>();
            this.protectedMethods = new HashSet<String>();
            this.unprotectedMethods = new HashSet<String>();
            this.bannedUserAgentProperties = new HashSet<String>();
            this.enabled = PropertyUtils.getProperty(properties, ConfigParameters.CSRFGUARD_ENABLED);
            if (this.enabled) {
                this.tokenName = PropertyUtils.getProperty(properties, ConfigParameters.TOKEN_NAME);
                this.tokenLength = this.getTokenLength(properties);
                this.rotate = PropertyUtils.getProperty(properties, ConfigParameters.ROTATE);
                this.tokenPerPage = PropertyUtils.getProperty(properties, ConfigParameters.TOKEN_PER_PAGE);
                this.validationWhenNoSessionExists = PropertyUtils.getProperty(properties, ConfigParameters.VALIDATE_WHEN_NO_SESSION_EXISTS);
                this.domainOrigin = PropertyUtils.getProperty(properties, ConfigParameters.DOMAIN_ORIGIN);
                this.tokenPerPagePrecreate = PropertyUtils.getProperty(properties, ConfigParameters.TOKEN_PER_PAGE_PRECREATE);
                this.prng = this.getSecureRandomInstance(properties);
                this.printConfig = PropertyUtils.getProperty(properties, ConfigParameters.PRINT_ENABLED);
                this.protect = PropertyUtils.getProperty(properties, ConfigParameters.CSRFGUARD_PROTECT);
                this.forceSynchronousAjax = PropertyUtils.getProperty(properties, ConfigParameters.FORCE_SYNCHRONOUS_AJAX);
                this.newTokenLandingPage = PropertyUtils.getProperty(properties, "org.owasp.csrfguard.NewTokenLandingPage");
                this.useNewTokenLandingPage = PropertyUtils.getProperty(properties, ConfigParameters.getUseNewTokenLandingPage(this.newTokenLandingPage));
                this.ajax = PropertyUtils.getProperty(properties, ConfigParameters.AJAX_ENABLED);
                this.pageTokenSynchronizationTolerance = PropertyUtils.getProperty(properties, ConfigParameters.PAGE_TOKEN_SYNCHRONIZATION_TOLERANCE);
                this.initializeTokenPersistenceConfigurations(properties);
                this.initializeActionParameters(properties, this.instantiateActions(properties));
                this.initializePageProtection(properties);
                this.initializeMethodProtection(properties);
                this.initializeBannedUserAgentProperties(properties);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getTokenName() {
        return this.tokenName;
    }

    @Override
    public int getTokenLength() {
        return this.tokenLength;
    }

    @Override
    public boolean isRotateEnabled() {
        return this.rotate;
    }

    @Override
    public boolean isValidateWhenNoSessionExists() {
        return this.validationWhenNoSessionExists;
    }

    @Override
    public boolean isTokenPerPageEnabled() {
        return this.tokenPerPage;
    }

    @Override
    public boolean isTokenPerPagePrecreateEnabled() {
        return this.tokenPerPagePrecreate;
    }

    @Override
    public SecureRandom getPrng() {
        return this.prng;
    }

    @Override
    public String getNewTokenLandingPage() {
        return this.newTokenLandingPage;
    }

    @Override
    public boolean isUseNewTokenLandingPage() {
        return this.useNewTokenLandingPage;
    }

    @Override
    public boolean isAjaxEnabled() {
        return this.ajax;
    }

    @Override
    public boolean isProtectEnabled() {
        return this.protect;
    }

    @Override
    public boolean isForceSynchronousAjax() {
        return this.forceSynchronousAjax;
    }

    @Override
    public Set<String> getProtectedPages() {
        return this.protectedPages;
    }

    @Override
    public Set<String> getUnprotectedPages() {
        return this.unprotectedPages;
    }

    @Override
    public Set<String> getProtectedMethods() {
        return this.protectedMethods;
    }

    @Override
    public Set<String> getUnprotectedMethods() {
        return this.unprotectedMethods;
    }

    @Override
    public Set<String> getBannedUserAgentProperties() {
        return this.bannedUserAgentProperties;
    }

    @Override
    public List<IAction> getActions() {
        return this.actions;
    }

    @Override
    public boolean isPrintConfig() {
        return this.printConfig;
    }

    @Override
    public void initializeJavaScriptConfiguration() {
        this.javascriptInitParamsIfNeeded();
    }

    @Override
    public boolean isJavascriptDomainStrict() {
        return this.javascriptDomainStrict;
    }

    @Override
    public String getJavascriptCacheControl() {
        return this.javascriptCacheControl;
    }

    @Override
    public String getJavascriptTaggedCacheControl() {
        return this.javascriptTaggedCacheControl;
    }

    @Override
    public Pattern getJavascriptRefererPattern() {
        return this.javascriptRefererPattern;
    }

    @Override
    public boolean isJavascriptRefererMatchProtocol() {
        return this.javascriptRefererMatchProtocol;
    }

    @Override
    public boolean isJavascriptRefererMatchDomain() {
        return this.javascriptRefererMatchDomain;
    }

    @Override
    public boolean isJavascriptInjectIntoForms() {
        return this.javascriptInjectIntoForms;
    }

    @Override
    public boolean isJavascriptInjectIntoAttributes() {
        return this.javascriptInjectIntoAttributes;
    }

    @Override
    public boolean isJavascriptInjectIntoDynamicallyCreatedNodes() {
        return this.isJavascriptInjectIntoDynamicallyCreatedNodes;
    }

    @Override
    public String getJavascriptDynamicNodeCreationEventName() {
        return this.javascriptDynamicNodeCreationEventName;
    }

    @Override
    public String getJavascriptXrequestedWith() {
        return this.javascriptXrequestedWith;
    }

    @Override
    public String getJavascriptTemplateCode() {
        return this.javascriptTemplateCode;
    }

    @Override
    public boolean isCacheable() {
        return this.javascriptParamsInitialized;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isJavascriptInjectGetForms() {
        return this.javascriptInjectGetForms;
    }

    @Override
    public boolean isJavascriptInjectFormAttributes() {
        return this.javascriptInjectFormAttributes;
    }

    @Override
    public String getDomainOrigin() {
        return this.domainOrigin;
    }

    @Override
    public String getJavascriptUnprotectedExtensions() {
        return this.javascriptUnprotectedExtensions;
    }

    @Override
    public TokenHolder getTokenHolder() {
        return this.tokenHolder;
    }

    @Override
    public LogicalSessionExtractor getLogicalSessionExtractor() {
        return this.logicalSessionExtractor;
    }

    @Override
    public Duration getPageTokenSynchronizationTolerance() {
        return this.pageTokenSynchronizationTolerance;
    }

    private Map<String, IAction> instantiateActions(Properties properties) throws InstantiationException, IllegalAccessException {
        HashMap<String, IAction> actionsMap = new HashMap<String, IAction>();
        for (Object obj : properties.keySet()) {
            String propertyKey = (String)obj;
            String actionProperty = PropertiesConfigurationProvider.getPrimaryPropertyDirective(propertyKey, "org.owasp.csrfguard.action.");
            if (!Objects.nonNull(actionProperty)) continue;
            String actionClass = PropertyUtils.getProperty(properties, propertyKey);
            IAction action = (IAction)CsrfGuardUtils.forName(actionClass).newInstance();
            action.setName(actionProperty);
            actionsMap.put(action.getName(), action);
            this.actions.add(action);
        }
        return actionsMap;
    }

    private void initializeActionParameters(Properties properties, Map<String, IAction> actionsMap) throws IOException {
        for (Object obj : properties.keySet()) {
            String propertyKey = (String)obj;
            Pair<String, Integer> actionParameterProperty = PropertiesConfigurationProvider.getParameterPropertyDirective(propertyKey, "org.owasp.csrfguard.action.");
            if (!Objects.nonNull(actionParameterProperty)) continue;
            String directive = (String)actionParameterProperty.getKey();
            int index = (Integer)actionParameterProperty.getValue();
            String actionName = directive.substring(0, index);
            IAction action = actionsMap.get(actionName);
            String parameterName = directive.substring(index + 1);
            String parameterValue = PropertyUtils.getProperty(properties, propertyKey);
            action.setParameter(parameterName, parameterValue);
        }
        if (this.actions.isEmpty()) {
            throw new IOException("At least one action that will be called in case of CSRF attacks must be defined!");
        }
    }

    private void initializeMethodProtection(Properties properties) {
        this.protectedMethods.addAll(PropertiesConfigurationProvider.initializeMethodProtection(properties, "org.owasp.csrfguard.ProtectedMethods"));
        this.unprotectedMethods.addAll(PropertiesConfigurationProvider.initializeMethodProtection(properties, "org.owasp.csrfguard.UnprotectedMethods"));
        HashSet<String> intersection = new HashSet<String>(this.protectedMethods);
        intersection.retainAll(this.unprotectedMethods);
        if (!intersection.isEmpty()) {
            throw new IllegalArgumentException(String.format("The %s HTTP method(s) cannot be both protected and unprotected.", intersection));
        }
    }

    private static Set<String> initializeMethodProtection(Properties properties, String configParameterName) {
        String methodProtectionValue = PropertyUtils.getProperty(properties, configParameterName);
        if (StringUtils.isNotBlank((CharSequence)methodProtectionValue)) {
            Set<String> httpMethods = Arrays.stream(methodProtectionValue.split(",")).map(String::trim).collect(Collectors.toSet());
            HttpMethod.validate(httpMethods);
            return httpMethods;
        }
        return Collections.emptySet();
    }

    private void initializePageProtection(Properties properties) {
        for (Object obj : properties.keySet()) {
            String propertyKey = (String)obj;
            String protectedPage = this.getPageProperty(properties, propertyKey, "org.owasp.csrfguard.protected.");
            if (Objects.nonNull(protectedPage)) {
                this.protectedPages.add(protectedPage);
                continue;
            }
            String unProtectedPage = this.getPageProperty(properties, propertyKey, "org.owasp.csrfguard.unprotected.");
            if (!Objects.nonNull(unProtectedPage)) continue;
            this.unprotectedPages.add(unProtectedPage);
        }
    }

    private void initializeBannedUserAgentProperties(Properties properties) {
        this.bannedUserAgentProperties.addAll(properties.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("org.owasp.csrfguard.bannedUserAgentProperty.")).map(e -> (String)e.getValue()).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    private static Pair<String, Integer> getParameterPropertyDirective(String propertyKey, String propertyKeyPrefix) {
        return PropertiesConfigurationProvider.getPropertyDirective(propertyKey, propertyKeyPrefix, i -> i >= 0);
    }

    private static String getPrimaryPropertyDirective(String propertyKey, String propertyKeyPrefix) {
        Pair<String, Integer> propertyDirective = PropertiesConfigurationProvider.getPropertyDirective(propertyKey, propertyKeyPrefix, i -> i < 0);
        return Objects.isNull(propertyDirective) ? null : (String)propertyDirective.getKey();
    }

    private static Pair<String, Integer> getPropertyDirective(String propertyKey, String propertyKeyPrefix, IntPredicate directivePredicate) {
        String directive;
        int index;
        Pair result = null;
        if (propertyKey.startsWith(propertyKeyPrefix) && directivePredicate.test(index = (directive = propertyKey.substring(propertyKeyPrefix.length())).indexOf(46))) {
            result = Pair.of((Object)directive, (Object)index);
        }
        return result;
    }

    private String getPageProperty(Properties properties, String propertyKey, String propertyKeyPrefix) {
        String result = null;
        String pageProperty = PropertiesConfigurationProvider.getPrimaryPropertyDirective(propertyKey, propertyKeyPrefix);
        if (Objects.nonNull(pageProperty)) {
            String pageUri = PropertyUtils.getProperty(properties, propertyKey);
            result = this.isSpecialUriDescriptor(pageUri) ? pageUri : CsrfGuardUtils.normalizeResourceURI(pageUri);
        }
        return result;
    }

    private boolean isSpecialUriDescriptor(String resourceUri) {
        if (this.tokenPerPage && (resourceUri.endsWith("/*") || resourceUri.startsWith("*."))) {
            LOGGER.warn("'Extension' and 'partial path wildcard' matching for page tokens is not supported properly yet! Every resource will be assigned a new unique token instead of using the defined resource matcher token. Although this is not a security issue, in case of a large REST application it can have an impact on performance. Consider using regular expressions instead.");
        }
        return RegexValidationUtil.isTestPathRegex(resourceUri) || resourceUri.startsWith("/*") || resourceUri.endsWith("/*") || resourceUri.startsWith("*.");
    }

    private void javascriptInitParamsIfNeeded() {
        ServletConfig servletConfig;
        if (!this.javascriptParamsInitialized && (servletConfig = JavaScriptServlet.getStaticServletConfig()) != null) {
            this.javascriptCacheControl = this.getProperty(JavaScriptConfigParameters.CACHE_CONTROL, servletConfig);
            this.javascriptTaggedCacheControl = this.getProperty(JavaScriptConfigParameters.CACHE_CONTROL_TAGGED, servletConfig);
            this.javascriptDomainStrict = this.getProperty(JavaScriptConfigParameters.DOMAIN_STRICT, servletConfig);
            this.javascriptInjectIntoAttributes = this.getProperty(JavaScriptConfigParameters.INJECT_INTO_ATTRIBUTES, servletConfig);
            this.javascriptInjectGetForms = this.getProperty(JavaScriptConfigParameters.INJECT_GET_FORMS, servletConfig);
            this.javascriptInjectFormAttributes = this.getProperty(JavaScriptConfigParameters.INJECT_FORM_ATTRIBUTES, servletConfig);
            this.javascriptInjectIntoForms = this.getProperty(JavaScriptConfigParameters.INJECT_INTO_FORMS, servletConfig);
            this.isJavascriptInjectIntoDynamicallyCreatedNodes = this.getProperty(JavaScriptConfigParameters.INJECT_INTO_DYNAMICALLY_CREATED_NODES, servletConfig);
            this.javascriptDynamicNodeCreationEventName = this.getProperty(JavaScriptConfigParameters.DYNAMIC_NODE_CREATION_EVENT_NAME, servletConfig);
            this.javascriptRefererPattern = Pattern.compile(this.getProperty(JavaScriptConfigParameters.REFERER_PATTERN, servletConfig));
            this.javascriptRefererMatchProtocol = this.getProperty(JavaScriptConfigParameters.REFERER_MATCH_PROTOCOL, servletConfig);
            this.javascriptRefererMatchDomain = this.getProperty(JavaScriptConfigParameters.REFERER_MATCH_DOMAIN, servletConfig);
            this.javascriptUnprotectedExtensions = this.getProperty(JavaScriptConfigParameters.UNPROTECTED_EXTENSIONS, servletConfig);
            this.javascriptXrequestedWith = this.getProperty(JavaScriptConfigParameters.X_REQUESTED_WITH, servletConfig);
            String javascriptSourceFileLocation = this.getProperty(JavaScriptConfigParameters.SOURCE_FILE_LOCATION, servletConfig);
            this.javascriptTemplateCode = PropertiesConfigurationProvider.retrieveJavaScriptTemplateCode(servletConfig, javascriptSourceFileLocation);
            this.javascriptParamsInitialized = true;
        }
    }

    private static String retrieveJavaScriptTemplateCode(ServletConfig servletConfig, String jsSourceFileLocation) {
        String result = null;
        if (StringUtils.isBlank((CharSequence)jsSourceFileLocation)) {
            result = CsrfGuardUtils.readResourceFileContent("META-INF/csrfguard.min.js");
        } else if (jsSourceFileLocation.startsWith("META-INF/")) {
            result = CsrfGuardUtils.readResourceFileContent(jsSourceFileLocation);
        } else if (jsSourceFileLocation.startsWith("classpath:")) {
            String location = jsSourceFileLocation.substring("classpath:".length()).trim();
            result = CsrfGuardUtils.readResourceFileContent(location);
        } else if (jsSourceFileLocation.startsWith("file:")) {
            String location = jsSourceFileLocation.substring("file:".length()).trim();
            result = CsrfGuardUtils.readFileContent(location);
        } else {
            try (InputStream inputStream = servletConfig.getServletContext().getResourceAsStream('/' + jsSourceFileLocation);){
                if (inputStream != null) {
                    result = CsrfGuardUtils.readInputStreamContent(inputStream);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Error while trying to close the '%s' resource.", jsSourceFileLocation));
            }
        }
        if (StringUtils.isBlank((CharSequence)result)) {
            throw new IllegalStateException("Error while trying to retrieve the JavaScript source code!");
        }
        return result;
    }

    private <T> T getProperty(JsConfigParameter<T> jsConfigParameter, ServletConfig servletConfig) {
        return jsConfigParameter.getProperty(servletConfig, this.propertiesCache);
    }

    private void initializeTokenPersistenceConfigurations(Properties properties) throws InstantiationException, IllegalAccessException {
        String logicalSessionExtractorName = PropertyUtils.getProperty(properties, "org.owasp.csrfguard.LogicalSessionExtractor");
        if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{logicalSessionExtractorName})) {
            throw new IllegalArgumentException(String.format("Mandatory parameter [%s] is missing from the configuration!", "org.owasp.csrfguard.LogicalSessionExtractor"));
        }
        this.logicalSessionExtractor = (LogicalSessionExtractor)CsrfGuardUtils.forName(logicalSessionExtractorName).newInstance();
        String tokenHolderClassName = (String)StringUtils.defaultIfBlank((CharSequence)PropertyUtils.getProperty(properties, ConfigParameters.TOKEN_HOLDER), (CharSequence)((String)ConfigParameters.TOKEN_HOLDER.getValue()));
        this.tokenHolder = (TokenHolder)CsrfGuardUtils.forName(tokenHolderClassName).newInstance();
    }

    private int getTokenLength(Properties properties) {
        int tokenLength = PropertyUtils.getProperty(properties, ConfigParameters.TOKEN_LENGTH);
        if (tokenLength < 4) {
            throw new IllegalArgumentException("The token length cannot be less than 4 characters. The recommended default value is: " + ConfigParameters.TOKEN_LENGTH.getDefaultValue());
        }
        return tokenLength;
    }

    private SecureRandom getSecureRandomInstance(Properties properties) {
        String algorithm = PropertyUtils.getProperty(properties, ConfigParameters.PRNG);
        String provider = PropertyUtils.getProperty(properties, ConfigParameters.PRNG_PROVIDER);
        return this.getSecureRandomInstance(algorithm, provider);
    }

    private SecureRandom getSecureRandomInstance(String algorithm, String provider) {
        SecureRandom secureRandom;
        try {
            secureRandom = Objects.nonNull(provider) ? (Objects.nonNull(algorithm) ? SecureRandom.getInstance(algorithm, provider) : this.getDefaultSecureRandom()) : (Objects.nonNull(algorithm) ? SecureRandom.getInstance(algorithm) : this.getDefaultSecureRandom());
        }
        catch (NoSuchProviderException e) {
            LOGGER.warn("The configured Secure Random Provider '{}' was not found, trying default providers.", (Object)provider);
            LOGGER.info(PropertiesConfigurationProvider.getAvailableSecureRandomProvidersAndAlgorithms());
            secureRandom = this.getSecureRandomInstance(algorithm, null);
            this.logDefaultPrngProviderAndAlgorithm(secureRandom);
        }
        catch (NoSuchAlgorithmException nse) {
            LOGGER.warn("The configured Secure Random Algorithm '{}' was not found, reverting to system defaults.", (Object)algorithm);
            LOGGER.info(PropertiesConfigurationProvider.getAvailableSecureRandomProvidersAndAlgorithms());
            secureRandom = this.getSecureRandomInstance(null, null);
        }
        return secureRandom;
    }

    private SecureRandom getDefaultSecureRandom() {
        SecureRandom defaultSecureRandom = new SecureRandom();
        this.logDefaultPrngProviderAndAlgorithm(defaultSecureRandom);
        return defaultSecureRandom;
    }

    private void logDefaultPrngProviderAndAlgorithm(SecureRandom defaultSecureRandom) {
        LOGGER.info("Using default Secure Random Provider '{}' and '{}' Algorithm.", (Object)defaultSecureRandom.getProvider().getName(), (Object)defaultSecureRandom.getAlgorithm());
    }

    private static String getAvailableSecureRandomProvidersAndAlgorithms() {
        String prefix = "Available Secure Random providers and algorithms:" + System.lineSeparator();
        return Stream.of(Security.getProviders()).map(Provider::getServices).flatMap(Collection::stream).filter(service -> SecureRandom.class.getSimpleName().equals(service.getType())).map(service -> String.format("\tProvider: %s | Algorithm: %s", service.getProvider().getName(), service.getAlgorithm())).collect(Collectors.joining(System.lineSeparator(), prefix, ""));
    }
}

