/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.config;

import java.security.SecureRandom;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.owasp.csrfguard.action.IAction;
import org.owasp.csrfguard.token.storage.LogicalSessionExtractor;
import org.owasp.csrfguard.token.storage.TokenHolder;

public interface ConfigurationProvider {
    public boolean isCacheable();

    public boolean isPrintConfig();

    public String getTokenName();

    public boolean isValidateWhenNoSessionExists();

    public int getTokenLength();

    public boolean isRotateEnabled();

    public boolean isTokenPerPageEnabled();

    public boolean isTokenPerPagePrecreateEnabled();

    public SecureRandom getPrng();

    public String getNewTokenLandingPage();

    public boolean isUseNewTokenLandingPage();

    public boolean isAjaxEnabled();

    public boolean isProtectEnabled();

    public boolean isForceSynchronousAjax();

    public Set<String> getProtectedPages();

    public Set<String> getUnprotectedPages();

    public Set<String> getProtectedMethods();

    public Set<String> getUnprotectedMethods();

    public Set<String> getBannedUserAgentProperties();

    public boolean isEnabled();

    public List<IAction> getActions();

    public boolean isJavascriptDomainStrict();

    public String getDomainOrigin();

    public String getJavascriptCacheControl();

    public String getJavascriptTaggedCacheControl();

    public Pattern getJavascriptRefererPattern();

    public void initializeJavaScriptConfiguration();

    public boolean isJavascriptInjectGetForms();

    public boolean isJavascriptInjectFormAttributes();

    public boolean isJavascriptInjectIntoForms();

    public boolean isJavascriptRefererMatchProtocol();

    public boolean isJavascriptRefererMatchDomain();

    public boolean isJavascriptInjectIntoAttributes();

    public boolean isJavascriptInjectIntoDynamicallyCreatedNodes();

    public String getJavascriptDynamicNodeCreationEventName();

    public String getJavascriptXrequestedWith();

    public String getJavascriptTemplateCode();

    public String getJavascriptUnprotectedExtensions();

    public TokenHolder getTokenHolder();

    public LogicalSessionExtractor getLogicalSessionExtractor();

    public Duration getPageTokenSynchronizationTolerance();
}

