/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.config.properties;

import java.util.Arrays;
import java.util.Collection;

public enum HttpMethod {
    GET,
    HEAD,
    POST,
    PUT,
    DELETE,
    TRACE,
    OPTIONS,
    CONNECT,
    PATCH;


    public static void validate(Collection<String> httpMethods) {
        httpMethods.forEach(HttpMethod::validate);
    }

    public static void validate(String input) {
        Arrays.stream(HttpMethod.values()).filter(value -> input.equalsIgnoreCase(value.toString())).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("The provided input '%s' is not a valid HTTP method!", input)));
    }
}

