/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Objects;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.owasp.csrfguard.CsrfGuard;
import org.owasp.csrfguard.CsrfGuardException;
import org.owasp.csrfguard.ProtectionResult;
import org.owasp.csrfguard.action.IAction;
import org.owasp.csrfguard.servlet.JavaScriptServlet;
import org.owasp.csrfguard.session.LogicalSession;
import org.owasp.csrfguard.token.businessobject.TokenBO;
import org.owasp.csrfguard.token.mapper.TokenMapper;
import org.owasp.csrfguard.token.service.TokenService;
import org.owasp.csrfguard.token.transferobject.TokenTO;
import org.owasp.csrfguard.util.CsrfGuardUtils;
import org.owasp.csrfguard.util.RegexValidationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CsrfValidator {
    private final CsrfGuard csrfGuard = CsrfGuard.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(CsrfValidator.class);

    public boolean isValid(HttpServletRequest request, HttpServletResponse response) {
        boolean isValid;
        String normalizedResourceURI = CsrfGuardUtils.normalizeResourceURI(request);
        ProtectionResult protectionResult = this.isProtectedPageAndMethod(request);
        if (protectionResult.isProtected()) {
            LOGGER.debug("CSRFGuard analyzing protected resource: '{}'", (Object)normalizedResourceURI);
            isValid = this.isTokenValidInRequest(request, response, protectionResult.getResourceIdentifier());
        } else {
            LOGGER.debug("Unprotected page: '{}'", (Object)normalizedResourceURI);
            isValid = true;
        }
        return isValid;
    }

    public ProtectionResult isProtectedPageAndMethod(String page, String method) {
        String normalizedResourceUri = CsrfGuardUtils.normalizeResourceURI(page);
        ProtectionResult protectionResult = this.isProtectedPage(normalizedResourceUri);
        return protectionResult.isProtected() && this.isProtectedMethod(method) ? protectionResult : new ProtectionResult(false, normalizedResourceUri);
    }

    public ProtectionResult isProtectedPage(String normalizedResourceUri) {
        ProtectionResult protectionResult = JavaScriptServlet.getJavascriptUris().contains(normalizedResourceUri) ? new ProtectionResult(false, normalizedResourceUri) : (this.csrfGuard.isProtectEnabled() ? this.isUriMatch(normalizedResourceUri, this.csrfGuard.getProtectedPages(), v -> v, false) : this.isUriMatch(normalizedResourceUri, this.csrfGuard.getUnprotectedPages(), v -> new ProtectionResult(false, v.getResourceIdentifier()), true));
        return protectionResult;
    }

    private static boolean isUriPathMatch(String configuredPageUri, String requestUri) {
        return configuredPageUri.equals("/*") || configuredPageUri.endsWith("/*") && configuredPageUri.regionMatches(0, requestUri, 0, configuredPageUri.length() - 2) && (requestUri.length() == configuredPageUri.length() - 2 || '/' == requestUri.charAt(configuredPageUri.length() - 2));
    }

    private static boolean isExtensionMatch(String testPath, String requestPath) {
        boolean result;
        if (StringUtils.startsWith((CharSequence)testPath, (CharSequence)"*.")) {
            int slash = requestPath.lastIndexOf(47);
            int period = requestPath.lastIndexOf(46);
            result = slash >= 0 && period > slash && period != requestPath.length() - 1 && requestPath.length() - period == testPath.length() - 1 ? testPath.regionMatches(2, requestPath, period + 1, testPath.length() - 2) : false;
        } else {
            result = false;
        }
        return result;
    }

    private ProtectionResult isUriMatch(String normalizedResourceUri, Set<String> pages, UnaryOperator<ProtectionResult> operator, boolean isProtected) {
        for (String page : pages) {
            ProtectionResult protectionResult = this.isUriMatch(page, normalizedResourceUri);
            if (!protectionResult.isProtected()) continue;
            return (ProtectionResult)operator.apply(protectionResult);
        }
        return new ProtectionResult(isProtected, normalizedResourceUri);
    }

    private TokenService getTokenService() {
        return new TokenService(this.csrfGuard);
    }

    private ProtectionResult isProtectedPageAndMethod(HttpServletRequest request) {
        return this.isProtectedPageAndMethod(request.getRequestURI(), request.getMethod());
    }

    private boolean isProtectedMethod(String method) {
        Set<String> unprotectedMethods;
        boolean isProtected = true;
        Set<String> protectedMethods = this.csrfGuard.getProtectedMethods();
        if (!protectedMethods.isEmpty() && !protectedMethods.contains(method)) {
            isProtected = false;
        }
        if (!(unprotectedMethods = this.csrfGuard.getUnprotectedMethods()).isEmpty() && unprotectedMethods.contains(method)) {
            isProtected = false;
        }
        return isProtected;
    }

    private ProtectionResult isUriMatch(String configuredPageUri, String requestUri) {
        if (Objects.nonNull(configuredPageUri)) {
            if (configuredPageUri.equals(requestUri) || CsrfValidator.isUriPathMatch(configuredPageUri, requestUri) || CsrfValidator.isExtensionMatch(configuredPageUri, requestUri)) {
                return new ProtectionResult(true, requestUri);
            }
            if (this.isUriRegexMatch(configuredPageUri, requestUri)) {
                return new ProtectionResult(true, configuredPageUri);
            }
            return new ProtectionResult(false, requestUri);
        }
        return new ProtectionResult(false, requestUri);
    }

    private boolean isUriRegexMatch(String configuredPageUri, String requestUri) {
        return RegexValidationUtil.isTestPathRegex(configuredPageUri) && this.csrfGuard.getRegexPatternCache().computeIfAbsent(configuredPageUri, k -> Pattern.compile(configuredPageUri)).matcher(requestUri).matches();
    }

    private boolean isTokenValidInRequest(HttpServletRequest request, HttpServletResponse response, String resourceIdentifier) {
        boolean isValid = false;
        CsrfGuard csrfGuard = CsrfGuard.getInstance();
        LogicalSession logicalSession = csrfGuard.getLogicalSessionExtractor().extract(request);
        if (Objects.nonNull(logicalSession)) {
            String logicalSessionKey;
            TokenService tokenService = this.getTokenService();
            String masterToken = tokenService.getMasterToken(logicalSessionKey = logicalSession.getKey());
            if (Objects.nonNull(masterToken)) {
                try {
                    TokenBO tokenBO = tokenService.verifyToken(request, resourceIdentifier, logicalSessionKey, masterToken);
                    TokenTO tokenTO = csrfGuard.isRotateEnabled(request) ? tokenService.rotateUsedToken(logicalSessionKey, resourceIdentifier, tokenBO) : TokenMapper.toTransferObject(tokenBO);
                    CsrfGuardUtils.addResponseTokenHeader(csrfGuard, request, response, tokenTO);
                    isValid = true;
                }
                catch (CsrfGuardException e) {
                    this.callActionsOnError(request, response, e);
                }
            } else {
                this.callActionsOnError(request, response, new CsrfGuardException("The token should exist in the storage at this point"));
            }
        } else {
            this.callActionsOnError(request, response, new CsrfGuardException("The token should exist in the storage at this point"));
        }
        return isValid;
    }

    private void callActionsOnError(HttpServletRequest request, HttpServletResponse response, CsrfGuardException csrfGuardException) {
        for (IAction action : this.csrfGuard.getActions()) {
            try {
                action.execute(request, response, csrfGuardException, this.csrfGuard);
            }
            catch (CsrfGuardException exception) {
                LOGGER.error(String.format("Error while executing action '%s'", action.getName()), (Throwable)exception);
            }
        }
    }
}

