/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.token;

import org.owasp.csrfguard.CsrfGuard;
import org.owasp.csrfguard.exception.CSRFGuardTokenException;
import org.owasp.csrfguard.util.RandomGenerator;

public final class TokenUtils {
    private TokenUtils() {
    }

    public static String generateRandomToken() {
        try {
            CsrfGuard csrfGuard = CsrfGuard.getInstance();
            return RandomGenerator.generateRandomId(csrfGuard.getPrng(), csrfGuard.getTokenLength());
        }
        catch (Exception e) {
            String errorLiteral = "Unable to generate the Random Token - %s";
            throw new CSRFGuardTokenException(String.format("Unable to generate the Random Token - %s", e.getLocalizedMessage()), e);
        }
    }
}

