/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.maxsat;

import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.maxsat.UnitWeightedClause;
import org.sat4j.maxsat.WeightedPartialMaxsat;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.OptToPBSATAdapter;
import org.sat4j.pb.PseudoOptDecorator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.RandomAccessModel;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;

public class MaxHSLikeSolver
extends SolverDecorator<ISolver>
implements WeightedPartialMaxsat {
    private static final long serialVersionUID = 1L;
    private final IPBSolver hsfinder;
    private final IVecInt lits = new VecInt();
    private final IVec<BigInteger> coefs = new Vec();
    private final ObjectiveFunction obj = new ObjectiveFunction(this.lits, this.coefs);
    private final Set<Integer> unitClauses = new HashSet<Integer>();
    private BigInteger falsifiedWeight = BigInteger.ZERO;
    private boolean maxVarIdFixed = false;
    protected BigInteger top = SAT4J_MAX_BIG_INTEGER;

    public MaxHSLikeSolver(IPBSolver pbsolver, ISolver satsolver) {
        super(satsolver);
        this.hsfinder = new OptToPBSATAdapter((IOptimizationProblem)new PseudoOptDecorator(pbsolver));
        this.hsfinder.setObjectiveFunction(this.obj);
    }

    public IConstr addClause(IVecInt literals) throws ContradictionException {
        return this.addSoftClause(1, literals);
    }

    public void reset() {
        this.decorated().reset();
        this.hsfinder.reset();
    }

    @Override
    public IConstr addHardClause(IVecInt literals) throws ContradictionException {
        return this.decorated().addClause(literals);
    }

    @Override
    public IConstr addSoftClause(IVecInt literals) throws ContradictionException {
        return this.addSoftClause(1, literals);
    }

    @Override
    public void setTopWeight(BigInteger top) {
        this.top = top;
    }

    public int newVar(int howmany) {
        int res = super.newVar(howmany);
        this.maxVarIdFixed = true;
        return res;
    }

    public void setExpectedNumberOfClauses(int nb) {
        this.lits.ensure(nb);
        this.falsifiedWeight = BigInteger.ZERO;
        super.setExpectedNumberOfClauses(nb);
    }

    protected void checkMaxVarId() {
        if (!this.maxVarIdFixed) {
            throw new IllegalStateException("Please call newVar(int) before adding constraints!!!");
        }
    }

    @Override
    public IConstr addSoftClause(int weight, IVecInt literals) throws ContradictionException {
        return this.addSoftClause(BigInteger.valueOf(weight), literals);
    }

    @Override
    public IConstr addSoftClause(BigInteger weight, IVecInt literals) throws ContradictionException {
        IConstr constr;
        this.checkMaxVarId();
        if (weight.compareTo(this.top) < 0) {
            if (literals.size() == 1) {
                int lit = -literals.get(0);
                int index = this.lits.containsAt(lit);
                this.unitClauses.add(-lit);
                if (index == -1) {
                    index = this.lits.containsAt(-lit);
                    if (index != -1) {
                        this.falsifiedWeight = this.falsifiedWeight.add(weight);
                        BigInteger oldw = (BigInteger)this.coefs.get(index);
                        BigInteger diff = oldw.subtract(weight);
                        if (diff.signum() > 0) {
                            this.coefs.set(index, (Object)diff);
                        } else if (diff.signum() < 0) {
                            this.lits.set(index, lit);
                            this.coefs.set(index, (Object)diff.abs());
                            this.falsifiedWeight = this.falsifiedWeight.add(diff);
                        } else {
                            assert (diff.signum() == 0);
                            this.lits.delete(index);
                            this.coefs.delete(index);
                        }
                        this.obj.setCorrectionOffset(this.falsifiedWeight);
                    } else {
                        this.hsfinder.registerLiteral(lit);
                        this.lits.push(lit);
                        this.coefs.push((Object)weight);
                    }
                } else {
                    this.coefs.set(index, (Object)((BigInteger)this.coefs.get(index)).add(weight));
                }
                return UnitWeightedClause.instance();
            }
            this.coefs.push((Object)weight);
            int newvar = this.nextFreeVarId(true);
            this.hsfinder.registerLiteral(newvar);
            literals.push(newvar);
            this.lits.push(newvar);
        }
        if ((constr = this.decorated().addClause(literals)) == null && this.isVerbose()) {
            System.out.println(this.getLogPrefix() + " hard constraint " + literals + "(" + weight + ") is ignored");
        }
        return constr;
    }

    public boolean isSatisfiable(boolean global) throws TimeoutException {
        return this.isSatisfiable();
    }

    public boolean isSatisfiable(IVecInt assumps, boolean global) throws TimeoutException {
        throw new UnsupportedOperationException();
    }

    public boolean isSatisfiable() throws TimeoutException {
        VecInt hs = new VecInt(this.hsfinder.findModel());
        while (!this.decorated().isSatisfiable((IVecInt)hs)) {
            if (this.isVerbose()) {
                System.out.print(".");
            }
            IVecInt core = this.decorated().unsatExplanation();
            VecInt clause = new VecInt(core.size());
            IteratorInt it = core.iterator();
            while (it.hasNext()) {
                clause.push(-it.next());
            }
            try {
                this.hsfinder.addClause((IVecInt)clause);
            }
            catch (ContradictionException e) {
                return false;
            }
            hs = new VecInt(this.hsfinder.findModel());
        }
        return true;
    }

    public boolean isSatisfiable(IVecInt assumps) throws TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigInteger violatedWeight() {
        return this.hsfinder.getObjectiveFunction().calculateDegree((RandomAccessModel)this.hsfinder);
    }

    public String toString(String prefix) {
        return prefix + "MaxHS like optimization" + System.lineSeparator() + super.toString(prefix);
    }

    public String toString() {
        return "MaxHS like optimization " + super.toString();
    }
}

